# .NET Core 2.1.13 Update - September 10, 2019

.NET Core 2.1.13 is available for [download](2.1.13-download.md) and usage in your environment. This release includes .NET Core 2.1.13, ASP.NET Core 2.1.13 and the .NET Core SDK.

The September Update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download. Otherwise, the best version to download is [.NET Core SDK 2.1.802](2.1.802-download.md).

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Any supported | Command line and/or Visual Studio Code | [2.1.802](2.1.802-download.md) |
| Windows | Visual Studio 2019 version 16.2 | [2.1.802](2.1.802-download.md) |
| Windows | Visual Studio 2019 version 16.0 | [2.1.606](2.1.606-download.md) |
| Windows | Visual Studio 2017 | [2.1.509](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2113)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.1-known-issues.md)

We've created an issue at [dotnet/core #3345](https://github.com/dotnet/core/issues/3345) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://github.com/dotnet/dotnet-docker/blob/main/README.md)
* [microsoft/dotnet-samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)

The images are expected to be available later today.

### Azure AppServices

* .NET Core 2.1.13 is being deployed to Azure App Services and the deployment is expected to complete later in September 2019.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](../../../os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 2.1.13

.NET Core 2.1.13 release carries both security and non-security fixes.

### [CVE-2019-1302: ASP.NET Core Elevation Of Privilege Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-1302)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of an elevation of privilege vulnerability exists when a ASP.NET Core web application, created using vulnerable project templates, fails to properly sanitize web requests. An attacker who successfully exploited this vulnerability could perform content injection attacks and run script in the security context of the logged-on user.

To exploit the vulnerability, an attacker could send a specially crafted email, containing a malicious link, to a user. Alternatively, an attacker could use a chat client to social engineer a user into clicking the malicious link. However, in all cases to exploit this vulnerability a user must click a maliciously crafted link from an attacker.

The update addresses the vulnerability by correcting how the .NET Core web application handles content encoding and updates the application templates to depend on the corrected code libraries.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.SpaServices  | 2.1.0-2.1.2 <br/> 2.2.0 | 2.1.2 <br/> 2.2.1

### [CVE-2019-1301: Denial of Service Vulnerability in .NET Core](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-1301)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability when .NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against a .NET Core web application. The vulnerability can be exploited remotely, without authentication.

The update addresses the vulnerability by correcting how the .NET Core web application handles web requests.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
System.Net.Sockets | 4.3.0 | 4.3.1
Microsoft.NetCore.App | 2.1.0 - 2.1.12 <br/> 2.2.0 - 2.2.6 | 2.1.13 <br/> 2.2.7

### [CVE-2018-8269: Denial of Service Vulnerability in OData](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2018-8269)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service attack in the Microsoft OData library used in ASP.NET could cause a denial of service against an OData web application. A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the OData application.

The update addresses the vulnerability by updating the version of OData ASP.NET Core uses.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.DataProtection.AzureStorage | 2.1.0 - 2.1.12 <br/> 2.2.0 - 2.2.6  | 2.1.13 <br/> 2.2.7
Microsoft.Data.OData.dll                         | < 5.8.4             | 5.8.5
Microsoft.AspNetCore.All                         | 2.1.0 - 2.1.12 <br/> 2.2.0 - 2.2.6 | 2.1.13 <br/> 2.2.7

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.1.13+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.13+label%3Aservicing-approved)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:2.1.13+label:servicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A2.1.13+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all.2.1.13.nupkg |
microsoft.aspnetcore.app.2.1.13.nupkg |
microsoft.aspnetcore.dataprotection.azurestorage.2.1.13.nupkg |
microsoft.aspnetcore.spaservices.2.1.13.nupkg |
microsoft.dotnet.web.client.itemtemplates.2.1.13.nupkg |
microsoft.dotnet.web.itemtemplates.2.1.13.nupkg |
microsoft.dotnet.web.projecttemplates.2.1.2.1.13.nupkg |
microsoft.dotnet.web.spa.projecttemplates.2.1.2.1.13.nupkg |
microsoft.netcore.platforms | 2.1.13
microsoft.netcore.app | 2.1.13
microsoft.netcore.dotnetapphost | 2.1.13
microsoft.netcore.dotnethost | 2.1.13
microsoft.netcore.dotnethostpolicy | 2.1.13
microsoft.netcore.dotnethostresolver | 2.1.13
runtime.linux-arm.microsoft.netcore.app | 2.1.13
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.13
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.13
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.linux-arm64.microsoft.netcore.app | 2.1.13
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.13
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.13
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.13
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.13
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.13
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.linux-x64.microsoft.netcore.app | 2.1.13
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.13
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.13
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.osx-x64.microsoft.netcore.app | 2.1.13
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.13
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.13
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.13
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.13
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.13
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.win-arm.microsoft.netcore.app | 2.1.13
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.13
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.13
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.win-arm64.microsoft.netcore.app | 2.1.13
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.13
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.13
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.win-x64.microsoft.netcore.app | 2.1.13
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.13
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.13
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.13
runtime.win-x86.microsoft.netcore.app | 2.1.13
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.13
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.13
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.13
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.13

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.13.md

[//]: # ( Runtime 2.1.13)
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/070b4126-8c0c-445f-8c0e-7a29963b0a1c/d50548fc04e2e0063dad4fda8232cd9d/dotnet-hosting-2.1.13-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4f9988da-8a62-4e01-9978-d9f1dd4fc386/3acb243f96e8e20b6774c64694d478ce/dotnet-runtime-2.1.13-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/395351ee-1d85-4e80-b0fb-1e694afe93cc/6fe9c98d5a6c07e42ddb406bbb4d762a/dotnet-runtime-2.1.13-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8aaca805-963d-40f0-96c6-e709c95d2133/54b61a71e726f425b56ed3560c1ff61b/dotnet-runtime-2.1.13-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7085b86a-0888-49b5-a272-6cd317abc4d3/1d5d8107d575e7fc8b14e9ace9f7667b/dotnet-runtime-2.1.13-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9314da31-774c-4d2b-8743-998f2a21f5ab/bc918ca05ab6b650f2991b205c04f623/dotnet-runtime-2.1.13-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/de616a20-413b-4790-860c-5a0a49febb11/65d8aea6c240dfeced318b447bb67c25/dotnet-runtime-2.1.13-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8684dc18-a9f7-4f11-94d1-833f69a6b927/9066251f09cc77b467b743c2472d27bd/dotnet-runtime-2.1.13-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/23a290e2-7369-4635-a958-19b8c490463f/d2f85f8bfad3d461ce0c7edd7d2f7608/dotnet-runtime-2.1.13-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d046f80d-8ad4-4bb9-8db6-8510105de979/07319c666f9951e15c607aed260ab12d/dotnet-runtime-2.1.13-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/6c077613-cbf5-4c3c-a32b-d1d20db9c779/b314a6cd36cde83337ebb2888c905eb2/dotnet-runtime-2.1.13-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a3d47757-7f32-47ae-a5c8-8f65ee585427/f7099b92d78e2be2076e268d8bdfe73a/dotnet-runtime-2.1.13-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/21adb9db-dd8d-4da6-800d-fbc35f5d3c01/b8ff1419088cca7caf210c05455c39be/dotnet-runtime-2.1.13-win-x86.zip

[//]: # ( ASP 2.1.13)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39d580d6-da0b-42e3-9bbe-3fd2efec71ac/594ae2dde78da0e8b9e1cc7476cee470/aspnetcore-runtime-2.1.13-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44f47739-9da8-4a46-85dc-ba60dbfc68e4/ea951070fa4740d784ef3190ef304cc0/aspnetcore-runtime-2.1.13-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/88fdaf6f-08ea-4d1c-856d-60f78a7d733a/2e70e89c45dc9a8d701b544edc2bb5a1/aspnetcore-runtime-2.1.13-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c83b8179-7c67-4043-875d-9c24e5c47d6e/de30706a2fe9c644da9005e6ce12d4ec/aspnetcore-runtime-2.1.13-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/69d3ca05-a3f7-493c-816d-4b6ff0d9adeb/52de650ab7f96968e2718c418ac3d206/aspnetcore-runtime-2.1.13-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5b8b3f47-551f-4003-8be8-071cfc0291f8/aae98ecf3c39961994dad92d9b46734e/aspnetcore-runtime-2.1.13-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/63db7be7-97b7-466c-8d77-253fffbc62c1/0c08d7f22a4e3433b21bad9219dbae22/aspnetcore-runtime-2.1.13-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f3d7e5b5-b51c-4bba-8432-8d6cfccda545/71effb4c66d75320f542b20b34cee097/aspnetcore-runtime-2.1.13-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/070b4126-8c0c-445f-8c0e-7a29963b0a1c/d50548fc04e2e0063dad4fda8232cd9d/dotnet-hosting-2.1.13-win.exe

[//]: # ( SDK 2.1.509 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b8e7a0d-6d87-4413-8b9a-9fb5d15ec8ff/b4e227b27610a08e8d92b0d676baf416/dotnet-sdk-2.1.509-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f086b739-0a60-4a8f-b81c-51aea991268a/1a75e818f7e0a2ea24180f7f31bbde64/dotnet-sdk-2.1.509-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/07311286-07f4-428f-a746-0e39eb5e5b1c/1728025252566f7f7942950bf351f49c/dotnet-sdk-2.1.509-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32f77b1c-0d62-4b4b-a263-c91f5e886da1/ca1a4771ac2a8c2d8bdae302aa43ce84/dotnet-sdk-2.1.509-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b03b2d53-5c82-471a-b263-71e59db10737/683146f10e503f20ab630a7fd950b7ee/dotnet-sdk-2.1.509-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5814f015-78b1-46e0-a026-9bd9a20d7cfa/3ee752114e9de242aed455364d584ad6/dotnet-sdk-2.1.509-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c593b11-32b4-4b09-a9be-1ff7d9e46985/df8f672185d4846d42b2f2cc64bf55e3/dotnet-sdk-2.1.509-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e93f0f95-6bf6-4ff9-abbe-d9c995aeb090/c62c4b5dc10ea76578043413b6997a57/dotnet-sdk-2.1.509-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/eaba49da-d09d-4a62-a0cf-abc1b65869a8/3ab16b7f76242750ffa0d15da56fa219/dotnet-sdk-2.1.509-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c9679ad2-460d-4305-9607-5e694ac0fe62/acf83728e81a584633b408fb1ca125ad/dotnet-sdk-2.1.509-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/034f259e-ee9d-48b9-bbfa-ccdb3a709159/af839bdc304e1ad1725d4114aefcd0ee/dotnet-sdk-2.1.509-win-x86.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.13-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.13-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-september-2019/
