# .NET Core 2.1.17 Update - March 24, 2020

[.NET Core 2.1.17](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.17, ASP.NET Core 2.1.17 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2117)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4453](https://github.com/dotnet/core/issues/4453) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.610](2.1.610-download.md) |
| Windows | Visual Studio 2017 | [2.1.513](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update will not be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's March servicing release.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.17 is being deployed to Azure App Services and the deployment is expected to complete later in March 2020.

## Changes in 2.1.17

.NET Core 2.1.17 release carries only non-security fixes.

* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.1.17+label%3Aservicing-approved)


## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.17
microsoft.aspnetcore.app | 2.1.17
microsoft.dotnet.web.client.itemtemplates | 2.1.17
microsoft.dotnet.web.itemtemplates | 2.1.17
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.17
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.17
microsoft.netcore.platforms | 2.1.9
system.buffers | 4.5.1
system.memory | 4.5.4
system.runtime.compilerservices.unsafe | 4.5.3
system.threading.tasks.extensions | 4.5.4
microsoft.netcore.app | 2.1.17
microsoft.netcore.dotnetapphost | 2.1.17
microsoft.netcore.dotnethost | 2.1.17
microsoft.netcore.dotnethostpolicy | 2.1.17
microsoft.netcore.dotnethostresolver | 2.1.17
runtime.linux-arm.microsoft.netcore.app | 2.1.17
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.17
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.17
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.linux-arm64.microsoft.netcore.app | 2.1.17
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.17
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.17
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.17
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.17
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.17
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.linux-x64.microsoft.netcore.app | 2.1.17
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.17
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.17
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.osx-x64.microsoft.netcore.app | 2.1.17
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.17
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.17
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.17
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.17
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.17
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.win-arm.microsoft.netcore.app | 2.1.17
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.17
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.17
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.win-arm64.microsoft.netcore.app | 2.1.17
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.17
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.17
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.win-x64.microsoft.netcore.app | 2.1.17
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.17
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.17
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.17
runtime.win-x86.microsoft.netcore.app | 2.1.17
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.17
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.17
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.17
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.17
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.17
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.17
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.17
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.17
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.17
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.17


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.17.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.17-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.17-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-march-2020/



[//]: # ( Runtime 2.1.17)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ccc989da-fa6c-4b1b-a8a8-ed43ab4bba38/77e9e57aa69a2a84f1a45e861cc4eed5/dotnet-runtime-2.1.17-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b97e7fa1-cf7b-4b5e-a7a6-33d124c1d2ee/2d67061cda10b4470cebdb6c36271095/dotnet-runtime-2.1.17-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fb5b99ef-e59f-43e4-a193-344774d942c3/016338b54b1ec63bd0400039f763e25d/dotnet-runtime-2.1.17-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a668ac5e-ffcc-419a-8c82-9e5feb7b2619/4108ef8aede75bbb569a359dff689c5c/dotnet-runtime-2.1.17-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9d3edcf8-2da1-42eb-a30f-54d629c8f13f/2e967304f8f3543c7329fd53d292d076/dotnet-runtime-2.1.17-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5f8d9bb7-854f-4527-96aa-21b40d3119f5/f6d703007d9fe5ddb701ba6006107e3a/dotnet-runtime-2.1.17-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a0192c8e-55a5-4633-8e5f-afd80fac844f/017b5bac907f9423a4ec7867370b2507/dotnet-runtime-2.1.17-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8b88b38d-d7d6-4d48-b88f-ec1379b70095/35b5c60828d6419609b4b800d679da63/dotnet-runtime-2.1.17-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cd223083-8c0e-4963-9fcd-fcf01a55e56c/15500e764899442ed6e014687caa34e9/dotnet-runtime-2.1.17-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0c5dc823-e267-4c18-98d5-5b628ac9c2f9/6caf15ff4915b5cf650f202076601190/dotnet-runtime-2.1.17-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/73a0ea97-57d6-4263-ac36-ea3a9b373bcf/cd5f7e08e749c1d3468cdae89e4518de/dotnet-runtime-2.1.17-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8340237d-31bc-441c-bf06-ea6616c5dbc1/d35ed8467238a143eba7cb5d56f35f04/dotnet-runtime-2.1.17-win-x86.zip

[//]: # ( WindowsDesktop )

[//]: # ( ASP 2.1.17)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1a3c3183-ea43-4060-9205-09151a6ab9d7/6f15f282afcd70fffd8b9e12de4cd8b9/aspnetcore-runtime-2.1.17-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/468f500f-70d8-495c-b1ef-7110ff8f2298/39c0f5c364fc2550d70e6c45d21178ef/aspnetcore-runtime-2.1.17-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8074db1d-516d-44c9-abf5-5efe38752226/c809c044b639ce439d227c377dec2355/aspnetcore-runtime-2.1.17-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1df1dff-dceb-47ca-9dd5-f0e2bb44ca18/39bb8cfb345da8781d5242a985edf549/aspnetcore-runtime-2.1.17-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/68dbbf28-d2e1-4c08-b7ac-d990145da30d/d7ecd369a082efeff6eeb13b18c64c51/aspnetcore-runtime-2.1.17-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f7cbebdd-483d-49d5-a4e1-58daa4394cf0/432798505655e71306b0dc32303116ab/aspnetcore-runtime-2.1.17-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/03cad191-be9a-479b-9818-7e6fd624c416/b223c16c8b0a410cb18075f1daa4361a/aspnetcore-runtime-2.1.17-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/716779cc-a73c-435d-8bdb-51de7aa53dea/82dbf4805c74dd4282ad4072ba5b74be/aspnetcore-runtime-2.1.17-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a431ea89-07d9-4533-9d72-fd246bd2efc7/5bbc08f02800c08b69bce56d03723f18/dotnet-hosting-2.1.17-win.exe

[//]: # ( SDK 2.1.513 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/57f9cd18-9b8f-4a8e-8351-be2b99f916aa/bd11ada55334e5a2aec761de27d2014b/dotnet-sdk-2.1.513-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5895a30-1e48-4efc-8706-c302928aa41c/7d0d6afcc387bb70215c1748e66aae87/dotnet-sdk-2.1.513-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7544f5cd-02d2-4771-a423-405bee6179d5/3d38dae240c37c592f54690b9e3df71b/dotnet-sdk-2.1.513-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8b5ae78f-c243-4289-a69f-c89e0446e236/7f3121df09b121f4ff68a301c4e7c754/dotnet-sdk-2.1.513-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f3d2ca2c-28ff-40a9-9010-609acc97478b/bb2dd02e4e400a58195ea6262810000d/dotnet-sdk-2.1.513-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0236c348-ce1d-4f62-a93f-91477b85a805/36748f94c071a800a46c58eb6a1ef835/dotnet-sdk-2.1.513-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2b60f78c-c70c-4a44-99b3-cf1815aea56f/368a9fd593269ad4021eca6e4078548e/dotnet-sdk-2.1.513-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/04625b40-1a59-4ddc-ada9-759e4756f3c4/282877c94233cd4f4932d1490d9a4460/dotnet-sdk-2.1.513-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d97936f1-c90f-48ce-b02e-7d74efa80f5a/170e7aa8ba67a6014438302076ed778c/dotnet-sdk-2.1.513-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1444bb33-479d-43b7-949a-0b69e9ee4ba9/86107542692885242ceadd02d72100dd/dotnet-sdk-2.1.513-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2c37816d-4e6e-4fe0-94c7-b921ec390abe/e3b4d7a26271fa90271b94b9b89023ff/dotnet-sdk-2.1.513-win-x86.zip

[//]: # ( Symbols )
