# .NET Core 2.1.20 Update - July 14, 2020

[.NET Core 2.1.20](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.20, ASP.NET Core 2.1.20 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2120)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4939](https://github.com/dotnet/core/issues/4939) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.613](2.1.613-download.md) |
| Windows | Visual Studio 2017 | [2.1.516](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update will not be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's March servicing release.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.20 is being deployed to Azure App Services and the deployment is expected to complete later in July 2020.

## Changes in 2.1.20

.NET Core 2.1.20 release carries both security and non-security fixes.

### [CVE-2020-1147 | NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1147)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a remote code execution vulnerability exists in .NET software when the software fails to check the source markup of an XML file. An attacker who successfully exploited the vulnerability could run arbitrary code in the context of the current user.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to an ASP.NET Core application, or other application that parses certain types of XML.

The security update addresses the vulnerability by restricting the types that are allowed to be present in the XML payload.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.20.nupkg
microsoft.aspnetcore.app | 2.1.20.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.20.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.20.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.20.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.20.nupkg
microsoft.netcore.app | 2.1.20.nupkg
microsoft.netcore.dotnetapphost | 2.1.20.nupkg
microsoft.netcore.dotnethost | 2.1.20.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.20.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.20.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.20.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.20.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.20.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.20.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.20.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.20.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.20.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.20.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.20.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.20.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.20.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.20.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.20-servicing-29019-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.20-servicing-29019-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.20-servicing-29019-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.20-servicing-29019-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.20-servicing-29019-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.20-servicing-29019-01.nupkg

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.20.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.20-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.20-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-june-2020-updates-2-1-19-and-3-1-5/

[//]: # ( Runtime 2.1.20)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dda6ad2b-9ac3-433d-ad09-7b4e2f9d2c68/56b428eb350634acb00cc28d0d36bf08/dotnet-runtime-2.1.20-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b6ba465b-6aaa-408c-9573-2880260eeba8/4c109a758b52266f4686f606c98a7cf1/dotnet-runtime-2.1.20-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/86cfc62a-1098-4f7c-8de8-77a7aee0befa/58261743b6417923d7e062fc1186f875/dotnet-runtime-2.1.20-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9cf1759a-46ee-449d-b5eb-3f855245c4c7/44b34ab2d89ac06fc621ad695498e689/dotnet-runtime-2.1.20-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5a175623-89a4-4cf5-b7ae-46d323f02df1/2c3bafdc54c9da352b2f1bd3fc515875/dotnet-runtime-2.1.20-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37f67936-d74a-4b1b-9c62-b71aa95972e5/c6eabaf75a472a4a88d56a8ee0206d1f/dotnet-runtime-2.1.20-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c396ecda-9f9f-4631-b984-6114ff205f77/1de891217d94f99139e136672e00b906/dotnet-runtime-2.1.20-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/653748ee-42bb-46f0-b6b8-5894c3a831d5/88894226cb03fe2fcd939ee75a384b44/dotnet-runtime-2.1.20-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3b7f548-4cb0-43f6-be68-7a7ac3855d17/a70d2570eac5e2dd8ca57b702336074e/dotnet-runtime-2.1.20-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/38d699f3-3ceb-4952-afb5-7b770cb60af1/bd49857a8755cf5d30274425f3f1623b/dotnet-runtime-2.1.20-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6a29a360-61df-4c06-af5b-c43c4da3ba0a/eb1e0c23ffc95d5f9d9b2aa0c103d034/dotnet-runtime-2.1.20-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/7545c5ac-694e-49d6-a4b2-aaf4c0287c60/6c2c622c1156f40f05f31d1e1bed387b/dotnet-runtime-2.1.20-win-x86.zip

[//]: # ( ASP 2.1.20)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/292e38b1-bab5-4b15-8659-dfe8e3d6841b/2ca074694939aa06709070ffa91fad53/aspnetcore-runtime-2.1.20-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/123cd951-e45d-477c-a4f2-c4fc4b8875f7/701f625ad38b7b3a4ffe5f400d528e0f/aspnetcore-runtime-2.1.20-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f71a9aa8-b3f4-4afd-8200-3baf39a88b6b/4f91b8b5df2117ba35acf008c88f89e3/aspnetcore-runtime-2.1.20-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce092775-e76f-44de-b166-24d5fb309d1c/44da312c8749621cf6d087c8279606bc/aspnetcore-runtime-2.1.20-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/dc9d0c4f-9826-43ff-ac08-ca40733ad372/36de3302a2d6c6cdebea8b7bf564c1b2/aspnetcore-runtime-2.1.20-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/302ed10c-e687-469c-a544-7e07b264caad/93b1e8e57f8e3f7d8ba360235a317700/aspnetcore-runtime-2.1.20-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2b4ee6af-f5c8-4901-bbca-50b8c3364d20/5a4860645c0efdba4ca6a6400dcbd525/aspnetcore-runtime-2.1.20-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0e437534-aab8-4f83-95fb-dd4e8275f5aa/e13004c1dc090c0bc4d4715766cf9bed/aspnetcore-runtime-2.1.20-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/fa2c9d72-dda4-4b9c-ae58-97d4f36dbd63/fb2dfa6b0fede5d060ee3bae9d4223f5/dotnet-hosting-2.1.20-win.exe

[//]: # ( SDK 2.1.516 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7cc26857-18f7-40ae-a576-3b54a75b590d/cbc4efe3eae0c080feec3e48823ee3ed/dotnet-sdk-2.1.516-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f443586c-e1ec-46a9-afb3-df704a19ed9d/ead202dab1081e7db91964854dc37dec/dotnet-sdk-2.1.516-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4d60e2f-eaf2-463a-ba43-f0584ad7aaef/690816d225e22583793e0c48ff10084b/dotnet-sdk-2.1.516-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f62fbdeb-f1d7-465e-b1a3-d8f98a2fff09/579924e27ffbd191d2f89cb4b8609cb6/dotnet-sdk-2.1.516-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3430b27f-f317-4736-a078-63b020936f92/b1fe7fd7e25ca936a7a82b29b065c4f9/dotnet-sdk-2.1.516-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/dcc39bef-6d9c-4204-9112-9f26f250df6f/4550be962b07d7560813e84f7f1cb1f9/dotnet-sdk-2.1.516-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/78b23a01-a88b-49bf-9122-c419dd73d715/20af288fb000e7e112671068ec566f98/dotnet-sdk-2.1.516-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/532fe2c7-0dee-4414-94e5-46ad5ec83ae2/e4581d469e21b6d2e76c203321b37d46/dotnet-sdk-2.1.516-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/55625a9c-d73a-4058-a033-ba2aaa3a1ba0/0fb63f2fb75dcc36b1ea168dc36d7ebe/dotnet-sdk-2.1.516-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ca5f3d0c-beb8-4cfc-80d1-12215bdfc812/e3d73358a9ec211dd2ecbe3ff2d0966d/dotnet-sdk-2.1.516-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dabfb483-1695-4bfc-9b59-9e63c01d5245/a749639a82dca8e27c27117e91a321b7/dotnet-sdk-2.1.516-win-x86.zip
