# .NET Core 2.1.22 Update - September 08, 2020

[.NET Core 2.1.22](https://dotnet.microsoft.com/download/dotnet/2.1) is available for download and usage in your environment. This release includes .NET Core 2.1.22, ASP.NET Core 2.1.22 and the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-2122)
* [Known Issues](../2.1-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5170](https://github.com/dotnet/core/issues/5170) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.1.615](2.1.615-download.md) |
| Windows | Visual Studio 2017 | [2.1.518](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update will not be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's September servicing release.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.1.22 is being deployed to Azure App Services and the deployment is expected to complete later in September 2020.

## Changes in 2.1.22

.NET Core 2.1.22 release carries both security and non-security fixes.

### [CVE-2020-1045 | Microsoft ASP.NET Core Security Feature Bypass Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-1045)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A security feature bypass vulnerability exists in the way Microsoft ASP.NET Core parses encoded cookie names.

The ASP.NET Core cookie parser decodes the cookie name which could allow a malicious attacker to use percent encoded characters to masquerade as a different cookie with different security features.

The security update addresses the vulnerability by fixing the way the ASP.NET Core cookie parser handles encoded names.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.22.nupkg
microsoft.aspnetcore.app | 2.1.22.nupkg
microsoft.aspnetcore.http | 2.1.22.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.22.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.22.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.22.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.22.nupkg
microsoft.netcore.platforms | 2.1.12.nupkg
microsoft.netcore.app | 2.1.22.nupkg
microsoft.netcore.dotnetapphost | 2.1.22.nupkg
microsoft.netcore.dotnethost | 2.1.22.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.22.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.22.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.22.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.22.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.22.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.22.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.22.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.22.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.22.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.22.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.22.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.22.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.22.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.22.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.22-servicing-29217-01.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.22-servicing-29221-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.22-servicing-29217-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.22-servicing-29221-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.22-servicing-29217-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.22-servicing-29221-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.22-servicing-29217-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.22-servicing-29221-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.22-servicing-29217-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.22-servicing-29221-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.22-servicing-29217-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.22-servicing-29221-01.nupkg

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.22.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.22-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.22-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-september-2020/

[//]: # ( Runtime 2.1.22)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9e4eb32-c7cf-4c72-a0e0-ddd558b8f1c3/c6001231fe12753a2bb195578d06f2d7/dotnet-runtime-2.1.22-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/20d112fa-1e6b-4393-ae2f-4eebefc4a0e6/fd6102804e1c011bb66d10f5a4ecdbc4/dotnet-runtime-2.1.22-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d4edeb5b-0f2c-4815-a838-e7e9037ed493/f0e16cdf1407f2a3046db15df84615c1/dotnet-runtime-2.1.22-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/926c221c-a9bd-4022-a0bd-52f93d273883/a8582353d501c69bd991c52a52d79bae/dotnet-runtime-2.1.22-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/015b68bb-865a-46bd-a0f4-a41014adf9e9/66f05c05c87943332b88e82cc6ad2d5f/dotnet-runtime-2.1.22-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a9df69ab-96df-4e3a-aa81-1ad6f42214f8/e23168c14104da0b96ddeaa9e170a726/dotnet-runtime-2.1.22-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4a599595-34de-4d7e-bdd1-e43c6bfe9df9/9b7545a027d88a07ba51401f71130ce4/dotnet-runtime-2.1.22-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/6c94d1ed-7565-448b-80f1-ce02f9143bb7/0c0298a69fb9d89157e1df6f0c3d5a67/dotnet-runtime-2.1.22-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4a4db39e-1c66-46f8-aa48-6c961a8d1630/887057b1bc6496eefc91f53dd476f48c/dotnet-runtime-2.1.22-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/56ecb704-094d-4a45-936b-4712b289dfb0/4e44d85b3dfc57c694364ca935c767de/dotnet-runtime-2.1.22-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f66c1d03-885b-490b-b7a2-9211590fa6cf/5d4dddfe5eaaf31b08bd34874a2cd3f5/dotnet-runtime-2.1.22-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/40d3383c-71f3-462e-84b3-48e11e1fd4b3/470d90f3c85132eb4225f455e73df5e6/dotnet-runtime-2.1.22-win-x86.zip

[//]: # ( ASP 2.1.22)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fe553baf-887f-4068-b7c8-6c37d93f5b39/e80ed0ad34dcc1281f4773cd3a38f821/aspnetcore-runtime-2.1.22-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/47464a6e-e3b1-4720-8578-69d1e68ad836/6619fdb296696e5abd9fdba5b7c30e38/aspnetcore-runtime-2.1.22-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1798274-4f4e-4e5b-8337-cb477add793c/2ab1c7f92fe497e07304b0b25c5f7845/aspnetcore-runtime-2.1.22-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c337ed3-0c8e-4fc0-bbf3-09f9a5e3e1e2/0c00fe3481c88527441c64f08695d171/aspnetcore-runtime-2.1.22-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/11be6114-f7ab-4098-8597-cc910432e39e/2a76468bce97162caab7ddebc8a7b5af/aspnetcore-runtime-2.1.22-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ba9eb0d8-4623-444a-ae62-86b995dc4e70/dce089b5d4d487800bb7db99015d8162/aspnetcore-runtime-2.1.22-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/df02bb74-1f76-4477-99ee-c623dd342af6/774002083dbd75244f926697d5520d89/aspnetcore-runtime-2.1.22-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ba5d7f7b-7f59-4b5f-a53e-429af11cab1d/0667719b018af6ba18ca1461b5b8b25d/aspnetcore-runtime-2.1.22-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/2fe0ef0c-a6b6-4cda-b6b8-874068bb131f/709d1c7817fa19524089dda74933ddce/dotnet-hosting-2.1.22-win.exe

[//]: # ( SDK 2.1.518 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/90eba1c6-8332-4a33-b459-cf9284be35cf/a64d52d2411925b0b81a4356cc8b3447/dotnet-sdk-2.1.518-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7d684eb-f71d-4073-b658-b23dccda3e23/59411c00f9e8496c5dd9460391bfd26c/dotnet-sdk-2.1.518-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c24968d1-472f-4c4a-a57f-07aff0ae5178/b9b348f5f4f4211c4a8432ebc1771778/dotnet-sdk-2.1.518-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5e5f121b-7870-43ef-8729-c16be9b4f378/bd3d27d822c178d94fc95dec14411e8b/dotnet-sdk-2.1.518-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/95486566-6122-44a9-bc1f-c6144f69fa2f/b67c569f875bc0b1aa0b386f36533de5/dotnet-sdk-2.1.518-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/089d443c-dcab-40c3-a449-37fdbfd92685/f5535317d14ed3157ab3cd66f4741fe6/dotnet-sdk-2.1.518-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6019cd0d-ac35-4051-94f9-4418fa8e702e/414020bcb4bba17335f6e168e6f06f85/dotnet-sdk-2.1.518-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/98bffd5f-9829-452b-abf1-ce9d94e5df4e/278aa5d8e79c8b716b3ddb19b2fcd4e1/dotnet-sdk-2.1.518-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8e97193d-6b27-4c56-a86e-0c8eb87d7f27/b515c24cc14bb2d791d57af3fd5919df/dotnet-sdk-2.1.518-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a1cac2a3-cf93-49f4-ad71-b9034c4ec920/f792386e2fc46f582427837531fb97cf/dotnet-sdk-2.1.518-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/4737bd46-09de-4f74-b5e1-3aa7f054a8b3/1a2bbbb46174ba809877fbf7fd40b76b/dotnet-sdk-2.1.518-win-x86.zip
