# .NET Core 2.1.25 Update - Febraury 09, 2021

The .NET 2.1.25 and .NET SDK 2.1.521 releases are available for download. The latest 2.1 release is always listed at [.NET 2.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
2.1.521
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.521](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update won't be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's January servicing release.

This update of .NET Core 2.1 is the last update for .NET Core 2.1.6xx SDK since [Visual Studio 16.0 is out of support](https://learn.microsoft.com/visualstudio/releases/2019/servicing) as of January 2021. We will continue to update versions 2.1.5xx and 2.1.8xx until [.NET Core 2.1 reaches end of life](https://github.com/dotnet/core/blob/main/releases.md).


## Notable Changes

.NET Core 2.1.25 release carries both security and non-security fixes.

### [CVE-2021-1721 | .NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-1721)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core and ASP.NET 5. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial-of-service vulnerability exists when creating HTTPS web request during X509 certificate chain building.

### [CVE-2021-24112 | .NET 5 and .NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2021-24112)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1, and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists when parsing certain types of graphics files. This vulnerability only exists on systems running on MacOS or Linux.

* [Blog Roundup][dotnet-blog]
* [Known issues](../2.1-known-issues.md)

### Additional fixes in this release

* [ASPNET](https://github.com/dotnet/aspnetcore/pulls?q=milestone%3A2.1.25+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #5932](https://github.com/dotnet/core/issues/5932) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.25.nupkg
microsoft.aspnetcore.app | 2.1.25.nupkg
microsoft.aspnetcore.server.kestrel.core | 2.1.25.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.25.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.25.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.25.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.25.nupkg
system.drawing.common | 4.5.2.nupkg
microsoft.netcore.app | 2.1.25.nupkg
microsoft.netcore.dotnetapphost | 2.1.25.nupkg
microsoft.netcore.dotnethost | 2.1.25.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.25.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.25.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.25.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.25.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.25.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.25.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.25.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.25.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.25.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.25.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.25.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.25.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.25.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.25.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.25-servicing-29719-01.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.25-servicing-29719-02.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.25-servicing-29720-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.25-servicing-29719-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.25-servicing-29719-02.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.25-servicing-29720-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.25-servicing-29719-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.25-servicing-29719-02.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.25-servicing-29720-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.25-servicing-29719-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.25-servicing-29719-02.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.25-servicing-29720-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.25-servicing-29719-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.25-servicing-29719-02.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.25-servicing-29720-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.25-servicing-29719-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.25-servicing-29719-02.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.25-servicing-29720-01.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.25.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.25-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.25-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-february-2021/


[//]: # ( Runtime 2.1.25)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c8f4ad57-229c-4204-973e-d9adc71accea/8507cbdbae5d88aa78e5f477790c3032/dotnet-runtime-2.1.25-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7d4ebac-5634-494b-ad88-c102a4cc4bdd/6db19514d887a971a85f53425a6ad2fb/dotnet-runtime-2.1.25-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/917b68aa-0307-4250-894e-a36495872241/8ef5422486a813a0a3387e1feb30cfce/dotnet-runtime-2.1.25-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19203a52-0453-4c37-b964-05ab5ca0e67c/0db9cc5de1de804740734ddb39cedb0a/dotnet-runtime-2.1.25-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/0e82b6c0-7791-4ebd-8e87-c09c9c5ec8a3/37b0ccc801d5bde7999982529d385e08/dotnet-runtime-2.1.25-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f3c6ad91-a67a-4020-bd22-516d8691c438/001740f092dff348c4e0b06acfd83eba/dotnet-runtime-2.1.25-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ce9bdda9-9bd3-4e80-9ca1-7cc2c4965636/05d725a7f74025cbf922f23c34c00478/dotnet-runtime-2.1.25-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0bb7128a-594b-4d6d-9e9e-1b83de2f004e/c7fc42c42b84ef4f856b8e25b001f5a6/dotnet-runtime-2.1.25-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/017feb75-60d8-4a90-9907-7f1cdaeaf11a/4a21019df08a0a6d84cc14511e202a93/dotnet-runtime-2.1.25-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/caa22019-110f-4631-a046-9b4c7b19b871/f5a0d5c8dfac46778e6f8ff4eced623e/dotnet-runtime-2.1.25-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/420e3a1d-4edd-4b01-bc42-101a95084966/6324c21c7445e0d90441f49631588b21/dotnet-runtime-2.1.25-win-x86.zip

[//]: # ( ASP 2.1.25)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/222ca907-5ffe-41e1-b221-91cb68d36909/02a203ff862bce166c579bafd47d9ac7/aspnetcore-runtime-2.1.25-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/129921c2-a0db-4869-8c3f-7de738830529/3efa531979a4d21d4c071eb80b689bd4/aspnetcore-runtime-2.1.25-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3b8d8ee1-0670-46d5-ae77-e824e716993e/cb4a0f5d98ff86578ee0cb95f6e34c8f/aspnetcore-runtime-2.1.25-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27814802-8ed9-455c-997a-613ae9cc5eb7/1e54e6e9f52277075cc5b0877eecd1e4/aspnetcore-runtime-2.1.25-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0e36b9e0-ca99-4418-a934-2bdd75174284/2c8230b36c2a94ad4500dfa5d8da14be/aspnetcore-runtime-2.1.25-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/5d96a0b6-db21-48b0-a363-c90bac0f52b1/cae46c7f5d98221cbb5893dc27a90f31/aspnetcore-runtime-2.1.25-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6a761e4a-87bd-4404-a04a-19b31e70ae5d/1675575f20362801f958585e2e58ad4c/aspnetcore-runtime-2.1.25-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/1146a1cb-c2b2-4500-917f-5aaccc2e607d/ff8ab9af6eaa1c775bd75f8d545a7140/aspnetcore-runtime-2.1.25-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1378fab5-20e6-4481-a4c9-174d77a5f1df/da00bc27cc5cceac3d845b6e0332ce5a/dotnet-hosting-2.1.25-win.exe

[//]: # ( SDK 2.1.521 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7af2c5b4-ec3c-4bed-9ca3-72328fc93373/fb2cb1aef9d2977964c98f8c19b541f9/dotnet-sdk-2.1.521-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c6bb676-33d8-4454-bc5c-cf9197a021f1/3282bcd8c5c5e672d2a0f2d336cc3b23/dotnet-sdk-2.1.521-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d216e1b6-284b-49d1-80b6-6ef1591aef3d/7053029ec02aed1a7d685e583ff730c7/dotnet-sdk-2.1.521-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c7b11a9-476d-489e-a532-88cae6427e21/b194feee9057f959300681ddcf3785b9/dotnet-sdk-2.1.521-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/b94055bb-450c-4a20-ad7c-2df326311cd1/28c6da582f6bc9f7ce157811703e46fb/dotnet-sdk-2.1.521-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc660166-cbcc-4686-a454-a2f1ed2b1ecb/ac3a4bd5e26f631f61dd3ae044a347a9/dotnet-sdk-2.1.521-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a0e834f4-8122-41d0-9936-0c41573988c9/b8c3a3a1be189f825e7926df557fe7c3/dotnet-sdk-2.1.521-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9617d46d-caeb-4472-9bde-c90a0656082b/c6155e7df4b26a9d84858ff714b43933/dotnet-sdk-2.1.521-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c9f38575-5dd1-4ffd-a89a-c728a7d2c970/c375c525dd53941e92d92c41c1bc459f/dotnet-sdk-2.1.521-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/b1142fbf-64f6-43ed-9500-0f0ec67eb8d5/fe5340c4e3cd3660ec143abe0bac7abb/dotnet-sdk-2.1.521-win-x86.zip
