# .NET Core 2.1.26 Update - March 09, 2021

The .NET 2.1.26 and .NET SDK 2.1.522 releases are available for download. The latest 2.1 release is always listed at [.NET 2.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
2.1.522
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.522](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update won't be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's January servicing release.

This update of .NET Core 2.1 is the last update for .NET Core 2.1.6xx SDK since [Visual Studio 16.0 is out of support](https://learn.microsoft.com/visualstudio/releases/2019/servicing) as of January 2021. We will continue to update versions 2.1.5xx and 2.1.8xx until [.NET Core 2.1 reaches end of life](https://github.com/dotnet/core/blob/main/releases.md).


## Notable Changes

.NET Core 2.1.26 release carries both security and non-security fixes.

# Microsoft Security Advisory CVE-2021-26701 | .NET Core Remote Code Execution Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1, and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A remote code execution vulnerability exists in .NET 5 and .NET Core due to how text encoding is performed.


* [Blog Roundup][dotnet-blog]
* [Known issues](../2.1-known-issues.md)

### Additional fixes in this release

* [Setup](https://github.com/dotnet/core-setup/pulls?q=milestone%3A2.1.26+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6035](https://github.com/dotnet/core/issues/6035) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.26.nupkg
microsoft.aspnetcore.app | 2.1.26.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.26.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.26.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.26.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.26.nupkg
microsoft.netcore.platforms | 2.1.13.nupkg
system.text.encodings.web | 4.5.1.nupkg
microsoft.netcore.app | 2.1.26.nupkg
microsoft.netcore.dotnetapphost | 2.1.26.nupkg
microsoft.netcore.dotnethost | 2.1.26.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.26.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.26.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.26.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.26.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.26.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.26.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.26.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.26.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.26.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.26.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.26.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.26.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.26.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.26.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.26-servicing-29812-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.26-servicing-29812-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.26-servicing-29812-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.26-servicing-29812-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.26-servicing-29812-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.26-servicing-29812-01.nupkg



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.26.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.26-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.26-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-march-2021/


[//]: # ( Runtime 2.1.26)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/52126202-3b11-4c57-abcf-e6785b457d3b/ad4fdb33a45f1609ca648816809cdda4/dotnet-runtime-2.1.26-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2bf29c8c-38ac-49fd-a025-bb98a6026b8a/2aecbd120ed7f3742fb20ef8fb7a5299/dotnet-runtime-2.1.26-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/53121af1-4d0b-4bdb-8437-7e4d05fefec2/ec54855ab05b4d0a7763359accd1a11f/dotnet-runtime-2.1.26-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c00bafe-4ead-4e9a-82b6-884a9727e751/fdb7f6701e556d89b6884037cc9983cb/dotnet-runtime-2.1.26-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3ae95a85-8462-48bf-93b3-36c06503c963/3aa1ec7156426f37f24caac2e1cfd7f7/dotnet-runtime-2.1.26-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d45ab34-41d7-4b03-9c63-c2cac3e34bfa/ade28caed6519aab9b45ec2a230d3655/dotnet-runtime-2.1.26-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/3f75f681-9792-45c5-ae91-49caf1522ba8/bf1665017e2bafdb36269eddc27cd16e/dotnet-runtime-2.1.26-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0a7f035b-4367-49ab-9967-fc71c9b9ca85/c124b47ace07cc8d93713f0fbcedc398/dotnet-runtime-2.1.26-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/d924d020-06cc-4500-b90a-d230056c2ebe/434fc8e5ea999711d025b27cd8733170/dotnet-runtime-2.1.26-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/32d74f73-fcb1-42d8-912f-73e0f8489683/7adb8e13c890d95e82b2b6819c1e1565/dotnet-runtime-2.1.26-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e257e320-c8c4-40ed-8493-cc028c90cb41/597c6f16979f08c81b67e11358a0c7b2/dotnet-runtime-2.1.26-win-x86.zip

[//]: # ( ASP 2.1.26)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d5de5cd-5a86-41fb-ba6d-9672f25ffbe4/cd3ec8bb9f8e600249705d078c46418e/aspnetcore-runtime-2.1.26-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/44261a39-5045-418e-9a34-08a0d53e96e6/ab16ae2a67b1e517c4b3bbf2d076c36b/aspnetcore-runtime-2.1.26-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29ba76e1-db96-4cbb-8964-0a6c859712c4/d6e56c1dacf78b6846464a77dda4115d/aspnetcore-runtime-2.1.26-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/649a6bbc-b0c7-4a57-9683-04e5c806943f/0439b79da4f5a2c113a3102e60b05e20/aspnetcore-runtime-2.1.26-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/50de78a9-36af-4500-a75d-8c3d13b15bb1/3bc0ecee1fd2724f75f041feeda5cb6d/aspnetcore-runtime-2.1.26-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/94869d15-8424-4bf0-9824-7a0ba2162b2f/3ca5871f89c077c608f6374e58a92955/aspnetcore-runtime-2.1.26-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/9f733b99-0cd3-4569-acde-40bcfcd86b70/57a09a183b7338af99181ed79e3025a6/aspnetcore-runtime-2.1.26-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e1953f09-8b30-4a40-b7ac-204149671d6d/2350c0ab769cbaff195c90dd920931bf/aspnetcore-runtime-2.1.26-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/24b6ff4e-0c2c-4955-abdc-b339df494a62/2d2edeafccfde9b8a33ced28cad5b7a7/dotnet-hosting-2.1.26-win.exe


[//]: # ( SDK 2.1.522 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c5df216a-8049-4766-b58f-f152ea37fe0a/c1d9fc6d0c1f5cb6b9e289d5fb1b3aa8/dotnet-sdk-2.1.522-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1599ebfd-8a9f-4939-8597-d040e1c0f278/4c0c3f17e42a3a9a2de0130e45654cc4/dotnet-sdk-2.1.522-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a1c8c424-6d09-4deb-8eda-89d1a536934b/569900f0de06228873c62aca04383e29/dotnet-sdk-2.1.522-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ea7e9a50-a8df-4c62-96fe-0c7edf4d7d81/d616e0c64dad68f58cde43736d299678/dotnet-sdk-2.1.522-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bfaecd11-bc61-4c69-8f73-3aad45a5e377/7d21d24fd4ebc6c3015e5622a1d5ec8d/dotnet-sdk-2.1.522-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82695746-f2c9-46dd-a1ad-c006ce4d5a5f/fae2794dba35300089b1f0de6af539b4/dotnet-sdk-2.1.522-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5be98caf-d5d4-4d30-b8f5-66c1884e675c/68ba4c84aeb489254044ec0e0ad1f852/dotnet-sdk-2.1.522-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c9e64b62-bfdf-441d-b46e-45479d108bcf/77dfd390cc524054edef8639efd5c943/dotnet-sdk-2.1.522-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4dd88832-b055-47ef-bc31-581d0c801e59/589f0bb7d0216ea7ef7e566caa84c7d5/dotnet-sdk-2.1.522-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fcd7ebff-b816-4725-9a00-5bc8c406f23f/6063f32be0b7d295db08f72bcc864639/dotnet-sdk-2.1.522-win-x86.zip
