# .NET Core 2.1.27 Update - April 13, 2021

The .NET 2.1.27 and .NET SDK 2.1.523 releases are available for download. The latest 2.1 release is always listed at [.NET 2.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
2.1.523
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.523](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update won't be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's January servicing release.

This update of .NET Core 2.1 is the last update for .NET Core 2.1.6xx SDK since [Visual Studio 16.0 is out of support](https://learn.microsoft.com/visualstudio/releases/2019/servicing) as of January 2021. We will continue to update versions 2.1.5xx and 2.1.8xx until [.NET Core 2.1 reaches end of life](https://github.com/dotnet/core/blob/main/releases.md).

## Notable Changes

.NET Core 2.1.27 release carries only non-security fixes.

* [Blog Roundup][dotnet-blog]
* [Known issues](../2.1-known-issues.md)

### Additional fixes in this release

* [ASP.NET](https://github.com/dotnet/aspnetcore/issues?q=milestone%3A2.1.27+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6129](https://github.com/dotnet/core/issues/6129) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.27.nupkg
microsoft.aspnetcore.app | 2.1.27.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.27.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.27.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.27.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.27.nupkg
microsoft.netcore.platforms | 2.1.13.nupkg
system.text.encodings.web | 4.5.1.nupkg
microsoft.netcore.app | 2.1.27.nupkg
microsoft.netcore.dotnetapphost | 2.1.27.nupkg
microsoft.netcore.dotnethost | 2.1.27.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.27.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.27.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.27.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.27.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.27.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.27.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.27.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.27.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.27.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.27.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.27.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.27.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.27.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.27.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.27-servicing-29913-01.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.27-servicing-29916-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.27-servicing-29913-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.27-servicing-29916-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.27-servicing-29913-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.27-servicing-29916-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.27-servicing-29913-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.27-servicing-29916-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.27-servicing-29913-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.27-servicing-29916-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.27-servicing-29913-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.27-servicing-29916-01.nupkg

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.27.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.27-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.27-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-april-2021-updates/

[//]: # ( Runtime 2.1.27)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9551a562-4edb-4c50-9c95-17a86f384cd2/ac4903d8b2de052277402f936edd5c97/dotnet-runtime-2.1.27-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/886a04a8-9995-43bc-b6ee-133541836c78/7e1f06c72ffd86731c3b37ae545499ed/dotnet-runtime-2.1.27-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/62a3d54d-826a-4f02-bdb6-bf39e150bdef/dc80fe29313d0f01841283cca5e3fc49/dotnet-runtime-2.1.27-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7eb39c4-484d-4e01-bd41-b4fe6794cd82/ff5c2799f30ea6dd19964c5c90780dba/dotnet-runtime-2.1.27-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e88dabe7-3985-4170-a673-474b72b17027/71d6a02976970b4c3276e7ca5fe2e636/dotnet-runtime-2.1.27-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a599fc53-bc74-4640-b95d-1a041e161f6c/86bbfe6131d2f3b9d1a52c8ccbcd2a47/dotnet-runtime-2.1.27-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/d8f11be6-be68-4997-a604-81f964b14d16/1c83ed7b1197f984a994c56f3ecdea77/dotnet-runtime-2.1.27-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7c60245b-b3f0-4db4-ba42-ed1e78e0d02d/dd7047834f6fd9239fd060b824ca8fdc/dotnet-runtime-2.1.27-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/359b51a0-118d-4f59-866d-0d52a55ee8b9/40c5bd8934bf576e54a3b82b4fbc394a/dotnet-runtime-2.1.27-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2644fd69-fb6b-40c2-96ca-5bd65b62934e/dc5f3662f1f1863e5e9e98819be03be3/dotnet-runtime-2.1.27-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/9f2e3f11-aca9-45af-87e6-584453082cb7/5c3a6ca7c2f274eab48608c545bc47a5/dotnet-runtime-2.1.27-win-x86.zip

[//]: # ( ASP 2.1.27)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/370a2aca-439b-4f0f-831f-3224a9cf4d13/bd3ec147dc91fa66c7464b5c7a8a668b/aspnetcore-runtime-2.1.27-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/006d9e1a-f9c4-4a6f-9e39-8b869322ae4a/6e3ed4443981bc2c75ce89bda340c267/aspnetcore-runtime-2.1.27-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c66dd1cb-a5fc-4427-bef4-d55a1da5a5c7/17f733c7b6afe91ef9c91e9f6e170cad/aspnetcore-runtime-2.1.27-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8067484-5bba-4bf4-97bc-77093e8fcb78/25a2302003e3efee5795bb160c23ca89/aspnetcore-runtime-2.1.27-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/44f46782-9066-4f62-8aae-2657d5a6112a/e9de8e0fdeeb6eb05d77950da50351cc/aspnetcore-runtime-2.1.27-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/291e04db-0aa4-4a52-b733-8afaed634bae/d72e1a99e070354b22e8e2fca1990f13/aspnetcore-runtime-2.1.27-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/978a4289-8043-473d-a0f2-0a44bd1b50d8/2f1a77556585d03fb5f1f2ab52d57cc0/aspnetcore-runtime-2.1.27-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c446dcfe-e41b-400d-ae48-ba28b49539a4/c250b3fcbc7e3db17d48692ea15644a6/aspnetcore-runtime-2.1.27-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/4155e077-4635-4a74-8c96-3feb3f341073/771eb3d31794d7fd6030d367e0236ec8/dotnet-hosting-2.1.27-win.exe

[//]: # ( SDK 2.1.523 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ff58389-afd6-44b6-be22-f381bb688500/2cb8d54ba5207beb8de093193c410d06/dotnet-sdk-2.1.523-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8db0700a-607f-4068-baad-ae484f5623d0/f6e23e2bb9774fab858c58ddf4e4c427/dotnet-sdk-2.1.523-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a7cf90e2-fdb1-4546-978a-45b83c7fce56/f80983803f3ade6f9c14705313add981/dotnet-sdk-2.1.523-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da36cbfe-dbf0-4e2b-899d-69e4cf59266a/bcbb09869964a6ff33ce18cb0e1cafe8/dotnet-sdk-2.1.523-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/86a6d223-85fb-4d80-98bb-e45cab9926db/66bbeeb674f783e70b2b5b672d2a4972/dotnet-sdk-2.1.523-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fd676a92-b47c-4f68-90f3-1e1da1030b9b/093d92ba8d56195cd674182f8c0fac9a/dotnet-sdk-2.1.523-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/59ca29e1-a1e9-4074-8c1d-60d8df831051/aa178a7db1198e274e40b4d449b01089/dotnet-sdk-2.1.523-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/107d1215-b3a0-4b59-b595-88f39cdca9ec/8b7ed70b3bc6aae2f6da91af7a6f0f6b/dotnet-sdk-2.1.523-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/c0c4fd8f-e924-4f59-a16b-04ec350481c5/df5b73d5a951af6f473ee6ce9787ad80/dotnet-sdk-2.1.523-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c5429f4c-de7f-4ac2-9a75-9ff44d636e49/d5a7b78887f1977721c6d3c46cf8c99d/dotnet-sdk-2.1.523-win-x86.zip
