# .NET Core 2.1.28 Update - May 11, 2021

The .NET 2.1.28 and .NET SDK 2.1.524 releases are available for download. The latest 2.1 release is always listed at [.NET 2.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
2.1.524
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.524](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

Note: This is not a security release hence this update won't be immediately available through Visual Studio. However, this is expected to show up in Visual Studio's January servicing release.


## Notable Changes

.NET Core 2.1.28 release carries only non-security fixes.


* [Blog Roundup][dotnet-blog]
* [Known issues](../2.1-known-issues.md)

# Behavioral change in Asp.Net 2.1 Installers

## Summary

Asp.Net 2.1.28 will now install side-by-side with Asp.Net 2.1.6 or earlier. It will still remove previously installed versions of Asp.Net that are 2.1.7 or newer. Users runnning the 2.1.28 Asp.Net Installer or 2.1.28 Hosting Bundle should manually uninstall any local versions of the Asp.Net runtime that are 2.1.6 or earlier.

### Additional fixes in this release

* [CoreFx](https://github.com/dotnet/corefx/issues?q=milestone%3A2.1.28+is%3Aclosed+label%3Aservicing-approved)

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6247](https://github.com/dotnet/core/issues/6247) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all | 2.1.28.nupkg
microsoft.aspnetcore.app | 2.1.28.nupkg
microsoft.dotnet.web.client.itemtemplates | 2.1.28.nupkg
microsoft.dotnet.web.itemtemplates | 2.1.28.nupkg
microsoft.dotnet.web.projecttemplates.2.1 | 2.1.28.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 | 2.1.28.nupkg
microsoft.netcore.platforms | 2.1.14.nupkg
microsoft.netcore.app | 2.1.28.nupkg
microsoft.netcore.dotnetapphost | 2.1.28.nupkg
microsoft.netcore.dotnethost | 2.1.28.nupkg
microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.linux-arm.microsoft.netcore.app | 2.1.28.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.linux-arm64.microsoft.netcore.app | 2.1.28.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.linux-musl-x64.microsoft.netcore.app | 2.1.28.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.linux-x64.microsoft.netcore.app | 2.1.28.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.osx-x64.microsoft.netcore.app | 2.1.28.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.rhel.6-x64.microsoft.netcore.app | 2.1.28.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.win-arm.microsoft.netcore.app | 2.1.28.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.win-arm.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.win-arm64.microsoft.netcore.app | 2.1.28.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.win-x64.microsoft.netcore.app | 2.1.28.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.win-x64.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
runtime.win-x86.microsoft.netcore.app | 2.1.28.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost | 2.1.28.nupkg
runtime.win-x86.microsoft.netcore.dotnethost | 2.1.28.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy | 2.1.28.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver | 2.1.28.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.28-servicing-30015-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.28-servicing-30015-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.28-servicing-30015-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.28-servicing-30015-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.28-servicing-30015-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.28-servicing-30015-01.nupkg


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.28.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.28-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.28-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-may-2021/


[//]: # ( Runtime 2.1.28)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cae3152-429c-4992-b2f1-83b07f925421/89d02520b0f2ef641b436c45909e689b/dotnet-runtime-2.1.28-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4af029ad-99e6-40a4-b927-a4cd79f47f7c/3ec70f13b0cb0323df22cd7b59ffb980/dotnet-runtime-2.1.28-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f38cb438-29cf-4a1e-b6c8-d2dd32246738/554d91dec92633a5dcf8523031de8ea9/dotnet-runtime-2.1.28-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95e68908-4a59-4adb-a44f-116914572423/7f8ee037851be82c8a583f47ee2969a7/dotnet-runtime-2.1.28-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/8a8f778c-ea65-410c-af5a-92157867242c/eb2bdb045e80feb1abee7379d564014a/dotnet-runtime-2.1.28-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4dea9288-0fc5-4a34-9b34-67a75fdb3c5a/7cd3fea18a3497b6b4036cd1870fc0e7/dotnet-runtime-2.1.28-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ba7836b6-bee6-476e-9a79-8c7de81859b5/1f9afd284d8e74f3cbd681ad1e918b47/dotnet-runtime-2.1.28-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5e61b270-52e5-45f7-90a9-b19c41311cb9/5bdc26bef54286b1724dd72c65bd3777/dotnet-runtime-2.1.28-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/331d855f-6ee0-4670-8747-1073ab8eaaf5/8147b578e658cf3417f39bafffee029f/dotnet-runtime-2.1.28-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/51f11589-d908-40ef-80b1-f765c0145ee4/710f52b2fa2f06da78ea52c1eb8141d3/dotnet-runtime-2.1.28-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dcaf05c7-0d60-4ce3-a156-4e3e506c5be2/059659be59dc450ef34008c9f1f973fe/dotnet-runtime-2.1.28-win-x86.zip

[//]: # ( ASP 2.1.28)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fbdb615e-48c3-4646-9b90-76a5a15b4562/cc878beda4838f0cf7155c12036cc511/aspnetcore-runtime-2.1.28-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a917a51-3aa7-41d5-bb6b-de9221d7b28f/4ccd9b1315e571d921469c3c7f18cd14/aspnetcore-runtime-2.1.28-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/66483281-5453-4504-9686-f72d1fd357f7/0de98386ca1709bde2b5f2f7df4c80da/aspnetcore-runtime-2.1.28-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4bcf8163-d9b5-410c-90e8-89315640794f/9a891b6d67e6d9f421aba1defed2e927/aspnetcore-runtime-2.1.28-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/bd462316-665c-48a0-bba3-7b6d8675fda7/8b1d772d8abf1c83ea01a2dbd144ba80/aspnetcore-runtime-2.1.28-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/ac76841e-9b96-4a0b-ba26-2fe37bd8df64/304db7abae0fcb1801c8f26be86ad62a/aspnetcore-runtime-2.1.28-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8d8691f6-8cae-4ce5-b56f-398a2bc062a0/b364e46ea00c13bdb30d518d4d2765d2/aspnetcore-runtime-2.1.28-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/137e0c77-b999-4f22-be7e-5bac7898237f/6d731bdc005d43d5849f07cccd56404f/aspnetcore-runtime-2.1.28-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/50a47fa0-aff0-44d2-a4ef-0d7c608101e6/3bdef1208816793d6775b6d1912ab81f/dotnet-hosting-2.1.28-win.exe

[//]: # ( SDK 2.1.524 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42c3a23e-0690-4bfb-accd-ab21ed375d5c/9e1670f11df1f1488e9b13da4881e24e/dotnet-sdk-2.1.524-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0b6c230e-8d45-460c-877b-1f76d02b1e3f/ec76d0ed01b00a3807d961a96fb41000/dotnet-sdk-2.1.524-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6656a1bf-6796-4135-b43f-3b34045df0d1/382d4f1cb69275e637ad66d95d5f18f0/dotnet-sdk-2.1.524-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/82988c70-b98b-4728-9f34-e104fa65c020/44c5cc9dd03045f18107887dc0531678/dotnet-sdk-2.1.524-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/d89dda95-e748-42be-a1e6-760dac770858/8c118d15aa513d1609ea353f9cc7c153/dotnet-sdk-2.1.524-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f4cf79a1-cb41-4ada-b629-42d77360a994/043990f7be23a7f78557a10a7bfbc2ba/dotnet-sdk-2.1.524-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c72a8b51-d3ef-4900-b950-55c9707c63d3/76948b5f23d012affb30f2cc24d3131e/dotnet-sdk-2.1.524-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/41f3741f-d87a-483d-8b06-a8b07dafa92c/cf9fdd51b74bcdefe55f9ab4ab4edec2/dotnet-sdk-2.1.524-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/6f97e01f-dfc9-4194-9bf9-181db3a9ec99/dda3683594ace8c1ae9c3d6fd284494f/dotnet-sdk-2.1.524-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0101cea2-ce78-4af3-85cc-8fc835b35df7/83261ddcafc0563c736d2199b84d61cd/dotnet-sdk-2.1.524-win-x86.zip
