# .NET Core 2.1.30 Update - August 19, 2021

The .NET 2.1.30, .NET SDK 2.1.818 and [.NET SDK 2.1.526](2.1.526.md) releases are available for download. The latest 2.1 release is always listed at [.NET 2.1 Releases](../README.md).

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes.
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


The .NET SDK includes a matching updated .NET Runtime. Downloading the Runtime or ASP.NET Core packages is not needed when installing the SDK.

You can check your .NET SDK version by running the following command. The example version shown is for this release.

```console
$ dotnet --version
2.1.818
```

Visit [.NET Documentation](https://learn.microsoft.com/dotnet/core/) to learn about .NET, for building many different types of applications.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

The following repos have been updated:

* [dotnet/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md): .NET Core SDK
* [dotnet/aspnet](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md): ASP.NET Core Runtime
* [dotnet/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime
* [dotnet/runtime-deps](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md): .NET Core Runtime Dependencies


## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the following table to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.818](#downloads) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

[.NET Core 2.1 will reach end of support on August 21, 2021](https://devblogs.microsoft.com/dotnet/net-core-2-1-will-reach-end-of-support-on-august-21-2021/). After this date, Microsoft will no longer provide technical support and updates (which includes security fixes) for this version. You'll need to update the version of .NET Core you're using to supported version (.NET Core 3.1 or .NET 5.0) before this date in order to continue to recieve updates.

## Notable Changes

.NET Core 2.1.30 release carries both security and non-security fixes.

# Microsoft Security Advisory CVE-2021-34485 | .NET Core Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 when dumps created by the tool to collect crash dumps and dumps on demand are created with global read permissions on Linux and macOS.

# Microsoft Security Advisory CVE-2021-26423 | .NET Core Denial of Service Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

A denial of service vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 where .NET (Core) server applications providing WebSocket endpoints could be tricked into endlessly looping while trying to read a single WebSocket frame.

# Microsoft Security Advisory CVE-2021-34532 | ASP.NET Core Information Disclosure Vulnerability

## <a name="executive-summary"></a>Executive summary

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET 5.0, .NET Core 3.1 and .NET Core 2.1. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

An information disclosure vulnerability exists in .NET 5.0, .NET Core 3.1 and .NET Core 2.1 where an JWT token is logged if it cannot be parsed.

* [Blog Roundup][dotnet-blog]
* [Known issues](../2.1-known-issues.md)

# Behavioral change in Asp.Net 2.1 Installers

## Summary

Asp.Net Core 2.1.30 will now install side-by-side with Asp.Net 2.1.6 or earlier. It will still remove previously installed versions of Asp.Net that are 2.1.7 or newer. Users runnning the 2.1.30 Asp.Net Installer or 2.1.30 Hosting Bundle should manually uninstall any local versions of the Asp.Net runtime that are 2.1.6 or earlier.

## Feedback

Your feedback is important and appreciated. We've created an issue at [dotnet/core #6553](https://github.com/dotnet/core/issues/6553) for your questions and comments.

## Packages updated in this release:

Package name | Version
:----------- | :------------------
microsoft.aspnetcore.all |  2.1.30.nupkg
microsoft.aspnetcore.app |  2.1.30.nupkg
microsoft.aspnetcore.authentication.jwtbearer |  2.1.30.nupkg
microsoft.dotnet.web.client.itemtemplates |  2.1.30.nupkg
microsoft.dotnet.web.itemtemplates |  2.1.30.nupkg
microsoft.dotnet.web.projecttemplates.2.1 |  2.1.30.nupkg
microsoft.dotnet.web.spa.projecttemplates.2.1 |  2.1.30.nupkg
microsoft.netcore.app |  2.1.30.nupkg
microsoft.netcore.dotnetapphost |  2.1.30.nupkg
microsoft.netcore.dotnethost |  2.1.30.nupkg
microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.linux-arm.microsoft.netcore.app |  2.1.30.nupkg
runtime.linux-arm.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.linux-arm.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.linux-arm.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.linux-arm64.microsoft.netcore.app |  2.1.30.nupkg
runtime.linux-arm64.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.linux-arm64.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.linux-musl-x64.microsoft.netcore.app |  2.1.30.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.linux-musl-x64.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.linux-x64.microsoft.netcore.app |  2.1.30.nupkg
runtime.linux-x64.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.linux-x64.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.linux-x64.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.osx-x64.microsoft.netcore.app |  2.1.30.nupkg
runtime.osx-x64.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.osx-x64.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.osx-x64.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.rhel.6-x64.microsoft.netcore.app |  2.1.30.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.rhel.6-x64.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.win-arm.microsoft.netcore.app |  2.1.30.nupkg
runtime.win-arm.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.win-arm.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.win-arm.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.win-arm.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.win-arm64.microsoft.netcore.app |  2.1.30.nupkg
runtime.win-arm64.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.win-arm64.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.win-arm64.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.win-x64.microsoft.netcore.app |  2.1.30.nupkg
runtime.win-x64.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.win-x64.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.win-x64.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.win-x64.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
runtime.win-x86.microsoft.netcore.app |  2.1.30.nupkg
runtime.win-x86.microsoft.netcore.dotnetapphost |  2.1.30.nupkg
runtime.win-x86.microsoft.netcore.dotnethost |  2.1.30.nupkg
runtime.win-x86.microsoft.netcore.dotnethostpolicy |  2.1.30.nupkg
runtime.win-x86.microsoft.netcore.dotnethostresolver |  2.1.30.nupkg
vs.redist.common.netcore.hostfxr.x64.2.1 | 2.1.30-servicing-30411-01.nupkg
vs.redist.common.netcore.hostfxr.x86.2.1 | 2.1.30-servicing-30411-01.nupkg
vs.redist.common.netcore.sharedframework.x64.2.1 | 2.1.30-servicing-30411-01.nupkg
vs.redist.common.netcore.sharedframework.x86.2.1 | 2.1.30-servicing-30411-01.nupkg
vs.redist.common.netcore.sharedhost.x64.2.1 | 2.1.30-servicing-30411-01.nupkg
vs.redist.common.netcore.sharedhost.x86.2.1 | 2.1.30-servicing-30411-01.nupkg



[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.30.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.30-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.30-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/
[dotnet-blog]:  https://devblogs.microsoft.com/dotnet/net-august-2021/

[//]: # ( Runtime 2.1.30)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc181049-61ec-4873-afb3-12d963f26178/e56e940b257708e28fc2365b293a3fcb/dotnet-runtime-2.1.30-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b63625d-531e-44f0-9daf-4a14d0e286d4/99d79b3c2365c7b9cea2199e38b54790/dotnet-runtime-2.1.30-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89b06bc9-b42d-4bc4-9685-6402e4d05081/77915213f48da1b4ecfd8b94c6f30a95/dotnet-runtime-2.1.30-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/84904da8-51ea-4ff2-b816-a2a16442eb7c/ebc16d3a87af8002cd2b2ea63a351db1/dotnet-runtime-2.1.30-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bed6849f-2951-4e31-bbd2-dde871cee29c/e5833a9f5c3e914592d181420532b257/dotnet-runtime-2.1.30-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b5b8df3-10f3-4319-9e47-b9b8983121ce/1c49701b761db6534d68f0bf75748d29/dotnet-runtime-2.1.30-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ed918832-3f7d-4f3e-a235-670d9447a5d6/85e411f847174bee21cfd72138154615/dotnet-runtime-2.1.30-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b009808d-e1cc-4d88-b48d-7f465c361d22/8546c452b57896f6ebbdfac1d047f8b6/dotnet-runtime-2.1.30-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/62fba88c-fa15-4659-9d8c-98323547ec80/c83172d7e2fc720280dd5d312c6cbae2/dotnet-runtime-2.1.30-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ba5cdf69-8d9b-4fd7-940a-dc1168bd9ac9/ffdcdfc6f0aea73dedaf0ccf28fc95f6/dotnet-runtime-2.1.30-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/105c54df-3cef-4bce-b878-6324c3130b7e/575d8048bfe04c2e043b48365db17098/dotnet-runtime-2.1.30-win-x86.zip

[//]: # ( ASP 2.1.30)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45d40fc8-6d2d-45bf-95f5-85b04dddb2f9/15684494c511eb7d807cca09009c775f/aspnetcore-runtime-2.1.30-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12ab23c7-2178-44d6-95e8-edf01092591f/e0f3b4e0ab258cf8e10f425200422247/aspnetcore-runtime-2.1.30-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6040f80-8343-4771-9c02-dbc9a35ac88a/68e74e6e46cf36fa1a50f68af6831d6d/aspnetcore-runtime-2.1.30-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a22ee713-db35-4232-a968-56a9da281ad0/d793935b7c0d1543bc1beb2931da4449/aspnetcore-runtime-2.1.30-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b7d1c13d-1a1f-4eb4-a846-cbe85226b955/e60f930b6c79bd230bc771303edd6915/aspnetcore-runtime-2.1.30-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b54708aa-2c23-4d09-80e4-de00b0371b51/f20e1f1bbd5c3ed981405b34138ef105/aspnetcore-runtime-2.1.30-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ba6ce3ac-1ae3-40b4-8d7c-722870411df6/2f2316ffd11685a9f24a314ed53b7b51/aspnetcore-runtime-2.1.30-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/07ea2c09-36a3-4c39-b842-fe14d4c52f8f/574f9d1d4456fbeae223c1be2cafcac2/aspnetcore-runtime-2.1.30-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/cf7b17e3-ed6d-4ded-8ae6-9f83ffaaca98/9d2ca844baa4a4a9ed83861ffc8e293e/dotnet-hosting-2.1.30-win.exe

[//]: # ( SDK 2.1.818)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ba99642d-36fc-4654-95c3-112711ca6e41/7ef9d5f0a6d9b432069b68b46d81867c/dotnet-sdk-2.1.818-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/04bec57b-d2a9-46b0-8c97-848558818000/1e67e2407b0518c9d2a692ba1fc99b22/dotnet-sdk-2.1.818-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f1c2c969-8be9-458b-b34f-21df996f6114/a08a398cb7a9a42d23de2eeaef72e5e3/dotnet-sdk-2.1.818-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5797d98a-8faf-472d-925c-931ac542d3c8/e48942da88f4d9d653a7b5c0790e7724/dotnet-sdk-2.1.818-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/9f2c289a-f8f1-42cc-b319-091cf0394094/e08707b0494afb833f3cad1a2301aaff/dotnet-sdk-2.1.818-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fc42fd66-af16-4164-8bea-b050f279172d/aac481e88a7cb695ee3d0333fd96bb99/dotnet-sdk-2.1.818-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fdc2c572-1f7f-4d46-b767-dd0951d10865/ad32c09fbef96146ec6b763d0192fba7/dotnet-sdk-2.1.818-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/e6d7875b-f9e7-4ef8-aefc-166c1b6d2936/a1fdcb15c89776c53cf90f396c5f57e7/dotnet-sdk-2.1.818-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/34eb90cf-8de6-4301-9e61-5462b30edf4f/a493989fc106a5a851447ba6b7289ad6/dotnet-sdk-2.1.818-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/68185c0b-8622-4b44-a9a0-2a78041ae5e0/000a9209e995c82f53244a4dc7300d64/dotnet-sdk-2.1.818-win-x86.zip

