# .NET Core 2.1.526

This .NET Core SDK release includes the following released .NET Core and ASP.NET Core Runtimes.

* .NET Core SDK 2.1.526
* .NET Core Runtime 2.1.30
* ASP.NET Core 2.1.30

See the [Release Notes](2.1.30.md) for details about what is included in this update.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installation steps][linux-setup]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup>
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |


1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Visual Studio Compatibility

This update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2017 | [2.1.526](2.1.30.md) |
| macOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |


## Docker

The [.NET Core Docker images](https://hub.docker.com/_/microsoft-dotnet) have been updated for this release. The [.NET Docker samples](https://github.com/dotnet/dotnet-docker/blob/main/samples/README.md) show various ways to use .NET and Docker together.

## Installing .NET Core on Linux

### Install using Snap

Snap is a system which installs applications in an isolated environment and provides for automatic updates. Many distributions which are not directly supported by .NET Core can use Snaps to install. See the [list of distributions supported Snap](https://docs.snapcraft.io/installing-snapd/6735) for details.

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --channel 2.1/stable –-classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it won't conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [.NET for Linux Distributions](../../../linux.md) for a possible resolution.

### Install using a Package Manager

Before installing .NET, you need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The following commands don't specifically include package managers to help with readability. Here are the package managers typically used by the distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

## Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

## Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP.NET Core Runtime and .NET Core Runtime.

## Windows Server Hosting

If you're looking to host standalone apps on servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.30-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.30.md

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.30-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.30-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[linux-setup]: https://learn.microsoft.com/dotnet/core/install/linux



[//]: # ( Runtime 2.1.30)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bc181049-61ec-4873-afb3-12d963f26178/e56e940b257708e28fc2365b293a3fcb/dotnet-runtime-2.1.30-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1b63625d-531e-44f0-9daf-4a14d0e286d4/99d79b3c2365c7b9cea2199e38b54790/dotnet-runtime-2.1.30-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89b06bc9-b42d-4bc4-9685-6402e4d05081/77915213f48da1b4ecfd8b94c6f30a95/dotnet-runtime-2.1.30-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/84904da8-51ea-4ff2-b816-a2a16442eb7c/ebc16d3a87af8002cd2b2ea63a351db1/dotnet-runtime-2.1.30-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/bed6849f-2951-4e31-bbd2-dde871cee29c/e5833a9f5c3e914592d181420532b257/dotnet-runtime-2.1.30-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4b5b8df3-10f3-4319-9e47-b9b8983121ce/1c49701b761db6534d68f0bf75748d29/dotnet-runtime-2.1.30-osx-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ed918832-3f7d-4f3e-a235-670d9447a5d6/85e411f847174bee21cfd72138154615/dotnet-runtime-2.1.30-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b009808d-e1cc-4d88-b48d-7f465c361d22/8546c452b57896f6ebbdfac1d047f8b6/dotnet-runtime-2.1.30-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/62fba88c-fa15-4659-9d8c-98323547ec80/c83172d7e2fc720280dd5d312c6cbae2/dotnet-runtime-2.1.30-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ba5cdf69-8d9b-4fd7-940a-dc1168bd9ac9/ffdcdfc6f0aea73dedaf0ccf28fc95f6/dotnet-runtime-2.1.30-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/105c54df-3cef-4bce-b878-6324c3130b7e/575d8048bfe04c2e043b48365db17098/dotnet-runtime-2.1.30-win-x86.zip

[//]: # ( ASP 2.1.30)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/45d40fc8-6d2d-45bf-95f5-85b04dddb2f9/15684494c511eb7d807cca09009c775f/aspnetcore-runtime-2.1.30-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/12ab23c7-2178-44d6-95e8-edf01092591f/e0f3b4e0ab258cf8e10f425200422247/aspnetcore-runtime-2.1.30-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6040f80-8343-4771-9c02-dbc9a35ac88a/68e74e6e46cf36fa1a50f68af6831d6d/aspnetcore-runtime-2.1.30-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a22ee713-db35-4232-a968-56a9da281ad0/d793935b7c0d1543bc1beb2931da4449/aspnetcore-runtime-2.1.30-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b7d1c13d-1a1f-4eb4-a846-cbe85226b955/e60f930b6c79bd230bc771303edd6915/aspnetcore-runtime-2.1.30-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/b54708aa-2c23-4d09-80e4-de00b0371b51/f20e1f1bbd5c3ed981405b34138ef105/aspnetcore-runtime-2.1.30-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ba6ce3ac-1ae3-40b4-8d7c-722870411df6/2f2316ffd11685a9f24a314ed53b7b51/aspnetcore-runtime-2.1.30-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/07ea2c09-36a3-4c39-b842-fe14d4c52f8f/574f9d1d4456fbeae223c1be2cafcac2/aspnetcore-runtime-2.1.30-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/cf7b17e3-ed6d-4ded-8ae6-9f83ffaaca98/9d2ca844baa4a4a9ed83861ffc8e293e/dotnet-hosting-2.1.30-win.exe


[//]: # ( SDK 2.1.526)
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/143fbece-a815-4707-a816-79afcc0733df/fda066c4a00547f0e0c2f5857a5d3a96/dotnet-sdk-2.1.526-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b088a7db-2c89-4735-8d8d-ba5f1f791752/9e002bf4a556c3dcc04e731f1ea58a88/dotnet-sdk-2.1.526-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/014fdc04-f859-4db6-a40c-d250819214a1/0ae7010bbd8936e9f6c52a8c6347ed48/dotnet-sdk-2.1.526-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c320cf5a-8788-4409-85e0-695087e9173c/12c5b231c146a487a42de46bc55adb08/dotnet-sdk-2.1.526-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/97913c52-a78c-4c93-abe4-a2cdf3c933ee/dc2262512c0ac6bd80070b39e28594e6/dotnet-sdk-2.1.526-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/513bf6de-9faf-4e99-94c8-1a94ca30be49/875393a37a16d596d0021547f011c2d2/dotnet-sdk-2.1.526-osx-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/db84bdd7-9889-4406-b1e0-2f8e022c19c8/31e646ad236f518e7b3ddbd61d244b44/dotnet-sdk-2.1.526-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/0dea242d-50cc-4541-8a4e-a53c82d4c5c8/14ed5a7073fb7ae148710159d30f7914/dotnet-sdk-2.1.526-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fccc13ee-151b-4395-9961-3bd3a7eda15c/756dfde0bcb2e82fb26870ac4a60e625/dotnet-sdk-2.1.526-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/fc37844c-69d3-49c6-b5d2-44545722099d/6c26a3ca25164035e3fecf41d6b86831/dotnet-sdk-2.1.526-win-x86.zip
