# .NET Core 2.1.400 SDK Update - August 14, 2018

.NET Core SDK 2.1.400 is available for download and usage in your environment.  This includes the [2.1.2 Runtime](https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.2.md) that shipped in July 2018. This release also  ships with [Visual Studio 15.8](https://learn.microsoft.com/visualstudio/releasenotes/vs2017-relnotes#NETCoreSDK2.1.400).

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-sdk-21400)
* [Lifecycle](#net-core-lifecycle-news)

## Downloads

|           | SDK Installer*                                   | SDK Binaries*                            | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][sdk-win-x86.exe] \| [x64][sdk-win-x64.exe] | [x86][sdk-win-x86] \| [x64][sdk-win-x64] | [x86][runtime-win-x86.exe] \| [x64][runtime-win-x64.exe] | [x86][runtime-win-x86] \| [x64][runtime-win-x64] | [x86][asp-runtime-win-x86.exe] \| [x64][asp-runtime-win-x64.exe] <br/> [Hosting Bundle][hosting-win-x64.exe] |
| macOS     | [x64][sdk-mac-x64.pkg]  | [x64][sdk-mac-x64]     | [x64][runtime-mac-x64.pkg] | [x64][runtime-mac-x64] | [x64][asp-runtime-mac-x64]
| Linux     | [See installations steps below][linux-install]   | [x64][sdk-linux-x64] \| [ARM][sdk-linux-arm-x32] \| [ARM64][sdk-linux-arm-x64] \| [x64 Alpine][sdk-linux-musl-x64] | - | [x64][runtime-linux-x64] \| [ARM][runtime-linux-arm-x32] \| [ARM64][runtime-linux-arm-x64] \| [x64 Alpine][runtime-linux-musl-x64] | [x64][asp-runtime-linux-x64]  \| [ARM32][asp-runtime-linux-arm-x86] \| [x64 Alpine][asp-runtime-linux-musl-x64] |
| RHEL6     | -                                                | [x64][sdk-rhel.6-x64]                    | -                                                        | [x64][runtime-rhel.6-x64] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | -                                                | -                                        | [Runtime][symbols-coreclr] \| [Shared Framework][symbols-corefx] \| [Setup][symbols-core-setup] | - | [ASP.NET Core][symbols-aspnetcore] |

\* Includes the .NET Core and ASP.NET Core runtimes

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://github.com/dotnet/dotnet-docker/blob/main/README.md)
* [microsoft/dotnet-samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](../../../os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Notable Changes in SDK 2.1.400
  * Added nunit templates.
  * Added support for signed global tools. [dotnet/cli#9224](https://github.com/dotnet/cli/issues/9224)
  * Improved help text. [dotnet/cli#7431](https://github.com/dotnet/cli/issues/7431), [dotnet/cli#9230](https://github.com/dotnet/cli/issues/9230), [dotnet/cli#9165](https://github.com/dotnet/cli/issues/9165)
  * Added support for interactive restore/add package to support NuGet and VSTS.  authenticated feeds. [NuGet/Home#7017](https://github.com/NuGet/Home/issues/7017), [NuGet/Home#6642](https://github.com/NuGet/Home/issues/6642)
  * Added error codes to all SDK error messages. [dotnet/cli#2269](https://github.com/dotnet/sdk/pull/2269)
  * Highlights of included tools:
  * Updates to Visual Basic and F# 4.5 as described in the [Visual Studio Release Notes](https://learn.microsoft.com/visualstudio/releasenotes/vs2017-relnotes)

[dlc-runtime]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89
[dlc-sdk]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE
[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.2.md

[runtime-linux-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-x64.tar.gz
[runtime-linux-arm-x32]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-arm.tar.gz
[runtime-linux-musl-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-musl-x64.tar.gz
[runtime-linux-arm-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-linux-arm64.tar.gz
[runtime-rhel.6-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-rhel.6-x64.tar.gz
[runtime-mac-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-osx-x64.tar.gz
[runtime-mac-x64.pkg]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-osx-x64.pkg
[runtime-win-x86]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x86.zip
[runtime-win-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x64.zip
[runtime-win-x86.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x86.exe
[runtime-win-x64.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-runtime-2.1.2-win-x64.exe

[sdk-linux-x64]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-linux-x64.tar.gz
[sdk-linux-arm-x32]:  https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-linux-arm.tar.gz
[sdk-linux-arm-x64]:  https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-linux-arm64.tar.gz
[sdk-linux-musl-x64]:  https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-linux-musl-x64.tar.gz
[sdk-mac-x64]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-osx-x64.tar.gz
[sdk-mac-x64.pkg]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-osx-x64.pkg
[sdk-mac-x64.pkg-gs]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-osx-gs-x64.pkg
[sdk-win-x86]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-win-x86.zip
[sdk-win-x64]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-win-x64.zip
[sdk-win-x86.exe]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-win-x86.exe
[sdk-win-x86.exe-gs]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-win-gs-x86.exe
[sdk-win-x64.exe]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-win-x64.exe
[sdk-win-x64.exe-gs]: https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-win-gs-x64.exe
[sdk-rhel.6-x64]:  https://download.microsoft.com/download/9/D/2/9D2354BE-778B-42D6-BA4F-3CEF489A4FDE/dotnet-sdk-2.1.400-rhel.6-x64.tar.gz

[hosting-win-x64.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/dotnet-hosting-2.1.2-win.exe
[asp-runtime-linux-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-x64.tar.gz
[asp-runtime-linux-arm-x86]:  https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-arm.tar.gz
[asp-runtime-linux-musl-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-linux-musl-x64.tar.gz
[asp-runtime-mac-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-osx-x64.tar.gz
[asp-runtime-win-x64.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x64.exe
[asp-runtime-win-x86.exe]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x86.exe
[asp-runtime-win-x86]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x86.zip
[asp-runtime-win-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-runtime-2.1.2-win-x64.zip
[asp-store-linux-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-store-2.1.2-linux-x64.tar.gz
[asp-store-mac-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnetcore-store-2.1.2-osx-x64.tar.gz
[asp-store-win-x64]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/AspNetCore.2.1.2.RuntimePackageStore_x64.exe
[asp-store-win-x86]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/AspNetCore.2.1.2.RuntimePackageStore_x86.exe

[symbols-aspnetcore]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/aspnet-2.1.2-symbols.zip
[symbols-coreclr]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/coreclr-2.1.2-symbols.zip
[symbols-corefx]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/corefx-2.1.2-symbols.zip
[symbols-core-setup]: https://download.microsoft.com/download/1/f/7/1f7755c5-934d-4638-b89f-1f4ffa5afe89/core-setup-2.1.2-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.2-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.400-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/2018/07/10/net-core-july-2018-update/
