# .NET Core SDK 2.1.502

.NET Core 2.1.502 comprises:

* .NET Core Runtime 2.1.6
* ASP.NET Core 2.1.6
* .NET Core SDK 2.1.502

See the [Release Notes][release-notes] for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

## Installing .NET Core on Linux

Before installing .NET, you will need to register the Microsoft key, register the product repository, and install required dependencies. This only needs to be done once per machine. Refer to [Setting up Linux for .NET Core][linux-setup] for the requirements.

The commands listed below do not specifically include package managers to help with readability. Here are the package managers typically used by the Distros on which .NET Core is supported.

| Distro | Package Manager  |
| ---             | :----:  |
| CentOS, Oracle  | yum     |
| Debian, Ubuntu  | apt-get |
| Fedora          | dnf     |
| OpenSUSE, SLES  | zypper  |

### Develop applications

To develop applications using the .NET Core SDK, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install dotnet-sdk-2.1
```

### Run applications

If you only need to run existing applications, run the following command. The .NET Core runtime and ASP.NET Core runtime are included.

```bash
sudo [package manager] update or refresh
sudo [package manager] install aspnetcore-runtime-2.1
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-2.1` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-2.1` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-2.1.6-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.502.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d461733-a0cd-48ee-9963-791337dcaafa/3b75ee4c7fb9d6bc7d0ddd9761676096/dotnet-runtime-2.1.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9cb31ef2-d5ec-490d-8a3f-f45f52d28fec/4c906b6132f2c0fe55e9e0209f08b352/dotnet-runtime-2.1.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b934284c-96e3-49ab-9c86-6332092bafa7/480c4ba3ddd68c4a303c8de3616ac4ee/dotnet-runtime-2.1.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c1334bc-bd26-4232-a745-2728b36a2628/8e163216cdcec15332ebf2e5575962de/dotnet-runtime-2.1.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/26452190-8866-4e1c-8bd2-e4699d775555/befaa5544a34e875621b239281d662a5/dotnet-runtime-2.1.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f36c0b9-397b-4303-9a83-2f09e08affb0/dc43655b905e0c3d5d5fd89cafc1fb81/dotnet-runtime-2.1.6-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95777fc5-eb49-4fe3-b136-db2c1e8c4cab/17cafbf4d0d6e234e4ea6cc143739e1d/dotnet-runtime-2.1.6-rhel.6-x64.tar.gz
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8dcd5adb-21a8-43db-ab6a-d6c8e37b20fe/d52d48805fc35dbfa7ce411fbf5fda59/dotnet-runtime-2.1.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3f6b6def-4e9a-4405-b21f-89f77d1605c4/52be50baa0e9bfa118fe6de80be89ab6/dotnet-runtime-2.1.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/af783fb4-da01-44f9-a8b8-9e52dda7970e/3d9920fc37175a41140f9c8af542a42c/dotnet-runtime-2.1.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3ef3e42c-281d-43e2-969b-3f6aafef56f1/a13f4c966b0f499b8883f6e6f8b1765c/dotnet-runtime-2.1.6-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c5d6af2-868c-4021-8b25-4913daca41c3/46cfc8ddb9b8f10ebd56de1b1a534e32/aspnetcore-runtime-2.1.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4770dec-8d9d-4591-ba45-a8ad1d71841e/fa87d518261a484787824fc0e1d9365f/aspnetcore-runtime-2.1.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ecfed21-c776-4924-b734-126400fd324a/4e1bfb9c870ffcf99b1bf953b91ef072/aspnetcore-runtime-2.1.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f6f813c-f02a-47ca-a300-0b89bacac920/19e4e3315b9ec9934f06915b8d367706/aspnetcore-runtime-2.1.6-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/400d3dfc-03ab-4d2b-9d2a-5c1e9d7ef2e1/a1c8fba4dd848186623470da09ec8f88/aspnetcore-runtime-2.1.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aeab1a67-fec1-4525-af50-332817900212/016c23f84f53d0976da7070c88c7873f/aspnetcore-runtime-2.1.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/207ccb26-48a9-4588-a9f3-e009be0a37cc/afdf4db8ad55a07357f0663fbde4140b/aspnetcore-runtime-2.1.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5fbad133-3085-4748-90a7-cd863e910001/c7379a8658d8ff6547b7c74fd59615c3/aspnetcore-runtime-2.1.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/3f674c39-ab51-45c3-a7b8-094d86594fbc/9f7efb24d3486086b2d1f1a8d205a776/dotnet-hosting-2.1.6-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3690b37f-002a-4e8b-9563-cf30fbba8c57/36498efa5d47af3b9e9addb50d839db6/dotnet-sdk-2.1.502-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aa69f29a-6cde-4ca4-8c34-d60df776a648/63065948aa517fb0af456eca88eae5a5/dotnet-sdk-2.1.502-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/91c9af05-2149-4ba5-88f7-a8b77298197e/be1802e1a05a7b34dd1a5cdfbb6443f9/dotnet-sdk-2.1.502-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c8893df-3b05-48a5-b760-20f2db692c45/ff0545dbbb3c52f6fa38657ad97d65d8/dotnet-sdk-2.1.502-linux-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c8893df-3b05-48a5-b760-20f2db692c45/ff0545dbbb3c52f6fa38657ad97d65d8/dotnet-sdk-2.1.502-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7e834c38-a210-44e0-be84-0380298901e7/cc0a2df529f71622ef3dc6781cab0d6b/dotnet-sdk-2.1.502-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50729ca4-03ce-4e19-af87-bfae014b0431/1c830d9dcffa7663702e32fab6953425/dotnet-sdk-2.1.502-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1120295-348f-4135-9f0c-ac157a72bd4a/733da9695dc48fa554db4e173b8ab168/dotnet-sdk-2.1.502-rhel.6-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1120295-348f-4135-9f0c-ac157a72bd4a/733da9695dc48fa554db4e173b8ab168/dotnet-sdk-2.1.502-rhel.6-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c1120295-348f-4135-9f0c-ac157a72bd4a/733da9695dc48fa554db4e173b8ab168/dotnet-sdk-2.1.502-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/70b3a142-06fa-4d86-b1cc-67a48c1eaacb/55e147bd47db930a642a8f8176949a76/dotnet-sdk-2.1.502-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/c88b53e5-121c-4bc9-af5d-47a9d154ea64/e62eff84357c48dc8052a9c6ce5dfb8a/dotnet-sdk-2.1.502-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/caa1967f-4459-40a0-9703-cd7c4330be6a/722e7928c1bbebf2b174f5293c97328f/dotnet-sdk-2.1.502-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/e2d8f451-0133-418e-a1c6-caeda12360ef/d1ea1b0296c02a2dd4b23d33f89db12c/dotnet-sdk-2.1.502-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d77ca6f6-fa77-4eb8-82f9-9e8be43e4acd/830ad12af9a632ff05a70e2530a3c564/aspnet-2.1.6-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/04ddc39e-1db1-472f-a7a6-4a51d73cc75c/3d0f620127304ddfa981bdc9dbc6aee9/core-setup-2.1.6-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/459e604d-efc0-4e1a-838b-e311c890bdaa/bc02969da98047faf9b4d1dc1c70b349/coreclr-2.1.6-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/dc20e757-f7ca-4683-900b-3d0a94134c0d/1743c2e0e4952e9a5ddf2d1c8934af95/corefx-2.1.6-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/319e69e5-3a4a-47a9-a454-b4e17380e5da/6af8d9c315d8f24e95e6d4c9a28cfd3d/sdk-symbols-2.1.502-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/319e69e5-3a4a-47a9-a454-b4e17380e5da/6af8d9c315d8f24e95e6d4c9a28cfd3d/sdk-symbols-2.1.502-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.6-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.502-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/