# .NET Core November 2018 Update - November 13, 2018

.NET Core 2.1.6 is available for [download](2.1.6-download.md) and usage in your environment. This release includes .NET Core 2.1.6, ASP.NET Core 2.1.6 and .NET Core SDK 2.1.500. All fixes of note can be seen in the [2.1.6 commits](2.1.6-commits.md) list.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-216)
* [Known Issues](../2.1-known-issues.md)
* [Lifecycle](#net-core-lifecycle-news)

Visit the [.NET Core blog][dotnet-blog] to read more about this release. Your feedback is important and appreciated. We've created an issue at [dotnet/core.issues](https://github.com/dotnet/core/issues/) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://github.com/dotnet/dotnet-docker/blob/main/README.md)
* [microsoft/dotnet-samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)

### Azure AppServices

* Deployment of .NET Core 2.1.6 to Azure App Services will begin on today, November 13, 2018. Deployment will proceed to additional regions and is expected to complete by the end of the week.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](../../../os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Notable Changes in 2.1.6

This release includes a number of impactful fixes. Please see the [commit list](2.1.6-commits.md) for details.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.6.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7d461733-a0cd-48ee-9963-791337dcaafa/3b75ee4c7fb9d6bc7d0ddd9761676096/dotnet-runtime-2.1.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9cb31ef2-d5ec-490d-8a3f-f45f52d28fec/4c906b6132f2c0fe55e9e0209f08b352/dotnet-runtime-2.1.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b934284c-96e3-49ab-9c86-6332092bafa7/480c4ba3ddd68c4a303c8de3616ac4ee/dotnet-runtime-2.1.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c1334bc-bd26-4232-a745-2728b36a2628/8e163216cdcec15332ebf2e5575962de/dotnet-runtime-2.1.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/26452190-8866-4e1c-8bd2-e4699d775555/befaa5544a34e875621b239281d662a5/dotnet-runtime-2.1.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0f36c0b9-397b-4303-9a83-2f09e08affb0/dc43655b905e0c3d5d5fd89cafc1fb81/dotnet-runtime-2.1.6-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/95777fc5-eb49-4fe3-b136-db2c1e8c4cab/17cafbf4d0d6e234e4ea6cc143739e1d/dotnet-runtime-2.1.6-rhel.6-x64.tar.gz
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/8dcd5adb-21a8-43db-ab6a-d6c8e37b20fe/d52d48805fc35dbfa7ce411fbf5fda59/dotnet-runtime-2.1.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/3f6b6def-4e9a-4405-b21f-89f77d1605c4/52be50baa0e9bfa118fe6de80be89ab6/dotnet-runtime-2.1.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/af783fb4-da01-44f9-a8b8-9e52dda7970e/3d9920fc37175a41140f9c8af542a42c/dotnet-runtime-2.1.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/3ef3e42c-281d-43e2-969b-3f6aafef56f1/a13f4c966b0f499b8883f6e6f8b1765c/dotnet-runtime-2.1.6-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c5d6af2-868c-4021-8b25-4913daca41c3/46cfc8ddb9b8f10ebd56de1b1a534e32/aspnetcore-runtime-2.1.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e4770dec-8d9d-4591-ba45-a8ad1d71841e/fa87d518261a484787824fc0e1d9365f/aspnetcore-runtime-2.1.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5ecfed21-c776-4924-b734-126400fd324a/4e1bfb9c870ffcf99b1bf953b91ef072/aspnetcore-runtime-2.1.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1f6f813c-f02a-47ca-a300-0b89bacac920/19e4e3315b9ec9934f06915b8d367706/aspnetcore-runtime-2.1.6-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/400d3dfc-03ab-4d2b-9d2a-5c1e9d7ef2e1/a1c8fba4dd848186623470da09ec8f88/aspnetcore-runtime-2.1.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/aeab1a67-fec1-4525-af50-332817900212/016c23f84f53d0976da7070c88c7873f/aspnetcore-runtime-2.1.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/207ccb26-48a9-4588-a9f3-e009be0a37cc/afdf4db8ad55a07357f0663fbde4140b/aspnetcore-runtime-2.1.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5fbad133-3085-4748-90a7-cd863e910001/c7379a8658d8ff6547b7c74fd59615c3/aspnetcore-runtime-2.1.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/3f674c39-ab51-45c3-a7b8-094d86594fbc/9f7efb24d3486086b2d1f1a8d205a776/dotnet-hosting-2.1.6-win.exe
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/201cbc49-c122-4653-a6c6-0680643d9a26/1951cfc077d868a31563a5a172d18d78/dotnet-sdk-2.1.500-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fc8a549e-fe2e-4b88-961c-8f7b5d054faa/1676cb29cab62a698e75748a745950c7/dotnet-sdk-2.1.500-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a0a6ac11-dcce-48b7-8369-423b8652545a/c337fcbef824fd32139ee087914726ad/dotnet-sdk-2.1.500-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e5eef3df-d2e3-429b-8204-f58372eb6263/20c825ddcc6062e93ff0c60e8354d3af/dotnet-sdk-2.1.500-linux-x64.tar.gz
[dotnet-sdk-osx-gs-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/576dbb8d-03f2-4d45-857a-b226d39b3dbe/0d4fbf91aa1137352680ec98ef9edb5d/dotnet-sdk-2.1.500-osx-gs-x64.pkg
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/59a7b78f-4e86-473b-b230-c84d15505cec/766e3e5f35e7bb9677dd785071c5fbf7/dotnet-sdk-2.1.500-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/901c2283-505d-408b-a7b0-01b5ee477783/ae5185f3fde13c7a62651608387a2a71/dotnet-sdk-2.1.500-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6b4325af-ce22-4440-ba5e-b4b1444cf712/3691bc5eabd7390b47657e9d1d232355/dotnet-sdk-2.1.500-rhel.6-x64.tar.gz
[dotnet-sdk-win-gs-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9b60a25e-5b31-4550-aae1-72516c1067f6/52e8387487fecef06266a7a19c97ddee/dotnet-sdk-2.1.500-win-gs-x64.exe
[dotnet-sdk-win-gs-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/246c196e-2934-4571-bf21-b988a0f57e90/11329123100c557261e585a9871c2398/dotnet-sdk-2.1.500-win-gs-x86.exe
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/cd42f66a-2b6a-4a7a-9e69-0bb4eb5a83a1/0ce246546a0886349d9acf872f4e15a4/dotnet-sdk-2.1.500-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2a508a9d-91e8-4126-904c-f7a515f8a33b/24ff5fe2610ce1ce76370ed053b14094/dotnet-sdk-2.1.500-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/59613bc7-269f-4c39-a58a-46b35fe314c0/ddae846724f96c9886b319b8f825e475/dotnet-sdk-2.1.500-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f1e5fc51-e5f1-44d8-bd59-88b0aa849b3a/fbe1740c06c7fc87b8345c193a12bd59/dotnet-sdk-2.1.500-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d77ca6f6-fa77-4eb8-82f9-9e8be43e4acd/830ad12af9a632ff05a70e2530a3c564/aspnet-2.1.6-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/31972dfb-b0fd-4e01-9d2b-5008321dbf68/f198c9f2aa57f8c7e141d95a6c6b098d/cli-2.1.6-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/04ddc39e-1db1-472f-a7a6-4a51d73cc75c/3d0f620127304ddfa981bdc9dbc6aee9/core-setup-2.1.6-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/459e604d-efc0-4e1a-838b-e311c890bdaa/bc02969da98047faf9b4d1dc1c70b349/coreclr-2.1.6-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/dc20e757-f7ca-4683-900b-3d0a94134c0d/1743c2e0e4952e9a5ddf2d1c8934af95/corefx-2.1.6-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/05930291-d788-4c74-8727-67a8dc91bd10/abef49e4ac04610e9c3ff1317a5b4140/dotnet-sdk-2.1.6-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.6-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.500-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/2018/11/
