# .NET Core 2.1.7 Update - January 08, 2019

.NET Core 2.1.7 is available for [download](2.1.7-download.md) and usage in your environment. This release includes .NET Core 2.1.7, ASP.NET Core 2.1.7 and .NET Core SDK 2.1.503.

* [Downloads](#downloads)
* [Changes in this release](#changes-in-217)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.1-known-issues.md)

We've created an issue at [dotnet/core #2210](https://github.com/dotnet/core/issues/2210) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://github.com/dotnet/dotnet-docker/blob/main/README.md)
* [microsoft/dotnet-samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)

### Azure AppServices

* .NET Core 2.1.7 is being deployed to Azure App Services and the deployment is expected to complete in a couple of days.

## .NET Core Lifecycle News

See [.NET Core Supported OS Lifecycle Policy](../../../os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

The following OS version has changed support status since our last release:

* Fedora 27 reached [end of life](https://fedoramagazine.org/fedora-27-end-of-life/) on November 30, 2018 and is no longer supported by .NET Core.

## Changes in 2.1.7
.NET Core 2.1.7 release carries both security and non-security fixes. In addition to the listed vulnerabilities (see CVEs below) support for new Japanese calendar eras has been added and there are some Cryptography fixes.

All fixes of note can be seen in the [2.1.7 commits](2.1.7-commits.md) list.

* ### [CVE-2019-0545: .NET Core Information Disclosure Vulnerability](https://github.com/dotnet/Announcements/issues/94)

    The security update addresses the vulnerability by enforcing Cross-origin Resource Sharing (CORS) configuration to prevent its bypass in .NET Core 2.1 and 2.2. An attacker who successfully exploited the vulnerability could retrieve content, that is normally restricted, from a web application.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Microsoft.NETCore.App (System.Net.Http) | 2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.1.7

* ### [CVE-2019-0548: ASP.NET Core Denial Of Service Vulnerability](https://github.com/aspnet/Announcements/issues/335)

    This security vulnerability exists in ASP.NET Core 1.0, 1.1, 2.1 and 2.2. If an application is hosted on Internet Information Server (IIS) a remote unauthenticated attacker can use a specially crafted request to cause a Denial of Service.

    **Affected Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    AspNetCoreModule (ANCM) | Prior to 12.1.18346.0 | >=12.1.18346.0

* ### [CVE-2019-0564: ASP.NET Core Denial Of Service Vulnerability](https://github.com/aspnet/Announcements/issues/334)

    This security vulnerability exists when ASP.NET Core 2.1 and 2.2 improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

    A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the .NET Core application.

    **Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Microsoft.AspNetCore.WebSockets | 2.2.0<br/>2.1.0, 2.1.1 | 2.2.1<br/>2.1.7
    Microsoft.AspNetCore.Server.Kestrel.Core | 2.1.0, 2.1.1, 2.1.2, 2.1.3 | 2.1.7
    System.Net.WebSockets.WebSocketProtocol  | 4.5.0, 4.5.1, 4.5.2 | 4.5.3
    Microsoft.NETCore.App | 2.2.0<br/>2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.2.1 <br/> 2.1.7
    Microsoft.AspNetCore.App | 2.2.0<br/>2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.2.1 <br/> 2.1.7
    Microsoft.AspNetCore.All  | 2.2.0<br/>2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.2.1 <br/> 2.1.7

* ### [CVE-2018-8416: .NET Core Tampering Vulnerability](https://github.com/dotnet/Announcements/issues/95)

    A security vulnerability exists wherein .NET Core 2.1 improperly handles specially crafted files. An attacker who successfully exploited this vulnerability could write arbitrary files and directories to certain locations on a vulnerable system. However, an attacker would have limited control over the destination of the files and directories.

    To exploit the vulnerability, an attacker must send a specially crafted file to a vulnerable system

    **Package and Binary updates**

    Package name | Vulnerable versions | Secure versions
    ------------ | ------------------- | -------------------------
    Microsoft.NETCore.App* | 2.1.0, 2.1.1, 2.1.2, 2.1.3, 2.1.4, 2.1.5, 2.1.6 | 2.1.7

    \* Updated Microsoft.NETCore.App contains System.IO.Compression.ZipFile.dll version 4.3.1, which is not available separately on nuget.org.

## Packages updated in this release:
Package name | Version
------------ | -------------------
dotnet-aspnet-codegenerator | 2.1.7
Microsoft.AspNetCore | 2.1.7
Microsoft.AspNetCore.All | 2.1.7
Microsoft.AspNetCore.App | 2.1.7
Microsoft.AspNetCore.Server.IISIntegration | 2.1.7
Microsoft.AspNetCore.Server.Kestrel.Core | 2.1.7
Microsoft.AspNetCore.WebSockets | 2.1.7
Microsoft.NETCore.App | 2.1.7
Microsoft.NETCore.DotNetAppHost | 2.1.7
Microsoft.NETCore.DotNetHost | 2.1.7
Microsoft.NETCore.DotNetHostPolicy | 2.1.7
Microsoft.NETCore.DotNetHostResolver | 2.1.7
Microsoft.VisualStudio.Web.CodeGeneration | 2.1.7
Microsoft.VisualStudio.Web.CodeGeneration.Contracts | 2.1.7
Microsoft.VisualStudio.Web.CodeGeneration.Core | 2.1.7
Microsoft.VisualStudio.Web.CodeGeneration.Design | 2.1.7
Microsoft.VisualStudio.Web.CodeGeneration.EntityFrameworkCore | 2.1.7
Microsoft.VisualStudio.Web.CodeGeneration.Templating | 2.1.7
Microsoft.VisualStudio.Web.CodeGeneration.Utils | 2.1.7
Microsoft.VisualStudio.Web.CodeGenerators.Mvc | 2.1.7
runtime.linux-arm.Microsoft.NETCore.App | 2.1.7
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.linux-arm.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.linux-arm64.Microsoft.NETCore.App | 2.1.7
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.linux-musl-x64.Microsoft.NETCore.App | 2.1.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.linux-x64.Microsoft.NETCore.App | 2.1.7
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.linux-x64.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.osx-x64.Microsoft.NETCore.App | 2.1.7
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.osx-x64.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.rhel.6-x64.Microsoft.NETCore.App | 2.1.7
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.win-arm.Microsoft.NETCore.App | 2.1.7
runtime.win-arm.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.win-arm.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.win-arm64.Microsoft.NETCore.App | 2.1.7
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.win-arm64.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.win-x64.Microsoft.NETCore.App | 2.1.7
runtime.win-x64.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.win-x64.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver | 2.1.7
runtime.win-x86.Microsoft.NETCore.App | 2.1.7
runtime.win-x86.Microsoft.NETCore.DotNetAppHost | 2.1.7
runtime.win-x86.Microsoft.NETCore.DotNetHost | 2.1.7
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy | 2.1.7
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver | 2.1.7
System.IO.Pipelines | 4.5.3
System.Memory | 4.5.2
System.Net.Http.WinHttpHandler | 4.5.2
System.Net.WebSockets.WebSocketProtocol | 4.5.3
System.Security.Cryptography.Pkcs | 4.5.2
System.Text.Encoding.CodePages | 4.5.1
System.Threading.Tasks.Extensions | 4.5.2

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.1.7.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7fad978-49ee-479b-85dc-c14201a58250/a574ba4525da0e49c928ced62efc449b/dotnet-runtime-2.1.7-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/547090fb-be5c-486f-8de4-c2b7adc0f943/5ac4d7a89c604f59d6edad4b9e6a8465/dotnet-runtime-2.1.7-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/da3e3ff9-914c-4ec1-9d13-79bb15e5f6c0/f409e78ed0fe8f6aa8a9629cf9105534/dotnet-runtime-2.1.7-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6a99aa53-d80e-4d3a-ac85-b92f362dbed6/b2157451fc7ecabca3b5ebca933353bb/dotnet-runtime-2.1.7-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fa4e55cf-bc9c-44c6-b559-de851f812b55/b31006297946dfa8e3704a1dcd9021a4/dotnet-runtime-2.1.7-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/edb8800f-3bee-40f4-a756-18fba35a23fa/572e807dc511314637938fc775eecb77/dotnet-runtime-2.1.7-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee59a1da-cf5e-4cda-9cd3-c5235bb837cb/c25f644c526f4f4f630a464e1ea89ca2/dotnet-runtime-2.1.7-rhel.6-x64.tar.gz
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e7afbfad-c7b1-4e0f-85cf-5b3a46bda824/26d4572558fe4376b1a756880bddba5b/dotnet-runtime-2.1.7-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f2c0da88-394d-4866-be55-aae40d9bc090/011d14383da063a3240e6829da2eb077/dotnet-runtime-2.1.7-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ee9763b7-0530-42da-bf7a-aaaf680a967c/bf6d29f3c4f63271d5717bf225768d87/dotnet-runtime-2.1.7-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/23e9335b-3ac7-43c0-a6c6-f364291992c2/aaa1d7e04ad862822faf2f8b1e22d31b/dotnet-runtime-2.1.7-win-x86.zip
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/eed36d24-bfa1-4b12-a56f-e889d005f9a7/c2b5b8ca4c1d16dd1e89c22bbeb6a9cf/aspnetcore-runtime-2.1.7-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0d705849-fcac-4a1d-911d-fe102630034e/fe83d9a5e69c117a8d78b1998fc38105/aspnetcore-runtime-2.1.7-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/085b427b-66f6-4cf5-bee3-5f4cbef2b72c/9c1ad276cf957258d123a3b268ec9304/aspnetcore-runtime-2.1.7-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd74bdd1-9eb4-46b2-b762-abedf336f049/686cfa8f0212a20f25109fe1061bfe01/aspnetcore-runtime-2.1.7-osx-x64.tar.gz
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/37e3d4da-cb76-41e5-9ca5-df23a0124625/4dd826c4936622cefe05b48f239a1ed0/aspnetcore-runtime-2.1.7-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2983b874-4d70-431a-9953-f4c59a67cbf4/96c1f7f54836e67eb10086f6dac206d3/aspnetcore-runtime-2.1.7-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0f40be3f-6da7-47f7-9aa0-e82fe8e6e84c/ec1c3554534585a426712ffcba2fbe7c/aspnetcore-runtime-2.1.7-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/15fca027-7eec-4b0d-b0e4-6b3d3e5ca1ca/5b5ae283fcdb3bc10ba419f6f0ff470b/aspnetcore-runtime-2.1.7-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dc3606d0-06b2-4ddb-9190-daaf9d2947e4/8af36c231247dbdbf4dde41b8a70b221/dotnet-hosting-2.1.7-win.exe
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/77b2abb9-2107-4e4c-9e59-41cbf2cc46da/4e8c7ada2734f13a6e7efb62c6e69b29/dotnet-sdk-2.1.503-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32c34b80-94ba-4d0b-b42e-0d5c3fde7c44/a36914e63cf39846bace3a9b0d563517/dotnet-sdk-2.1.503-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c661c05-494b-4ebe-a56f-2dcc084df867/62017c1bc7a47b364518b74b47c76347/dotnet-sdk-2.1.503-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/04d83723-8370-4b54-b8b9-55708822fcde/63aab1f4d0be5246e3a92e1eb3063935/dotnet-sdk-2.1.503-linux-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/04d83723-8370-4b54-b8b9-55708822fcde/63aab1f4d0be5246e3a92e1eb3063935/dotnet-sdk-2.1.503-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/51e082b3-194f-4056-97d1-572adba62ba7/8c9d65121fe233a10f4411f4da4dcb57/dotnet-sdk-2.1.503-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c922688d-74e8-4af5-bcc8-5850eafbca7f/cf3b9a0b06c0dfa3a5098f893a9730bd/dotnet-sdk-2.1.503-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c316425-97ed-4b1d-b687-48668d4c4955/f2cd24a3a4fd9a68e59400b03e5c7789/dotnet-sdk-2.1.503-rhel.6-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c316425-97ed-4b1d-b687-48668d4c4955/f2cd24a3a4fd9a68e59400b03e5c7789/dotnet-sdk-2.1.503-rhel.6-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3c316425-97ed-4b1d-b687-48668d4c4955/f2cd24a3a4fd9a68e59400b03e5c7789/dotnet-sdk-2.1.503-rhel.6-x64.tar.gz
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/9afc36fb-48ba-43ae-9f37-df634383ae84/2c1329b490c8d4b2787164286bde115c/dotnet-sdk-2.1.503-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/81e18dc2-7747-4b2d-9912-3be0f83050f1/5bc41cb27df3da63378df2d051be4b7f/dotnet-sdk-2.1.503-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ced9d68b-7d29-4b25-a8a3-01bae68d8f1c/7c89ce22382c7b43fd3ce1e8fd5d3148/dotnet-sdk-2.1.503-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/db3c40c5-4140-4b2f-8e70-530873712c4c/b2558668b4e85418231df2e171b128b1/dotnet-sdk-2.1.503-win-x86.zip

[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/26f3234d-4e72-4cba-a27b-e615595c15dc/2e83ee0f9b7e7a62dc212ef766bc5013/aspnet-2.1.7-symbols.zip
[cli-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b076d7e5-00d4-40dd-843a-b2747aa08fd9/84a4d47dd0af397ec1c53efe5037cef8/cli-2.1.7-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/fb2d63cc-c6a9-4412-b563-5e9851815f6f/7faf1cfaf0952c6fd9fb4beb42891049/core-setup-2.1.7-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ea9824bb-3641-457b-a9aa-2be66ac35de7/0c21dc003021c6e38cd74c41e7be1302/coreclr-2.1.7-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/6ea20771-8d4f-4569-9f91-a2d583391d64/58e1b0d948db6dc17179b57c385e18f0/corefx-2.1.7-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/3b209b8e-4f72-4546-bc8a-5f037fe9c9a6/1e0a12163015993db5fbc22b69303d8a/sdk-symbols-2.1.7-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.7-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.1.503-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/2019/01/
