# .NET Core 2.1 Release Candidate (RC) 1 - May 6, 2018

.NET Core 2.1.0 RC1 is available for download and usage in your environment. Have a look at the [Known Issues](2.1.0-rc1-known-issues.md) document as there are a few things to be aware of before installing.

* [Downloads](https://dotnet.microsoft.com/download)

## Blog Round up

* [.NET Core](https://devblogs.microsoft.com/dotnet/announcing-net-core-2-1-rc-1)
* [ASP .NET Core](https://devblogs.microsoft.com/dotnet/asp-net-core-2-1-0-rc1-now-available/)
* [Entity Framework Core](https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-2-1-rc-1/)

The .NET Core SDK 2.1 RC includes .NET Core 2.1 Runtime RC so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 2.1 RC, the following command will show that you're running version `2.1.300-rc1-008673` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #1506](https://github.com/dotnet/core/issues/1506) for your questions and comments.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Look for the 2.1 RC images.

## Azure AppServices

.NET Core 2.1 RC 1 in Azure App Services will begin rolling out Thursday, 5/10 and and will be available in all regions a few days later.
* [Deployment of ASP.NET 2.0.8 and .NET Core 2.1.0-rc1 to Azure App Service](https://github.com/Azure/app-service-announcements/issues/107)

## Notable Changes in RC1

### Linux installer changes and distro version updates

#### Installer changes


We have been working to improve our Linux installers and the RC release takes another step. System dependencies are now installed using a `runtime-deps` package. This enables us to create "agnostic" Runtime and SDK installers which are the same across distros. You don't need to do anything different when installing, this package is referenced as a dependency of the Runtime installer.

For the final release of 2.1, the installers will properly support package manager updates (eg `apt-get update`)

#### Supported version changes

.NET Core is now available for Ubuntu 18.04.  Congratulations to Canonical on the release!

### Breaking API changes

Many APIs received updates from Preview 1 which are considered breaking changes. Below are a few notable changes and a [detailed API diff](https://github.com/dotnet/core/tree/main/release-notes/2.1/Preview/api-diff/preview2) is available to help determine if any will impact existing projects build on 2.1.0 Preview 1.

### System.Security

| Area | Description | Details | Github Issue |
| ---- | ----------- | ------- | ------------ |
| System.Security | New SignedCms APIs | System.Security.Cryptography.Pkcs.SignedCms is now available in the System.Security.Cryptography.Pkcs package.  The .NET Core implementation is available to all .NET Core platforms and has parity with the class from .NET Framework. | [corefx/14197](https://github.com/dotnet/corefx/issues/14197) |
| System.Security | New X509Certificate.GetCertHash overload for SHA-2 | New overloads for X509Certificate.GetCertHash and X509Certificate.GetCertHashString accept a hash algorithm identifier to enable callers to get certificate thumbprint values using algorithms other than SHA-1. | [corefx/16493](https://github.com/dotnet/corefx/issues/16493) |
| System.Security | New Span-based cryptography APIs | Span-based API is available for hashing, HMAC, (cryptographic) random number generation, asymmetric signature generation, asymmetric signature processing, and RSA encryption. | |
| System.Security | Rfc2898DeriveBytes performance improvements | By switching to Span-based computations the computations of Rfc2898DeriveBytes (PBKDF2) have sped up about 15% compared to prior releases.  Users who have benchmarked an iteration count for an amount of server time can now increase their iteration count accordingly. | |
| System.Security | Added CryptographicOperations class | CryptographicOperations.FixedTimeEquals takes a fixed amount of time to return for any two inputs of the same length, making it suitable for use in cryptographic verification to avoid contributing to timing side-channel information.  CryptographicOperations.ZeroMemory is a memory clearing routine which cannot be optimized away via a write-without-subsequent-read optimization. | |
| System.Security | Added static RandomNumberGenerator.Fill | The static RandomNumberGenerator.Fill will fill a Span with random values using the system-preferred CSPRNG, and does not require the caller to manage the lifetime of an IDisposable resource. | |
| System.Security | Added support for RFC 3161 cryptographic timestamps | New API to request, read, validate, and create TimestampToken values as defined by RFC 3161. | |
| System.Security | Unix EnvelopedCms | The EnvelopedCms class is now available on Linux and macOS. | |
| System.Security | Added ECDiffieHellman | Elliptic-Curve Diffie-Hellman (ECDH) is now available on .NET Core via the ECDiffieHellman class family with the same surface area as .NET Framework 4.7. | |
| System.Security | Added RSA-OAEP-SHA2 and RSA-PSS to Unix platforms | Starting with this release the instance provided by RSA.Create() on .NET Core can always encrypt or decrypt with OAEP using a SHA-2 digest, as well as generate or validate signatures using RSA-PSS. | |

### System.IO

| Area | Description | Details | Github Issue |
| ---- | ----------- | ------- | ------------ |
| System.IO.Compression | Add new Brotli Compression APIs | Add API to compress and decompress using the Brotli algorithm, a general-purpose lossless compression algorithm used primarily by web browsers and servers. Operations may be completed using either the stream-based BrotliStream or the high-performance span-based BrotliEncoder/BrotliDecoder classes. | [corefx/25785](https://github.com/dotnet/corefx/issues/25785) |

### Global Tools

Global tools let you install a tool from a NuGet feed into your local path. This makes it available in a similar manner to npm -g. Alternatively you can install tools in a specific directory with --tool-path, which is particularly useful in CI scenarios.

NOTE: There were significant changes after Preview 1 to both syntax and structure.

```bash
dotnet tool install -g awesomeTool
dotnet tool install --install-path specialPath awesomeTool
```

Other features available for Global Tools:

```bash
dotnet tool list
dotnet tool uninstall
dotnet tool update
```

### Bundled Tools

Several common development tools are now included in the .NET Core SDK.

The following tools are now included in the .NET Core SDK and no longer need to be included in the project file, or installed with `dotnet install`:

* watch
* dev-certs
* sql-cache
* user-secrets
* ef

