# System.Buffers.Binary

``` diff
+namespace System.Buffers.Binary {
+    public static class BinaryPrimitives {
+        public static short ReadInt16BigEndian(ReadOnlySpan<byte> buffer);
+        public static short ReadInt16LittleEndian(ReadOnlySpan<byte> buffer);
+        public static int ReadInt32BigEndian(ReadOnlySpan<byte> buffer);
+        public static int ReadInt32LittleEndian(ReadOnlySpan<byte> buffer);
+        public static long ReadInt64BigEndian(ReadOnlySpan<byte> buffer);
+        public static long ReadInt64LittleEndian(ReadOnlySpan<byte> buffer);
+        public static T ReadMachineEndian<T>(ReadOnlySpan<byte> buffer) where T : struct;
+        public static ushort ReadUInt16BigEndian(ReadOnlySpan<byte> buffer);
+        public static ushort ReadUInt16LittleEndian(ReadOnlySpan<byte> buffer);
+        public static uint ReadUInt32BigEndian(ReadOnlySpan<byte> buffer);
+        public static uint ReadUInt32LittleEndian(ReadOnlySpan<byte> buffer);
+        public static ulong ReadUInt64BigEndian(ReadOnlySpan<byte> buffer);
+        public static ulong ReadUInt64LittleEndian(ReadOnlySpan<byte> buffer);
+        public static byte ReverseEndianness(byte value);
+        public static short ReverseEndianness(short value);
+        public static int ReverseEndianness(int value);
+        public static long ReverseEndianness(long value);
+        public static sbyte ReverseEndianness(sbyte value);
+        public static ushort ReverseEndianness(ushort value);
+        public static uint ReverseEndianness(uint value);
+        public static ulong ReverseEndianness(ulong value);
+        public static bool TryReadInt16BigEndian(ReadOnlySpan<byte> buffer, out short value);
+        public static bool TryReadInt16LittleEndian(ReadOnlySpan<byte> buffer, out short value);
+        public static bool TryReadInt32BigEndian(ReadOnlySpan<byte> buffer, out int value);
+        public static bool TryReadInt32LittleEndian(ReadOnlySpan<byte> buffer, out int value);
+        public static bool TryReadInt64BigEndian(ReadOnlySpan<byte> buffer, out long value);
+        public static bool TryReadInt64LittleEndian(ReadOnlySpan<byte> buffer, out long value);
+        public static bool TryReadMachineEndian<T>(ReadOnlySpan<byte> buffer, out T value) where T : struct;
+        public static bool TryReadUInt16BigEndian(ReadOnlySpan<byte> buffer, out ushort value);
+        public static bool TryReadUInt16LittleEndian(ReadOnlySpan<byte> buffer, out ushort value);
+        public static bool TryReadUInt32BigEndian(ReadOnlySpan<byte> buffer, out uint value);
+        public static bool TryReadUInt32LittleEndian(ReadOnlySpan<byte> buffer, out uint value);
+        public static bool TryReadUInt64BigEndian(ReadOnlySpan<byte> buffer, out ulong value);
+        public static bool TryReadUInt64LittleEndian(ReadOnlySpan<byte> buffer, out ulong value);
+        public static bool TryWriteInt16BigEndian(Span<byte> buffer, short value);
+        public static bool TryWriteInt16LittleEndian(Span<byte> buffer, short value);
+        public static bool TryWriteInt32BigEndian(Span<byte> buffer, int value);
+        public static bool TryWriteInt32LittleEndian(Span<byte> buffer, int value);
+        public static bool TryWriteInt64BigEndian(Span<byte> buffer, long value);
+        public static bool TryWriteInt64LittleEndian(Span<byte> buffer, long value);
+        public static bool TryWriteMachineEndian<T>(Span<byte> buffer, ref T value) where T : struct;
+        public static bool TryWriteUInt16BigEndian(Span<byte> buffer, ushort value);
+        public static bool TryWriteUInt16LittleEndian(Span<byte> buffer, ushort value);
+        public static bool TryWriteUInt32BigEndian(Span<byte> buffer, uint value);
+        public static bool TryWriteUInt32LittleEndian(Span<byte> buffer, uint value);
+        public static bool TryWriteUInt64BigEndian(Span<byte> buffer, ulong value);
+        public static bool TryWriteUInt64LittleEndian(Span<byte> buffer, ulong value);
+        public static void WriteInt16BigEndian(Span<byte> buffer, short value);
+        public static void WriteInt16LittleEndian(Span<byte> buffer, short value);
+        public static void WriteInt32BigEndian(Span<byte> buffer, int value);
+        public static void WriteInt32LittleEndian(Span<byte> buffer, int value);
+        public static void WriteInt64BigEndian(Span<byte> buffer, long value);
+        public static void WriteInt64LittleEndian(Span<byte> buffer, long value);
+        public static void WriteMachineEndian<T>(Span<byte> buffer, ref T value) where T : struct;
+        public static void WriteUInt16BigEndian(Span<byte> buffer, ushort value);
+        public static void WriteUInt16LittleEndian(Span<byte> buffer, ushort value);
+        public static void WriteUInt32BigEndian(Span<byte> buffer, uint value);
+        public static void WriteUInt32LittleEndian(Span<byte> buffer, uint value);
+        public static void WriteUInt64BigEndian(Span<byte> buffer, ulong value);
+        public static void WriteUInt64LittleEndian(Span<byte> buffer, ulong value);
+    }
+}
```

