# System.Buffers

``` diff
 namespace System.Buffers {
+    public interface IRetainable {
+        bool Release();
+        void Retain();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MemoryHandle : IDisposable {
+        public unsafe MemoryHandle(IRetainable owner, void* pointer=null, GCHandle handle=default(GCHandle));
+        public bool HasPointer { get; }
+        public unsafe void* Pointer { get; }
+        public void Dispose();
+    }
+    public enum OperationStatus {
+        DestinationTooSmall = 1,
+        Done = 0,
+        InvalidData = 3,
+        NeedMoreData = 2,
+    }
+    public abstract class OwnedMemory<T> : IDisposable, IRetainable {
+        protected OwnedMemory();
+        public abstract bool IsDisposed { get; }
+        protected abstract bool IsRetained { get; }
+        public abstract int Length { get; }
+        public Memory<T> Memory { get; }
+        public abstract Span<T> Span { get; }
+        public void Dispose();
+        protected abstract void Dispose(bool disposing);
+        public abstract MemoryHandle Pin(int offset=0);
+        public abstract bool Release();
+        public abstract void Retain();
+        protected internal abstract bool TryGetArray(out ArraySegment<T> arraySegment);
+    }
+    public delegate void ReadOnlySpanAction<T, in TArg>(ReadOnlySpan<T> span, TArg arg);
+    public delegate void SpanAction<T, in TArg>(Span<T> span, TArg arg);
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct StandardFormat : IEquatable<StandardFormat> {
+        public const byte MaxPrecision = (byte)99;
+        public const byte NoPrecision = (byte)255;
+        public StandardFormat(char symbol, byte precision=(byte)255);
+        public bool HasPrecision { get; }
+        public bool IsDefault { get; }
+        public byte Precision { get; }
+        public char Symbol { get; }
+        public bool Equals(StandardFormat other);
+        public override bool Equals(object obj);
+        public override int GetHashCode();
+        public static bool operator ==(StandardFormat left, StandardFormat right);
+        public static implicit operator StandardFormat (char symbol);
+        public static bool operator !=(StandardFormat left, StandardFormat right);
+        public static StandardFormat Parse(ReadOnlySpan<char> format);
+        public static StandardFormat Parse(string format);
+        public override string ToString();
+    }
 }
```

