# System.IO

``` diff
 namespace System.IO {
     public class BinaryReader : IDisposable {
+        public virtual int Read(Span<byte> buffer);
+        public virtual int Read(Span<char> buffer);
     }
     public class BinaryWriter : IDisposable {
+        public virtual void Write(ReadOnlySpan<byte> buffer);
+        public virtual void Write(ReadOnlySpan<char> chars);
     }
     public class FileStream : Stream {
-        public string Name { get; }
+        public virtual string Name { get; }
-        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginRead(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
-        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] array, int offset, int numBytes, AsyncCallback callback, object state);
     }
     public class MemoryStream : Stream {
+        public override int Read(Span<byte> destination);
+        public override ValueTask<int> ReadAsync(Memory<byte> destination, CancellationToken cancellationToken=default(CancellationToken));
+        public override void Write(ReadOnlySpan<byte> source);
+        public override Task WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken=default(CancellationToken));
     }
     public static class Path {
+        public static bool IsPathFullyQualified(string path);
     }
     public abstract class Stream : MarshalByRefObject, IDisposable {
+        public Task CopyToAsync(Stream destination, CancellationToken cancellationToken);
+        public virtual int Read(Span<byte> destination);
+        public virtual ValueTask<int> ReadAsync(Memory<byte> destination, CancellationToken cancellationToken=default(CancellationToken));
+        public virtual void Write(ReadOnlySpan<byte> source);
+        public virtual Task WriteAsync(ReadOnlyMemory<byte> source, CancellationToken cancellationToken=default(CancellationToken));
     }
     public class StreamReader : TextReader {
+        public override int Read(Span<char> buffer);
+        public override ValueTask<int> ReadAsync(Memory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
+        public override int ReadBlock(Span<char> buffer);
+        public override ValueTask<int> ReadBlockAsync(Memory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
     }
     public class StreamWriter : TextWriter {
+        public override void Write(ReadOnlySpan<char> buffer);
+        public override Task WriteAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
+        public override void WriteLine(ReadOnlySpan<char> buffer);
+        public override void WriteLine(string value);
+        public override Task WriteLineAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
     }
     public class StringReader : TextReader {
+        public override int Read(Span<char> buffer);
+        public override ValueTask<int> ReadAsync(Memory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
+        public override int ReadBlock(Span<char> buffer);
+        public override ValueTask<int> ReadBlockAsync(Memory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
     }
     public class StringWriter : TextWriter {
+        public override void Write(ReadOnlySpan<char> buffer);
+        public override Task WriteAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
+        public override void WriteLine(ReadOnlySpan<char> buffer);
+        public override Task WriteLineAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
     }
     public abstract class TextReader : MarshalByRefObject, IDisposable {
+        public virtual int Read(Span<char> buffer);
+        public virtual ValueTask<int> ReadAsync(Memory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
+        public virtual int ReadBlock(Span<char> buffer);
+        public virtual ValueTask<int> ReadBlockAsync(Memory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
     }
     public abstract class TextWriter : MarshalByRefObject, IDisposable {
+        public virtual void Write(ReadOnlySpan<char> buffer);
+        public virtual Task WriteAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
+        public virtual void WriteLine(ReadOnlySpan<char> buffer);
+        public virtual Task WriteLineAsync(ReadOnlyMemory<char> buffer, CancellationToken cancellationToken=default(CancellationToken));
     }
     public class UnmanagedMemoryStream : Stream {
+        public override int Read(Span<byte> destination);
+        public override void Write(ReadOnlySpan<byte> source);
     }
 }
```

