# System.Security.Cryptography

``` diff
 namespace System.Security.Cryptography {
     public class CryptoStream : Stream, IDisposable {
+        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
+        public override int EndRead(IAsyncResult asyncResult);
+        public override void EndWrite(IAsyncResult asyncResult);
     }
     public abstract class DSA : AsymmetricAlgorithm {
+        public virtual bool TryCreateSignature(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected virtual bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm);
+        public virtual bool VerifySignature(ReadOnlySpan<byte> rgbHash, ReadOnlySpan<byte> rgbSignature);
     }
     public abstract class ECDsa : AsymmetricAlgorithm {
+        protected virtual bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignHash(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        public virtual bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm);
+        public virtual bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature);
     }
     public abstract class HashAlgorithm : ICryptoTransform, IDisposable {
+        protected virtual void HashCore(ReadOnlySpan<byte> source);
+        public bool TryComputeHash(ReadOnlySpan<byte> source, Span<byte> destination, out int bytesWritten);
+        protected virtual bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public abstract class HMAC : KeyedHashAlgorithm {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACMD5 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA1 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA256 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA384 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public class HMACSHA512 : HMAC {
+        protected override void HashCore(ReadOnlySpan<byte> source);
+        protected override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class IncrementalHash : IDisposable {
+        public void AppendData(ReadOnlySpan<byte> data);
+        public bool TryGetHashAndReset(Span<byte> destination, out int bytesWritten);
     }
     public abstract class RandomNumberGenerator : IDisposable {
+        public virtual void GetBytes(Span<byte> data);
+        public virtual void GetNonZeroBytes(Span<byte> data);
     }
     public abstract class RSA : AsymmetricAlgorithm {
+        public virtual bool TryDecrypt(ReadOnlySpan<byte> source, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        public virtual bool TryEncrypt(ReadOnlySpan<byte> source, Span<byte> destination, RSAEncryptionPadding padding, out int bytesWritten);
+        protected virtual bool TryHashData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, out int bytesWritten);
+        public virtual bool TrySignData(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding, out int bytesWritten);
+        public virtual bool TrySignHash(ReadOnlySpan<byte> source, Span<byte> destination, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding, out int bytesWritten);
+        public virtual bool VerifyData(ReadOnlySpan<byte> data, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
+        public virtual bool VerifyHash(ReadOnlySpan<byte> hash, ReadOnlySpan<byte> signature, HashAlgorithmName hashAlgorithm, RSASignaturePadding padding);
     }
     public sealed class SHA1Managed : SHA1 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA256Managed : SHA256 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA384Managed : SHA384 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
     public sealed class SHA512Managed : SHA512 {
+        protected sealed override void HashCore(ReadOnlySpan<byte> source);
+        protected sealed override bool TryHashFinal(Span<byte> destination, out int bytesWritten);
     }
 }
```

