# System.Buffers

``` diff
 namespace System.Buffers {
+    public static class BuffersExtensions {
+        public static void CopyTo<T>(this ref ReadOnlySequence<T> source, Span<T> destination);
+        public static Nullable<SequencePosition> PositionOf<T>(this ref ReadOnlySequence<T> source, T value) where T : IEquatable<T>;
+        public static T[] ToArray<T>(this ref ReadOnlySequence<T> sequence);
+        public static void Write<T>(this IBufferWriter<T> writer, ReadOnlySpan<T> value);
+    }
+    public interface IBufferWriter<T> {
+        void Advance(int count);
+        Memory<T> GetMemory(int sizeHint=0);
+        Span<T> GetSpan(int sizeHint=0);
+    }
+    public interface IMemoryOwner<T> : IDisposable {
+        Memory<T> Memory { get; }
+    }
+    public interface IPinnable {
+        MemoryHandle Pin(int elementIndex);
+        void Unpin();
+    }
-    public interface IRetainable {
 {
-        bool Release();

-        void Retain();

-    }
     [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
     public struct MemoryHandle : IDisposable {
-        public unsafe MemoryHandle(IRetainable owner, void* pointer=null, GCHandle handle=default(GCHandle));

+        public unsafe MemoryHandle(void* pointer, GCHandle handle=default(GCHandle), IPinnable pinnable=null);
-        public bool HasPointer { get; }

     }
+    public abstract class MemoryManager<T> : IDisposable, IMemoryOwner<T>, IPinnable {
+        protected MemoryManager();
+        public virtual int Length { get; }
+        public virtual Memory<T> Memory { get; }
+        protected abstract void Dispose(bool disposing);
+        public abstract Span<T> GetSpan();
+        public abstract MemoryHandle Pin(int elementIndex=0);
+        void System.IDisposable.Dispose();
+        protected internal virtual bool TryGetArray(out ArraySegment<T> segment);
+        public abstract void Unpin();
+    }
+    public abstract class MemoryPool<T> : IDisposable {
+        protected MemoryPool();
+        public abstract int MaxBufferSize { get; }
+        public static MemoryPool<T> Shared { get; }
+        public void Dispose();
+        protected abstract void Dispose(bool disposing);
+        public abstract IMemoryOwner<T> Rent(int minBufferSize=-1);
+    }
-    public abstract class OwnedMemory<T> : IDisposable, IRetainable {
 {
-        protected OwnedMemory();

-        public abstract bool IsDisposed { get; }

-        protected abstract bool IsRetained { get; }

-        public abstract int Length { get; }

-        public Memory<T> Memory { get; }

-        public abstract Span<T> Span { get; }

-        public void Dispose();

-        protected abstract void Dispose(bool disposing);

-        public abstract MemoryHandle Pin(int offset=0);

-        public abstract bool Release();

-        public abstract void Retain();

-        protected internal abstract bool TryGetArray(out ArraySegment<T> arraySegment);

-    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ReadOnlySequence<T> {
+        public static readonly ReadOnlySequence<T> Empty;
+        public ReadOnlySequence(ReadOnlySequenceSegment<T> startSegment, int startIndex, ReadOnlySequenceSegment<T> endSegment, int endIndex);
+        public ReadOnlySequence(ReadOnlyMemory<T> memory);
+        public ReadOnlySequence(T[] array);
+        public ReadOnlySequence(T[] array, int start, int length);
+        public SequencePosition End { get; }
+        public ReadOnlyMemory<T> First { get; }
+        public bool IsEmpty { get; }
+        public bool IsSingleSegment { get; }
+        public long Length { get; }
+        public SequencePosition Start { get; }
+        public ReadOnlySequence<T>.Enumerator GetEnumerator();
+        public SequencePosition GetPosition(long offset);
+        public SequencePosition GetPosition(long offset, SequencePosition origin);
+        public ReadOnlySequence<T> Slice(int start, int length);
+        public ReadOnlySequence<T> Slice(int start, SequencePosition end);
+        public ReadOnlySequence<T> Slice(long start);
+        public ReadOnlySequence<T> Slice(long start, long length);
+        public ReadOnlySequence<T> Slice(long start, SequencePosition end);
+        public ReadOnlySequence<T> Slice(SequencePosition start);
+        public ReadOnlySequence<T> Slice(SequencePosition start, int length);
+        public ReadOnlySequence<T> Slice(SequencePosition start, long length);
+        public ReadOnlySequence<T> Slice(SequencePosition start, SequencePosition end);
+        public override string ToString();
+        public bool TryGet(ref SequencePosition position, out ReadOnlyMemory<T> memory, bool advance=true);
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct Enumerator {
+            public Enumerator(ref ReadOnlySequence<T> sequence);
+            public ReadOnlyMemory<T> Current { get; }
+            public bool MoveNext();
+        }
+    }
+    public abstract class ReadOnlySequenceSegment<T> {
+        protected ReadOnlySequenceSegment();
+        public ReadOnlyMemory<T> Memory { get; protected set; }
+        public ReadOnlySequenceSegment<T> Next { get; protected set; }
+        public long RunningIndex { get; protected set; }
+    }
 }
```

