# System.Buffers.Binary

``` diff
+namespace System.Buffers.Binary {
+    public static class BinaryPrimitives {
+        public static short ReadInt16BigEndian(ReadOnlySpan<byte> source);
+        public static short ReadInt16LittleEndian(ReadOnlySpan<byte> source);
+        public static int ReadInt32BigEndian(ReadOnlySpan<byte> source);
+        public static int ReadInt32LittleEndian(ReadOnlySpan<byte> source);
+        public static long ReadInt64BigEndian(ReadOnlySpan<byte> source);
+        public static long ReadInt64LittleEndian(ReadOnlySpan<byte> source);
+        public static ushort ReadUInt16BigEndian(ReadOnlySpan<byte> source);
+        public static ushort ReadUInt16LittleEndian(ReadOnlySpan<byte> source);
+        public static uint ReadUInt32BigEndian(ReadOnlySpan<byte> source);
+        public static uint ReadUInt32LittleEndian(ReadOnlySpan<byte> source);
+        public static ulong ReadUInt64BigEndian(ReadOnlySpan<byte> source);
+        public static ulong ReadUInt64LittleEndian(ReadOnlySpan<byte> source);
+        public static byte ReverseEndianness(byte value);
+        public static short ReverseEndianness(short value);
+        public static int ReverseEndianness(int value);
+        public static long ReverseEndianness(long value);
+        public static sbyte ReverseEndianness(sbyte value);
+        public static ushort ReverseEndianness(ushort value);
+        public static uint ReverseEndianness(uint value);
+        public static ulong ReverseEndianness(ulong value);
+        public static bool TryReadInt16BigEndian(ReadOnlySpan<byte> source, out short value);
+        public static bool TryReadInt16LittleEndian(ReadOnlySpan<byte> source, out short value);
+        public static bool TryReadInt32BigEndian(ReadOnlySpan<byte> source, out int value);
+        public static bool TryReadInt32LittleEndian(ReadOnlySpan<byte> source, out int value);
+        public static bool TryReadInt64BigEndian(ReadOnlySpan<byte> source, out long value);
+        public static bool TryReadInt64LittleEndian(ReadOnlySpan<byte> source, out long value);
+        public static bool TryReadUInt16BigEndian(ReadOnlySpan<byte> source, out ushort value);
+        public static bool TryReadUInt16LittleEndian(ReadOnlySpan<byte> source, out ushort value);
+        public static bool TryReadUInt32BigEndian(ReadOnlySpan<byte> source, out uint value);
+        public static bool TryReadUInt32LittleEndian(ReadOnlySpan<byte> source, out uint value);
+        public static bool TryReadUInt64BigEndian(ReadOnlySpan<byte> source, out ulong value);
+        public static bool TryReadUInt64LittleEndian(ReadOnlySpan<byte> source, out ulong value);
+        public static bool TryWriteInt16BigEndian(Span<byte> destination, short value);
+        public static bool TryWriteInt16LittleEndian(Span<byte> destination, short value);
+        public static bool TryWriteInt32BigEndian(Span<byte> destination, int value);
+        public static bool TryWriteInt32LittleEndian(Span<byte> destination, int value);
+        public static bool TryWriteInt64BigEndian(Span<byte> destination, long value);
+        public static bool TryWriteInt64LittleEndian(Span<byte> destination, long value);
+        public static bool TryWriteUInt16BigEndian(Span<byte> destination, ushort value);
+        public static bool TryWriteUInt16LittleEndian(Span<byte> destination, ushort value);
+        public static bool TryWriteUInt32BigEndian(Span<byte> destination, uint value);
+        public static bool TryWriteUInt32LittleEndian(Span<byte> destination, uint value);
+        public static bool TryWriteUInt64BigEndian(Span<byte> destination, ulong value);
+        public static bool TryWriteUInt64LittleEndian(Span<byte> destination, ulong value);
+        public static void WriteInt16BigEndian(Span<byte> destination, short value);
+        public static void WriteInt16LittleEndian(Span<byte> destination, short value);
+        public static void WriteInt32BigEndian(Span<byte> destination, int value);
+        public static void WriteInt32LittleEndian(Span<byte> destination, int value);
+        public static void WriteInt64BigEndian(Span<byte> destination, long value);
+        public static void WriteInt64LittleEndian(Span<byte> destination, long value);
+        public static void WriteUInt16BigEndian(Span<byte> destination, ushort value);
+        public static void WriteUInt16LittleEndian(Span<byte> destination, ushort value);
+        public static void WriteUInt32BigEndian(Span<byte> destination, uint value);
+        public static void WriteUInt32LittleEndian(Span<byte> destination, uint value);
+        public static void WriteUInt64BigEndian(Span<byte> destination, ulong value);
+        public static void WriteUInt64LittleEndian(Span<byte> destination, ulong value);
+    }
+}
```

