# System.Net.Http

``` diff
 namespace System.Net.Http {
     public class HttpClient : HttpMessageInvoker {
+        public Task<HttpResponseMessage> PatchAsync(string requestUri, HttpContent content);
+        public Task<HttpResponseMessage> PatchAsync(string requestUri, HttpContent content, CancellationToken cancellationToken);
+        public Task<HttpResponseMessage> PatchAsync(Uri requestUri, HttpContent content);
+        public Task<HttpResponseMessage> PatchAsync(Uri requestUri, HttpContent content, CancellationToken cancellationToken);
     }
     public class HttpMethod : IEquatable<HttpMethod> {
+        public static HttpMethod Patch { get; }
     }
+    public sealed class ReadOnlyMemoryContent : HttpContent {
+        public ReadOnlyMemoryContent(ReadOnlyMemory<byte> content);
+        protected override Task SerializeToStreamAsync(Stream stream, TransportContext context);
+        protected internal override bool TryComputeLength(out long length);
+    }
+    public sealed class SocketsHttpHandler : HttpMessageHandler {
+        public SocketsHttpHandler();
+        public bool AllowAutoRedirect { get; set; }
+        public DecompressionMethods AutomaticDecompression { get; set; }
+        public TimeSpan ConnectTimeout { get; set; }
+        public CookieContainer CookieContainer { get; set; }
+        public ICredentials Credentials { get; set; }
+        public ICredentials DefaultProxyCredentials { get; set; }
+        public TimeSpan Expect100ContinueTimeout { get; set; }
+        public int MaxAutomaticRedirections { get; set; }
+        public int MaxConnectionsPerServer { get; set; }
+        public int MaxResponseDrainSize { get; set; }
+        public int MaxResponseHeadersLength { get; set; }
+        public TimeSpan PooledConnectionIdleTimeout { get; set; }
+        public TimeSpan PooledConnectionLifetime { get; set; }
+        public bool PreAuthenticate { get; set; }
+        public IDictionary<string, object> Properties { get; }
+        public IWebProxy Proxy { get; set; }
+        public TimeSpan ResponseDrainTimeout { get; set; }
+        public SslClientAuthenticationOptions SslOptions { get; set; }
+        public bool UseCookies { get; set; }
+        public bool UseProxy { get; set; }
+        protected override void Dispose(bool disposing);
+        protected internal override Task<HttpResponseMessage> SendAsync(HttpRequestMessage request, CancellationToken cancellationToken);
+    }
 }
```

