# System.Net.WebSockets

``` diff
 namespace System.Net.WebSockets {
     public sealed class ClientWebSocketOptions {
+        public RemoteCertificateValidationCallback RemoteCertificateValidationCallback { get; set; }
     }
+    public readonly struct ValueWebSocketReceiveResult {
+        public ValueWebSocketReceiveResult(int count, WebSocketMessageType messageType, bool endOfMessage);
+        public int Count { get; }
+        public bool EndOfMessage { get; }
+        public WebSocketMessageType MessageType { get; }
+    }
     public abstract class WebSocket : IDisposable {
+        public static WebSocket CreateFromStream(Stream stream, bool isServer, string subProtocol, TimeSpan keepAliveInterval);
+        public virtual ValueTask<ValueWebSocketReceiveResult> ReceiveAsync(Memory<byte> buffer, CancellationToken cancellationToken);
+        public virtual ValueTask SendAsync(ReadOnlyMemory<byte> buffer, WebSocketMessageType messageType, bool endOfMessage, CancellationToken cancellationToken);
     }
 }
```

