# System.Reflection.PortableExecutable

``` diff
 namespace System.Reflection.PortableExecutable {
-    public struct CodeViewDebugDirectoryData
+    public readonly struct CodeViewDebugDirectoryData
     public sealed class DebugDirectoryBuilder {
+        public void AddEntry(DebugDirectoryEntryType type, uint version, uint stamp);
+        public void AddEntry<TData>(DebugDirectoryEntryType type, uint version, uint stamp, TData data, Action<BlobBuilder, TData> dataSerializer);
+        public void AddPdbChecksumEntry(string algorithmName, ImmutableArray<byte> checksum);
     }
-    public struct DebugDirectoryEntry
+    public readonly struct DebugDirectoryEntry
     public enum DebugDirectoryEntryType {
+        PdbChecksum = 19,
     }
-    public struct DirectoryEntry
+    public readonly struct DirectoryEntry
     public enum Machine : ushort {
+        Arm64 = (ushort)43620,
     }
+    public readonly struct PdbChecksumDebugDirectoryData {
+        public string AlgorithmName { get; }
+        public ImmutableArray<byte> Checksum { get; }
+    }
     public abstract class PEBuilder {
-        protected struct Section
+        protected readonly struct Section
     }
-    public struct PEMemoryBlock
+    public readonly struct PEMemoryBlock
     public sealed class PEReader : IDisposable {
+        public PdbChecksumDebugDirectoryData ReadPdbChecksumDebugDirectoryData(DebugDirectoryEntry entry);
     }
-    public struct SectionHeader
+    public readonly struct SectionHeader
-    public struct SectionLocation
+    public readonly struct SectionLocation
 }
```

