# .NET Core 2.2.6 Update - July 09, 2019

.NET Core 2.2.6 is available for [download](2.2.6-download.md) and usage in your environment. This release includes .NET Core 2.2.6, ASP.NET Core 2.2.6 and updates to the .NET Core SDK.

The July Update for .NET Core 2.1 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download. Otherwise, the best version to download is [2.2.401](2.2.401-sdk-download.md).

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Any supported | Command line and/or Visual Studio Code | [2.2.401](2.2.401-sdk-download.md) |
| Windows | Visual Studio 2019 version 16.2 | [2.2.401](2.2.401-sdk-download.md) |
| Windows | Visual Studio 2019 version 16.1 | [2.2.301](2.2.301-sdk-download.md) |
| Windows | Visual Studio 2019 version 16.0 | [2.2.205](2.2.205-sdk-download.md) |
| Windows | Visual Studio 2017 | [2.2.108](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-226)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)
* [Known Issues](../2.2-known-issues.md)

We've created an issue at [dotnet/core #3007](https://github.com/dotnet/core/issues/3007) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz]] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM32][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | [CLI][cli221xx-symbols.zip] \| [SDK][dotnet-sdk-symbols.zip]  | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

The images are expected to be available later today.

### Azure AppServices

* .NET Core 2.2.6 is being deployed to Azure App Services and the deployment is expected to complete later in July 2019.

## .NET Core Lifecycle News

.NET Core 1.0 and 1.1 reached end of support lifecycle on June 27, 2019 and will no longer receive updates going forward. See [.NET Core Support Policy](https://dotnet.microsoft.com/platform/support/policy/dotnet-core) to learn more about the .NET Core support lifecycle.

Debian 10 GA finally released and we expect .NET Core availability on it later this month.

See [.NET Core Supported OS Lifecycle Policy](../../../os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 2.2.6

.NET Core 2.2.6 release carries both security and non-security fixes.

* [CVE-2019-1075: ASP.NET Core Spoofing Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2019-1075)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core 2.1 and 2.2. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a spoofing vulnerability that exists in ASP.NET Core that could lead to an open redirect. An attacker who successfully exploited the vulnerability could redirect a targeted user to a malicious website.

To exploit the vulnerability, an attacker could send a link that has a specially crafted URL and convince the user to click the link.

The update addresses the vulnerability by correcting how ASP.NET Core parses URLs.

**Affected Package and Binary updates**

Package name | Vulnerable versions | Secure versions
------------ | ------------------- | -------------------------
Microsoft.AspNetCore.Server.HttpSys | 2.1.0, 2.1.1<br/>2.2.0 | 2.1.12<br/>2.2.6
Microsoft.AspNetCore.Server.IIS  | 2.2.0, 2.2.1, 2.2.2 | 2.2.6
Microsoft.AspNetCore.All | 2.1.0 - 2.1.11<br/>2.2.0 - 2.2.5 | 2.1.12<br/>2.2.6
Microsoft.AspNetCore.App | 2.1.0 - 2.1.11<br/>2.2.0 - 2.2.5 | 2.1.12<br/>2.2.6

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A2.2.6+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A2.2.6+label%3Aservicing-approved)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:2.2.6+label:servicing-approved)
* [ASP.NETCore](https://github.com/search?q=user:aspnet+is:pr+label:Servicing-approved+milestone:2.2.6)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
dotnet-ef|2.2.6
Microsoft.AspNetCore.All|2.2.6
Microsoft.AspNetCore.App|2.2.6
Microsoft.AspNetCore.Mvc.Api.Analyzers|2.2.6
Microsoft.AspNetCore.Server.HttpSys|2.2.6
Microsoft.AspNetCore.Server.IIS|2.2.6
Microsoft.Data.Sqlite|2.2.6
Microsoft.Data.Sqlite.Core|2.2.6
Microsoft.DotNet.Web.Client.ItemTemplates|2.2.6
Microsoft.DotNet.Web.ItemTemplates|2.2.6
Microsoft.DotNet.Web.ProjectTemplates.2.2|2.2.6
Microsoft.DotNet.Web.Spa.ProjectTemplates|2.2.6
Microsoft.EntityFrameworkCore|2.2.6
Microsoft.EntityFrameworkCore.Abstractions|2.2.6
Microsoft.EntityFrameworkCore.Analyzers|2.2.6
Microsoft.EntityFrameworkCore.Design|2.2.6
Microsoft.EntityFrameworkCore.InMemory|2.2.6
Microsoft.EntityFrameworkCore.Proxies|2.2.6
Microsoft.EntityFrameworkCore.Relational|2.2.6
Microsoft.EntityFrameworkCore.Relational.Specification.Tests|2.2.6
Microsoft.EntityFrameworkCore.Specification.Tests|2.2.6
Microsoft.EntityFrameworkCore.Sqlite|2.2.6
Microsoft.EntityFrameworkCore.Sqlite.Core|2.2.6
Microsoft.EntityFrameworkCore.Sqlite.NetTopologySuite|2.2.6
Microsoft.EntityFrameworkCore.SqlServer|2.2.6
Microsoft.EntityFrameworkCore.SqlServer.NetTopologySuite|2.2.6
Microsoft.EntityFrameworkCore.Tools|2.2.6
Microsoft.NETCore.Platforms|2.2.2
Microsoft.NETCore.App|2.2.6
Microsoft.NETCore.DotNetAppHost|2.2.6
Microsoft.NETCore.DotNetHost|2.2.6
Microsoft.NETCore.DotNetHostPolicy|2.2.6
Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.linux-arm.Microsoft.NETCore.App|2.2.6
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.linux-arm.Microsoft.NETCore.DotNetHost|2.2.6
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.linux-arm64.Microsoft.NETCore.App|2.2.6
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.linux-arm64.Microsoft.NETCore.DotNetHost|2.2.6
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.linux-musl-x64.Microsoft.NETCore.App|2.2.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost|2.2.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.linux-x64.Microsoft.NETCore.App|2.2.6
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.linux-x64.Microsoft.NETCore.DotNetHost|2.2.6
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.osx-x64.Microsoft.NETCore.App|2.2.6
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.osx-x64.Microsoft.NETCore.DotNetHost|2.2.6
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.rhel.6-x64.Microsoft.NETCore.App|2.2.6
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost|2.2.6
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.win-arm.Microsoft.NETCore.App|2.2.6
runtime.win-arm.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.win-arm.Microsoft.NETCore.DotNetHost|2.2.6
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.win-arm64.Microsoft.NETCore.App|2.2.6
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.win-arm64.Microsoft.NETCore.DotNetHost|2.2.6
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.win-x64.Microsoft.NETCore.App|2.2.6
runtime.win-x64.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.win-x64.Microsoft.NETCore.DotNetHost|2.2.6
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver|2.2.6
runtime.win-x86.Microsoft.NETCore.App|2.2.6
runtime.win-x86.Microsoft.NETCore.DotNetAppHost|2.2.6
runtime.win-x86.Microsoft.NETCore.DotNetHost|2.2.6
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy|2.2.6
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver|2.2.6

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.2.6.md

[//]: # ( Runtime 2.2.6)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/428aaa32-f66c-4847-b845-aa21f90504e4/1cf033db866414997140c2672bd75069/dotnet-runtime-2.2.6-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5e04830-50fc-435c-8bb5-fcd4629da944/8aa7cce5c3fcb6a7db180b923d3574ef/dotnet-runtime-2.2.6-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a6b8ba2c-30f2-4bb8-80ed-3f12ac623c41/2455fd6f2369d9a7396bb363482e9047/dotnet-runtime-2.2.6-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9f21e352-9d2c-4e3b-af45-915da89158db/0e8a7ea83cc08d4bcf417a927a36ed6f/dotnet-runtime-2.2.6-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7fd8704c-560f-47dc-8fe0-b777e5e743e7/d7a4476f50828bf4095455b49c02cc01/dotnet-runtime-2.2.6-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9c986070-0a73-4414-9067-61181fc0895a/7320179081b9d38d9acaae68a22c51a2/dotnet-runtime-2.2.6-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26800e2a-e889-4cef-a48e-5e9cf98fcd6a/b3103fe551ed2d81a56e4fe057d1a230/dotnet-runtime-2.2.6-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/fcb51bad-4ce4-4bec-bd82-845d404f2740/7ff61be20c8038a966a62b8ce76b06d4/dotnet-runtime-2.2.6-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e65be1d4-dbe3-460c-8517-3fafb26b3dc4/e7760a9dbb9135e3b0b0150f36ef0f05/dotnet-runtime-2.2.6-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/215c9079-af62-4265-aea5-1ee400b475ae/0c718d5c8fff0926c9eeec76221de22c/dotnet-runtime-2.2.6-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f9b622df-fc7d-4ec6-8996-b03ad7553c93/910152992719bfee5011c722ae82c680/dotnet-runtime-2.2.6-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/69872dbc-3e5d-42e9-bb1a-ae72c98c8392/8c6fa5f8a539ff93009ea81533c1d69b/dotnet-runtime-2.2.6-win-x86.zip

[//]: # ( ASP 2.2.6)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/13798f38-c14e-4944-83c9-4f5b7c535f4d/1e1c3414f3ad791098d1f654640f9bcf/aspnetcore-runtime-2.2.6-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c3257647-9887-4822-8a18-0debbeabd3b2/5cd0346e78464231883604e544cee8dd/aspnetcore-runtime-2.2.6-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d59077f-07f3-4997-b514-d88bce8cdcbf/3729ac370c4b96720829e098bee7ee5e/aspnetcore-runtime-2.2.6-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/65bfd3c1-8321-4496-97d7-cad0743e2aea/7a23c05f5842df826017e4c8d3482d47/aspnetcore-runtime-2.2.6-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/8ded9840-cde7-44ed-aa96-76135d7d7945/7bc757c65f531dc997379b7dd9066c8e/aspnetcore-runtime-2.2.6-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/a021d9b2-8585-473c-a8d1-011717383ad7/819dbf76040767ed1a49d6c7c5681b8a/aspnetcore-runtime-2.2.6-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/add4620e-7d1f-4e04-bff2-361fa1e19347/20e8bceb10fe70eb8a5255b1bed9d80d/aspnetcore-runtime-2.2.6-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/f67e7c14-7be8-48be-a58f-6fcbb1e40e8f/5ef54f876d48a645b1015e76b97cf75b/aspnetcore-runtime-2.2.6-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/396c5a1d-352a-42b5-8819-8939565982a5/d71358582d46baafb6abc1b57e350632/aspnetcore-runtime-2.2.6-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/a9bb6d52-5f3f-4f95-90c2-084c499e4e33/eba3019b555bb9327079a0b1142cc5b2/dotnet-hosting-2.2.6-win.exe

[//]: # ( SDK 2.2.108 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3067c95f-31bf-48d8-9a2c-9b2243bda54b/e3a75b032df2a879fab55a405f0d34fa/dotnet-sdk-2.2.108-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e796706f-b3bd-4bc6-b9c1-97ff07225a00/e57b91abdc194d7297c3b9f814fb1a89/dotnet-sdk-2.2.108-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/517727be-2d06-4cf7-a4b9-b7e27616d101/89f9dc6b94b52de917ee0d7c3b267295/dotnet-sdk-2.2.108-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f7337a51-c66d-41e6-b901-6e13faabd1da/8b0b3cce21d3910176a9123a35dd59bb/dotnet-sdk-2.2.108-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7356d53f-d948-4a79-b279-5d8570a78d87/3a0d093af758b624d7af9ae896c3c6e1/dotnet-sdk-2.2.108-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9dcec0aa-9838-4fb9-9345-4b9facb6dba8/36e6bf4a80b772102f76ce8884632052/dotnet-sdk-2.2.108-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b695e443-9289-4eea-ae29-00c08b05eeeb/12467d1530b3c2db11291227f15eb3f4/dotnet-sdk-2.2.108-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/6a4e592f-306f-42a0-9b92-68fb269419e9/619760bca7fc672aaac7d08074227530/dotnet-sdk-2.2.108-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/5c8fa4d8-75d2-4b25-9bb8-3b443490a8b4/41db362f54a9de23309dd8d0fd22551a/dotnet-sdk-2.2.108-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8fe8f0c0-b642-449d-b30f-f326e8fa27c7/defdf1d5c239f4041be7839de36539ff/dotnet-sdk-2.2.108-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0c8323b2-e0e1-4e9a-aa36-712e587d7b30/93d8ebb5fc317ee5ca44a598c2396d81/dotnet-sdk-2.2.108-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d08823b4-7e36-4a6b-b59f-103a979256c5/3d3351b8fa284c2c9744b6db75449796/dotnet-sdk-2.2.108-win-x86.zip

[//]: # ( Symbols )
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/f9fccf37-ce4b-414c-a4cd-11ecc8610335/e41ec68f6402d011dc6ae246736537b7/aspnet-2.2.6-symbols.zip
[cli221xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0bd795f2-f80b-4720-a696-6362647557bb/96cefd20ffd9ccd334987d6e8cd0b802/cli221xx-2.2.6-symbols.zip
[cli222xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/975d33ef-a61a-4ca2-8e86-b0e2e4426e7e/998d6fa933b991fb59a716388b7b33c0/cli222xx-2.2.6-symbols.zip
[cli223xx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/127909c4-cfae-4927-9f6f-a5e276a8c2e4/fc7d215a493d14c517f1e675064933b9/cli223xx-2.2.6-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/df2e74d6-c3d6-4146-b92c-07b017db7c47/d85c2c17949a80c38166f199451b4d1e/core-setup-2.2.6-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ac44b040-59a7-4c31-b1f3-d307666533c0/928e45c40fc96d65d6b0208add08919a/coreclr-2.2.6-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/a11480e5-d099-4351-91ca-f8fd50f1f5df/bfc5bd03d27d857d98846c31dc6625d4/corefx-2.2.6-symbols.zip
[dotnet-sdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d64002d7-fcc2-4d47-a903-28ab7904dfec/c7e49df6e74debd1c386ef226239dfdc/dotnet-sdk-2.2.6-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.6-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.301-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-july-2019/

