# .NET Core 2.2.8 Update - November 19, 2019

[.NET Core 2.2.8](https://dotnet.microsoft.com/download/dotnet/2.2) is available for download and usage in your environment. This release includes .NET Core 2.2.8, ASP.NET Core 2.2.8 and updates to the .NET Core SDK.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-228)
* [Known Issues](../2.2-known-issues.md)
* [Visual Studio Compatibility](#visual-studio-compatibility)

We've created an issue at [dotnet/core #3848](https://github.com/dotnet/core/issues/3848) for your questions and comments.


## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |

1. Includes the .NET Core, ASP.NET Core Runtimes and the SDK compatible with Visual Studio 2017 (2.2.109).
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.

### Visual Studio Compatibility

The November Update for .NET Core 2.2 includes multiple SDK builds. If you are a Visual Studio 2019, Visual Studio 2017 or Visual Studio for Mac user, there are MSBuild version requirements that are satisfied by specific, matching .NET Core SDK versions. See the table below to select the correct download.

| OS | Development Environment | .NET Core SDK |
| :-- | :-- | :--: |
| Windows | Visual Studio 2019 version 16.0 | [2.2.207](2.2.207-download.md) |
| Windows | Visual Studio 2017 | [2.2.110](#downloads) |
| MacOS | Visual Studio for Mac | [Visual Studio for Mac .NET Core Support](https://learn.microsoft.com/visualstudio/mac/net-core-support) |

### Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)

The images are expected to be available later today.

## Azure AppServices

* .NET Core 2.2.8 is being deployed to Azure App Services and the deployment is expected to complete later in December 2019.

## Changes in 2.2.8

.NET Core 2.2.8 release carries only non-security fixes.

### Fixes in this release

* [ASP.NETCore](https://github.com/search?q=is:pr+label:Servicing-approved+milestone:2.2.8)

## Packages updated in this release:

Package name | Version
:----------- | :------------------
Microsoft.AspNetCore.All                                | 2.2.8
Microsoft.AspNetCore.App                                | 2.2.8
Microsoft.AspNetCore.CookiePolicy                       | 2.2.8
Microsoft.AspNetCore.DataProtection.EntityFrameworkCore | 2.2.8
Microsoft.DotNet.Web.Client.ItemTemplates               | 2.2.8
Microsoft.DotNet.Web.ItemTemplates                      | 2.2.8
Microsoft.DotNet.Web.ProjectTemplates.2.2               | 2.2.8
Microsoft.DotNet.Web.Spa.ProjectTemplates.2.2           | 2.2.8
Microsoft.Net.Http.Headers                              | 2.2.8
Microsoft.NETCore.App                                       | 2.2.8
Microsoft.NETCore.DotNetAppHost                             | 2.2.8
Microsoft.NETCore.DotNetHost                                | 2.2.8
Microsoft.NETCore.DotNetHostPolicy                          | 2.2.8
Microsoft.NETCore.DotNetHostResolver                        | 2.2.8
Microsoft.NETCore.Platforms | 2.2.4
runtime.linux-arm.Microsoft.NETCore.App                     | 2.2.8
runtime.linux-arm.Microsoft.NETCore.DotNetAppHost           | 2.2.8
runtime.linux-arm.Microsoft.NETCore.DotNetHost              | 2.2.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostPolicy        | 2.2.8
runtime.linux-arm.Microsoft.NETCore.DotNetHostResolver      | 2.2.8
runtime.linux-arm64.Microsoft.NETCore.App                   | 2.2.8
runtime.linux-arm64.Microsoft.NETCore.DotNetAppHost         | 2.2.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHost            | 2.2.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostPolicy      | 2.2.8
runtime.linux-arm64.Microsoft.NETCore.DotNetHostResolver    | 2.2.8
runtime.linux-musl-x64.Microsoft.NETCore.App                | 2.2.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetAppHost      | 2.2.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHost         | 2.2.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostPolicy   | 2.2.8
runtime.linux-musl-x64.Microsoft.NETCore.DotNetHostResolver | 2.2.8
runtime.linux-x64.Microsoft.NETCore.App                     | 2.2.8
runtime.linux-x64.Microsoft.NETCore.DotNetAppHost           | 2.2.8
runtime.linux-x64.Microsoft.NETCore.DotNetHost              | 2.2.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostPolicy        | 2.2.8
runtime.linux-x64.Microsoft.NETCore.DotNetHostResolver      | 2.2.8
runtime.osx-x64.Microsoft.NETCore.App                       | 2.2.8
runtime.osx-x64.Microsoft.NETCore.DotNetAppHost             | 2.2.8
runtime.osx-x64.Microsoft.NETCore.DotNetHost                | 2.2.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostPolicy          | 2.2.8
runtime.osx-x64.Microsoft.NETCore.DotNetHostResolver        | 2.2.8
runtime.rhel.6-x64.Microsoft.NETCore.App                    | 2.2.8
runtime.rhel.6-x64.Microsoft.NETCore.DotNetAppHost          | 2.2.8
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHost             | 2.2.8
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostPolicy       | 2.2.8
runtime.rhel.6-x64.Microsoft.NETCore.DotNetHostResolver     | 2.2.8
runtime.win-arm.Microsoft.NETCore.App                       | 2.2.8
runtime.win-arm.Microsoft.NETCore.DotNetAppHost             | 2.2.8
runtime.win-arm.Microsoft.NETCore.DotNetHost                | 2.2.8
runtime.win-arm.Microsoft.NETCore.DotNetHostPolicy          | 2.2.8
runtime.win-arm.Microsoft.NETCore.DotNetHostResolver        | 2.2.8
runtime.win-arm64.Microsoft.NETCore.App                     | 2.2.8
runtime.win-arm64.Microsoft.NETCore.DotNetAppHost           | 2.2.8
runtime.win-arm64.Microsoft.NETCore.DotNetHost              | 2.2.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostPolicy        | 2.2.8
runtime.win-arm64.Microsoft.NETCore.DotNetHostResolver      | 2.2.8
runtime.win-x64.Microsoft.NETCore.App                       | 2.2.8
runtime.win-x64.Microsoft.NETCore.DotNetAppHost             | 2.2.8
runtime.win-x64.Microsoft.NETCore.DotNetHost                | 2.2.8
runtime.win-x64.Microsoft.NETCore.DotNetHostPolicy          | 2.2.8
runtime.win-x64.Microsoft.NETCore.DotNetHostResolver        | 2.2.8
runtime.win-x86.Microsoft.NETCore.App                       | 2.2.8
runtime.win-x86.Microsoft.NETCore.DotNetAppHost             | 2.2.8
runtime.win-x86.Microsoft.NETCore.DotNetHost                | 2.2.8
runtime.win-x86.Microsoft.NETCore.DotNetHostPolicy          | 2.2.8
runtime.win-x86.Microsoft.NETCore.DotNetHostResolver        | 2.2.8


[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 2.2.8.md


[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.8-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/2.2.8-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-November-2019/



[//]: # ( Runtime 2.2.8)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/97595553-470b-45bc-842d-aff8da46d4c4/46ee25ac85e4844df0e7f0fb9229755c/dotnet-runtime-2.2.8-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8595cc08-1588-4e28-b765-1201b447c99b/342cf07ff5e3adb396d17da2de0d359b/dotnet-runtime-2.2.8-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f5e25e07-9934-4323-9f8b-164e2a829063/d95bd8e5f1dd52168ebf4fb9594507b1/dotnet-runtime-2.2.8-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3fbca771-e7d3-45bf-8e77-cfc1c5c41810/e118d44f5a6df21714abd8316e2e042b/dotnet-runtime-2.2.8-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fcec560f-0ae9-4d60-8528-13a11150805a/97c10e386a0cb1a7c2312fcf7bf87823/dotnet-runtime-2.2.8-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bbd4e493-6eed-45e8-90ed-7be0f1270c7a/2d19adb63887d3b02301361117bbe4f5/dotnet-runtime-2.2.8-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fcefad8a-38da-4f06-8039-8b6053cd5d84/4548d460aac1744ad6ddd253bbb4422d/dotnet-runtime-2.2.8-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/584be079-dde5-465d-9f9b-04183458dd07/a666047a3ae292cb97d74e466320e600/dotnet-runtime-2.2.8-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4e14a32d-cf57-42ce-964f-fa40c7d11dde/95cf2d91312fc495bc25ad9137d42698/dotnet-runtime-2.2.8-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/79365951-b51b-487e-a03c-6ffeb3a5f3ad/ce9eb59ba8a76621d5e76614b0c9e97d/dotnet-runtime-2.2.8-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/930685bc-ac92-4149-b4f0-b0b26d480418/c03bbed24f87e66281b5ff99ceecbb0b/dotnet-runtime-2.2.8-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/33751b42-f854-4d55-b2ff-3f0d09a88cf7/0c268c32f7730e90bd0a370be6699bf6/dotnet-runtime-2.2.8-win-x86.zip

[//]: # ( WindowsDesktop 2.2.8)

[//]: # ( ASP 2.2.8)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/9fcb0171-11d7-40e6-a2e8-2357813bf6bd/becdd52523d5a6782ded8febd2c487a0/aspnetcore-runtime-2.2.8-linux-arm.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/981063ac-98de-4622-9da7-c9df5a2547b5/ebc5edcac0759ad87f478c92f36a9a0c/aspnetcore-runtime-2.2.8-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e716faa4-345c-45a7-bd1f-860cdf422b75/fa8e57167f3bd4bf20b8b60992cf184f/aspnetcore-runtime-2.2.8-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e73aa371-90fd-488c-805a-649a324ea853/611a4a5bd4da4a950387eea27e0b588a/aspnetcore-runtime-2.2.8-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/344af0cd-5fd8-427b-a438-b94d1973fdcc/54291ccaa6049a63a811bb52d0eb94e6/aspnetcore-runtime-2.2.8-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/068d05e8-a0cf-4584-9422-b77f34f1e98e/de70e92721a05c6148619993cbf1376b/aspnetcore-runtime-2.2.8-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/acf18dce-9e6a-4a39-a1c7-e503c09e4086/f2c6e01ef9bb44c4beb905d82bb7ebac/aspnetcore-runtime-2.2.8-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/53eefcbe-83a9-42ce-b529-9ef7672c5508/b3e9c4afc183b447044703dbc8edf71d/aspnetcore-runtime-2.2.8-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/295249c5-35e1-4688-a9f4-9096989d70c1/c6cd5d342e754d2cff6f61645c4e84ae/aspnetcore-runtime-2.2.8-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/ba001109-03c6-45ef-832c-c4dbfdb36e00/e3413f9e47e13f1e4b1b9cf2998bc613/dotnet-hosting-2.2.8-win.exe

[//]: # ( SDK 2.2.110 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8cbe9c20-2e88-43dc-8d9a-27da95e5a1e7/d580d095fc8d236d7db15336668d9173/dotnet-sdk-2.2.110-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/06413d6a-e12b-41fc-91cf-d88a6f97a5c1/5a32f67fe5ad0457309cf8e0fa52f2b8/dotnet-sdk-2.2.110-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/17b53621-992d-4805-9feb-93cc34662c5f/c83ef9c56200b4d333b18c48f9054437/dotnet-sdk-2.2.110-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/42f39f2f-3f24-4340-8c57-0a3133620c21/0a353696275b00cbddc9f60069867cfc/dotnet-sdk-2.2.110-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/7db9e4c2-7118-4c13-8689-4193e4c91aed/a783f5cad3c017097bc123b478eee2a3/dotnet-sdk-2.2.110-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f2d70b94-7b76-49c7-917f-758e71135305/24dc05dad28e067500762516d4a8d514/dotnet-sdk-2.2.110-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7a67baf-9c6b-4fdf-8b58-c3e554c6802f/87fbc4a569b2c5ddca8c4933346ff56d/dotnet-sdk-2.2.110-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/c466f96a-d612-4f1c-9b4f-5bb3f658d5a7/38f300421101aa06bb58de9f8651de7e/dotnet-sdk-2.2.110-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/78969d24-673f-4515-9544-1dd5bcda5411/beda84891a9a085cecd9bff855fdd082/dotnet-sdk-2.2.110-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/246c4b65-5a51-4294-8ce3-181aefd60e94/5169a50a00d4c56abe20ef1c1325ceff/dotnet-sdk-2.2.110-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/1af1c7ed-74dc-4772-8e8c-146e54a47b2f/162c9a7e45ea5080a3f4085d8684b7b9/dotnet-sdk-2.2.110-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/513e3f1e-2ff8-48d9-bc2a-0e60b19eca72/4a780ab4d4fe4ce5e7777d25d973e1b7/dotnet-sdk-2.2.110-win-x86.zip

[//]: # ( Symbols )
