# .NET Core 3.0.0 - September 23, 2019

.NET Core 3.0.0 is available for download and usage in your environment. This release includes .NET Core 3.0.0 and .NET Core SDK 3.0.100.

**Visual Studio compatibility:** .NET Core 3.0.0 requires Visual Studio 2019 16.3 GA to take full advantage of all its features. .NET Core 3.0.0 will not work properly in earlier versions of Visual Studio.

* [Changes in this release](#notable-changes-in-300)
* [Known issues](../3.0-known-issues.md)
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.0)

The .NET Core SDK 3.0.100 includes .NET Core 3.0 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.0.100, the following command will show that you're running version `3.0.100` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #3430](https://github.com/dotnet/core/issues/3430) for your questions and comments.

## Blog Roundup

* [.NET Core 3.0 GA][dotnet-blog]
* [ASP.NET Core][aspnet-blog]
* [EF Core][ef-blog]

We added multiple improvements and additions to .NET Core 3.0 with the help from an incredible array of folks. A big thank you goes out to [everybody who contributed](3.0.0-contrib.md) in this effort.

## Release metadata (release.json)

The releases.json files (e.g. [3.0 releases.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/3.0/releases.json)) are comprehensive metadata files which capture the details of each .NET Core release. These files, along with the top level [releases-index.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/releases-index.json), are becoming increasingly important .NET Core release assets which you can use to discover details about all .NET Core releases.

These files, one for each major.minor channel (e.g. 2.1, 3.0), are already relied upon by many in the community to detect when updates for .NET Core are available and discover security update information.

### [releases-index.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/releases-index.json)

The index provides summary information concerning the latest release in each version channel and related `releases.json` endpoints for detailed data.

```JSON
{
  "releases-index": [
  {
    "channel-version": "3.0",
    "latest-release": "3.0.0",
    "latest-release-date": "2019-09-23",
    "security": false,
    "latest-runtime": "3.0.0",
    "latest-sdk": "3.0.100",
    "product": ".NET Core",
    "support-phase": "current",
    "eol-date": null,
    "releases.json": "https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/3.0/releases.json"
  },
  ...
```

### [releases.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/2.1/releases.json)

In addition to the summary information described in `release-index.json`, the `release.json` files provide further details for each release including file download endpoints and file hashes for validation.

```JSON
{
    "release-date": "2019-07-09",
    "release-version": "2.1.12",
    "security": true,
    "cve-list": [
    {
        "cve-id": " CVE-2019-1075",
        "cve-url": "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-1075"
    }
    ],
    "release-notes": "https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.12/2.1.12.md",
    "runtime": {
      "version": "2.1.12",
      "version-display": "2.1.12",
      "vs-version": "15.9.13, 16.1.3, 16.2.0",
      "files": [
          {
          "name": "dotnet-runtime-linux-arm.tar.gz",
          "rid": "linux-arm",
          "url": "https://download.visualstudio.microsoft.com/download/pr/f759670e-1f8d-4f1a-8eb7-58b95f94c68c/69eca04ca138dc6c3caa160bd1b891d1/dotnet-runtime-2.1.12-linux-arm.tar.gz",
          "hash": "DA041CB2AFA557E70D00039FDDACAFE48DF28B8DA9C06F790CC841ECABA496F00880EF3349731860835007FA12F0AEF7D50D5EB200297AF5E37F4503C62ACECA"
          },
    ...
```

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 3.0.0

Here are some of the additions and updates we're excited to bring in 3.0 GA. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* CoreCLR: [bugs][coreclr_bugs] | [features][coreclr_features]
* CoreFX: [bugs][corefx_bugs] | [features][corefx_features]
* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]
* [API Changes in 3.0](../api-diff/README.md)

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.0.0.md

[//]: # ( Runtime 3.0.0)
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/bf608208-38aa-4a40-9b71-ae3b251e110a/bc1cecb14f75cc83dcd4bbc3309f7086/dotnet-hosting-3.0.0-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c5e013b-fa57-44dc-85bf-746885181278/58647e532fcc3a45209c13cdfbf30c74/dotnet-runtime-3.0.0-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/707fd000-c376-40de-9862-cabc46a344ec/82e0a3c816247bad4563c3e74655f7cf/dotnet-runtime-3.0.0-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/af1de242-ec6f-4ecd-8ed3-0a0e9a526e28/c2efbe5b8f24603e1f1160b1a48912a2/dotnet-runtime-3.0.0-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a5ff9cbb-d558-49d1-9fd2-410cb1c8b095/a940644f4133b81446cb3733a620983a/dotnet-runtime-3.0.0-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/1b09851c-1c1a-4aeb-a94a-7065db8741c0/b22a0b5501191fe1a263913d8ed11b2e/dotnet-runtime-3.0.0-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/68123d89-73c0-40b0-ba9b-93667c25663b/001f66f8ec4666421acc16f74209aa99/dotnet-runtime-3.0.0-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d78bd3a0-3f8b-4bae-abc4-cd1537d7ed75/3fe2e28ee47a80e44838a4e22d07284b/dotnet-runtime-3.0.0-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a29804d8-da5a-4351-b93f-216b19ae462c/77563df12d57f63bd812f9894b0a2091/dotnet-runtime-3.0.0-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/b3b81103-619a-48d8-ac1b-e03bbe153b7c/566b0f50872164abd1478a5b3ec38ffa/dotnet-runtime-3.0.0-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/f15b7c04-2900-4a14-9c01-ccd66a4323cc/17a6bbd44f0d0a85d219dd9e166a89ca/dotnet-runtime-3.0.0-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ffc76eb1-6293-46e9-8d31-ad804995f870/ccf2eeafb0bdf336a092bfdd52a0dfca/dotnet-runtime-3.0.0-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/0205db4f-5819-4ecb-be78-3dfd23fe0f97/ec5633cbed223ea6a4c3b2ce0d0c7163/dotnet-runtime-3.0.0-win-x86.zip
[dotnet-targeting-pack-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/239d7cd9-643b-43c9-9a60-8274340d8580/0631fc7e063b168ee89a2b53af64f7d8/dotnet-targeting-pack-3.0.0-osx-x64.pkg
[netstandard-targeting-pack-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5d558117-f5e7-449b-b7ff-c7f1075397ea/1414784b285bd658ded76910f3e50b52/netstandard-targeting-pack-2.1.0-osx-x64.pkg
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/fe9d105b-5d40-4f12-b238-6b6e1af9f812/341fc13950347d95fef8522cb3d77009/windowsdesktop-runtime-3.0.0-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/03f6f2e1-bc0f-4185-b5c2-8399d5b3aac4/96f0664754609069159b7acd19772c77/windowsdesktop-runtime-3.0.0-win-x86.exe

[//]: # ( ASP 3.0.0)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/e9d4b012-a877-443c-8344-72ef910c86dd/b5e729b532d7b3b5488c97764bd0fb8e/aspnetcore-runtime-3.0.0-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5cbf9f66-7945-43e2-9b7c-351f900e9893/2fcd48f3d4db99283ebdb46daf9bacec/aspnetcore-runtime-3.0.0-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/405f67c3-612c-4976-862a-9ce47e84c501/2658cc4eeb24a49f6670fe658b62268b/aspnetcore-runtime-3.0.0-linux-musl-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2dd89dc5-add5-4582-9a72-7c55f447a069/ef2d3aa1e91e837a8400d5e69fc6952f/aspnetcore-runtime-3.0.0-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b0c44e05-b7a1-4221-94ec-a0c0d3a11eed/afc61567dd6db8f097e244871889458c/aspnetcore-runtime-3.0.0-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3ab4125a-c616-4aec-8fdb-763039e99f1c/08a6d2546fbbd4b1b959e6a3da3b9eb4/aspnetcore-runtime-3.0.0-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/a7d46559-0da7-4850-9c7f-59070923600e/4cf0abb8decc6ccf0f4a5e7195136da9/aspnetcore-runtime-3.0.0-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/173b8a01-e65b-4880-af6e-12e45a865c69/f2529ad22ce8eeb0f28fd48dead5459a/aspnetcore-runtime-3.0.0-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/02a17191-e966-4b89-9312-2cbad04fa8bd/0bd4537f7683f2c4d3986d30bfbb4344/aspnetcore-runtime-3.0.0-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cf69fd0f-6790-47bb-9243-e066387ee690/7352473dfba8771278e95f60b9193401/aspnetcore-runtime-3.0.0-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/2723329d-d208-4ffa-990e-bbdd00ec56d7/0be01dcf5d4be996218da524a046ca31/aspnetcore-runtime-3.0.0-win-x86.zip
[aspnetcore-targeting-pack.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b59cd26f-fc90-4984-8363-b0b218486795/f6d9be56b63efcdaf2cf231a47ca0599/aspnetcore-targeting-pack-3.0.0.tar.gz
[aspnetcore-targeting-pack.zip]: https://download.visualstudio.microsoft.com/download/pr/c603586c-855f-49b4-b95f-54ac9f31bac0/d6c8a96d143fe7738b9ba6d927e70d6b/aspnetcore-targeting-pack-3.0.0.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/bf608208-38aa-4a40-9b71-ae3b251e110a/bc1cecb14f75cc83dcd4bbc3309f7086/dotnet-hosting-3.0.0-win.exe

[//]: # ( SDK 3.0.100 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ddb8193-f88c-4c4b-82a3-39fcced27e91/b8e0b9bf4cf77dff09ff86cc1a73960b/dotnet-sdk-3.0.100-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cbc83a0e-895c-4959-99d9-21cd11596e64/b0e59c2ba2bd3ef0f592acbeae7ab27d/dotnet-sdk-3.0.100-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f9dc42c0-9b15-44e6-9d9b-ef341fdbf1a7/78b16d311f1c4366fed65e69eaece49d/dotnet-sdk-3.0.100-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/886b4a4c-30af-454b-8bec-81c72b7b4e1f/d1a0c8de9abb36d8535363ede4a15de6/dotnet-sdk-3.0.100-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/5c281f95-91c4-499d-baa2-31fec919047a/38c6964d72438ac30032bce516b655d9/dotnet-sdk-3.0.100-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b9251194-4118-41cb-ae05-6763fb002e5d/1d398b4e97069fa4968628080b617587/dotnet-sdk-3.0.100-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5d6a0da0-2da2-4c2c-ba9c-f086566d527f/7e2b7492d4142ae6e7d7c6a561f71cc0/dotnet-sdk-3.0.100-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/96e49889-2fc3-4d67-b89b-12dc6f67da74/bad15c477c4514d2faef8ab8e1bf42fc/dotnet-sdk-3.0.100-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/53f250a1-318f-4350-8bda-3c6e49f40e76/e8cbbd98b08edd6222125268166cfc43/dotnet-sdk-3.0.100-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a24f4f34-ada1-433a-a437-5bc85fc2576a/7e886d06729949c15c96fe7e70faa8ae/dotnet-sdk-3.0.100-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/16378a9f-1291-4c34-8625-ab4dfebfb74a/096945940a346e326368c070b8ecc050/dotnet-sdk-3.0.100-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/8bcb1316-76a0-4ec9-a8b4-4a5da79dff36/32458bba334f532ceab30f2f7cbacce1/dotnet-sdk-3.0.100-win-x86.zip

[checksums]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-and-blazor-updates-in-net-core-3-0/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-ef-core-3-0-and-ef-6-3-general-availability

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0+label%3ADone+label%3Aenhancement
[coreclr_bugs]: https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A3.0+label%3Abug+
[coreclr_features]: https://github.com/dotnet/coreclr/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
[corefx_bugs]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Abug
[corefx_features]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
