# .NET Core 3.0.2 Update - January 14, 2020

[.NET Core 3.0.2](https://dotnet.microsoft.com/download/dotnet/3.0) is available for download and usage in your environment. This release includes .NET Core 3.0.2 and .NET Core SDK 3.0.102.

* [Blog Post][dotnet-blog]
* [Downloads](#downloads)
* [Changes in this release](#changes-in-302)
* [Known Issues](../3.0-known-issues.md)
* [.NET Core Lifecycle News](#net-core-lifecycle-news)

Your feedback is important and appreciated. We've created an issue at [dotnet/core #4119](https://github.com/dotnet/core/issues/4119) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           | Windows Desktop Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |:-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> | [x86][windowsdesktop-runtime-win-x86.exe] \| [x64][windowsdesktop-runtime-win-x64.exe] |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup> | - |
| Linux     |  [Snap Install][snap-install]  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - | - |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.


## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [dotnet/core/runtime](https://github.com/dotnet/dotnet-docker/blob/main/README.runtime.md)
* [dotnet/core/sdk](https://github.com/dotnet/dotnet-docker/blob/main/README.sdk.md)
* [dotnet/core/samples](https://github.com/dotnet/dotnet-docker/blob/main/README.samples.md)
* [dotnet/aspnetcore](https://github.com/dotnet/dotnet-docker/blob/main/README.aspnet.md)

The images are expected to be available later today.


## Azure AppServices

* .NET Core 3.0.2 is being deployed to Azure App Services and the deployment is expected to complete later in January 2020.

## .NET Core Lifecycle News

[.NET Core 2.2 reached end of life](https://github.com/dotnet/announcements/issues/147/) on December 23, 2019. This means .NET Core 2.2 is no longer supported and updates will no longer be provided. We recommend moving to .NET Core 3.1, our long term support (LTS) release.

.NET Core 3.0 will reach end of life on March 3, 2020 which is 3 months after the release of .NET Core 3.1. You can view the [Microsoft Support for .NET Core](../../../support.md) for more information about life-cycle of each product.

Fedora 29 has been out of support since [November 29, 2019](https://fedoraproject.org/wiki/End_of_life) and .NET Core no longer provides support for it.

Ubuntu 19.04 will be out of support on [January 23, 2020](https://lists.ubuntu.com/archives/ubuntu-announce/2020-January/thread.html).

See [.NET Core Supported OS Lifecycle Policy](../../../os-lifecycle-policy.md) to learn about Windows, macOS and Linux versions that are supported for each .NET Core release.

## Changes in 3.0.2

.NET Core 3.0.2 release carries both security and non-security fixes.


### [CVE-2020-0602: ASP.NET Core Denial of Service Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-0602)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a denial of service vulnerability exists when ASP.NET Core improperly handles web requests. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how the ASP.NET Core web application handles web requests.

**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.Http.Connections  | 1.0.0 - 1.0.4  | 1.0.15
Microsoft.AspNetCore.App  | 2.1.0 - 2.1.14 <br/> 3.0.0 <br/> 3.1.0 | 2.1.15 <br/> 3.0.1 <br/> 3.1.1
Microsoft.AspNetCore.All  | 2.1.0 - 2.1.14 | 2.0.15

### [CVE-2020-0603: ASP.NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-0603)

Microsoft is releasing this security advisory to provide information about a vulnerability in ASP.NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a remote code execution vulnerability exists in ASP.NET Core software when the software fails to handle objects in memory. An attacker who successfully exploited this vulnerability could cause a denial of service against an ASP.NET Core web application. The vulnerability can be exploited remotely, without authentication.

A remote unauthenticated attacker could exploit this vulnerability by issuing specially crafted requests to the ASP.NET Core application.

The update addresses the vulnerability by correcting how the ASP.NET Core web application handles in memory.


**Affected Package and Binary updates**

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.AspNetCore.Http.Connections  | 1.0.0 - 1.0.4 | 1.0.15
Microsoft.AspNetCore.App  | 2.1.0 - 2.1.14 <br/> 3.0.0 <br/> 3.1.0 | 2.1.15 <br/> 3.0.1 <br/> 3.1.1
Microsoft.AspNetCore.All  | 2.1.0 - 2.1.14 | 2.1.15


### [CVE-2020-0605: .NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-0605)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a remote code execution vulnerability exists in .NET software when the software fails to check the source markup of a file. An attacker who successfully exploited the vulnerability could run arbitrary code in the context of the current user.

Exploitation of the vulnerability requires that a user open a specially crafted file with an affected version of .NET Core. In an email attack scenario, an attacker could exploit the vulnerability by sending the specially crafted file to the user and convincing the user to open the file.

The security update addresses the vulnerability by correcting how .NET Core checks the source markup of a file.

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.WindowsDesktop.App  | 3.0.0 - 3.0.1 | 3.0.2
Microsoft.WindowsDesktop.App  | 3.1.0 | 3.1.1

### [CVE-2020-0606: .NET Core Remote Code Execution Vulnerability](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2020-0606)

Microsoft is releasing this security advisory to provide information about a vulnerability in .NET Core. This advisory also provides guidance on what developers can do to update their applications to remove this vulnerability.

Microsoft is aware of a remote code execution vulnerability exists in .NET software when the software fails to check the source markup of a file. An attacker who successfully exploited the vulnerability could run arbitrary code in the context of the current user.

Exploitation of the vulnerability requires that a user open a specially crafted file with an affected version of .NET Core. In an email attack scenario, an attacker could exploit the vulnerability by sending the specially crafted file to the user and convincing the user to open the file.

The security update addresses the vulnerability by correcting how .NET Core checks the source markup of a file.

Package name                      | Vulnerable versions  | Secure versions
------------                      | -------------------  | -------------------------
Microsoft.WindowsDesktop.App  | 3.0.0 - 3.0.1 | 3.0.2
Microsoft.WindowsDesktop.App  | 3.1.0 | 3.1.1

### Additional fixes in this release

* [CoreCLR](https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=milestone%3A3.0.2+label%3Aservicing-approved)
* [CoreFX](https://github.com/dotnet/corefx/issues?utf8=%E2%9C%93&q=milestone%3A3.0.2+label%3Aservicing-approved)
* [Core-Setup](https://github.com/dotnet/core-setup/issues?utf8=✓&q=milestone:3.0.2+label:servicing-approved)
* [ASP.NETCore](https://github.com/search?q=is%3Apr+label%3AServicing-approved+milestone%3A3.0.2+repo%3Adotnet%2Faspnetcore+repo%3Adotnet%2Fextensions+repo%3Adotnet%2Faspnetcore-tooling+repo%3Adotnet%2Fblazor+repo%3Adotnet%2Fefcore+repo%3Adotnet%2Fef6)

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.0.2.md


[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.2-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.2-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux
[dotnet-blog]: https://devblogs.microsoft.com/dotnet/net-core-January-2020/

[snap-install]: 3.0.2-install-instructions.md


[//]: # ( Runtime 3.0.2)
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1bbe2ca1-7568-47aa-984b-f26cccf1139b/97894dc57a6b522200cd8f78d6f2a475/dotnet-runtime-3.0.2-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8a473d88-c3da-4e9c-b284-c0fa285cbcc3/c269866b4a21f2d35cb29ee5c27107de/dotnet-runtime-3.0.2-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4436af83-3554-419b-82a9-08c83c21dcda/2df88dc422b5732c309cf4f738130469/dotnet-runtime-3.0.2-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7647815e-9c28-40a5-96ea-c6ac4ebe2020/c026b1e93a5d6750a7666d3fe36a87f5/dotnet-runtime-3.0.2-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/e6df5cd4-1712-4a7d-99c9-d5196cb3c115/4c798cefd43fa155c1ba4cc75ad481ae/dotnet-runtime-3.0.2-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/59c4901a-1824-42ef-a755-30552ac6a584/06f0f60c25554fcee6aa1d75a312e072/dotnet-runtime-3.0.2-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/3d2f623c-caee-492f-afbd-56bebaa712ad/480fe286c648b9e8b4861750fb48e3bb/dotnet-runtime-3.0.2-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/55c72264-747d-4dcf-9a87-bc784446156e/49b04ee6bbfd7bae411b83cce9b8e4fe/dotnet-runtime-3.0.2-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d283fed4-b84e-479e-acff-582d273d832c/1beb30cac838ac81c603ef262b79e671/dotnet-runtime-3.0.2-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b42cf67-453a-4ea2-a761-3263adc0c8ad/c53ccfc70e66d807b2affff6c441d660/dotnet-runtime-3.0.2-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/223110a5-6aa9-416e-88a8-f22189a7bd79/a2fdabedef7fa899ab5f851124d0dd9f/dotnet-runtime-3.0.2-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/71ccb26a-1a32-425d-9b06-9ada6225d9b8/6fce64c8d3aaf99a094837b2cbb23289/dotnet-runtime-3.0.2-win-x86.zip

[//]: # ( WindowsDesktop 3.0.2)
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6de20972-a961-4ea9-add7-1ed70c889292/5fb88f842d9d0ef361f0982bd047c42b/windowsdesktop-runtime-3.0.2-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/a9175198-d86c-4aa2-9a69-007ed7f5895b/2c7fb7db8989f10eb4c48a1ac27e0a34/windowsdesktop-runtime-3.0.2-win-x86.exe

[//]: # ( ASP 3.0.2)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/aecb9174-30f5-41d6-a128-64f0c69727c5/bf143cc4cf1db83c9f5d700ca3112e98/aspnetcore-runtime-3.0.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c419439-927d-41db-a78d-c2cb332ba340/2bc4357b9917536a6513eb45d87c5fc3/aspnetcore-runtime-3.0.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/679856ae-b474-492d-bb70-b6ee614a0aac/718cdf67f3f06e03d35631f8c4ab6f8e/aspnetcore-runtime-3.0.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60780f73-a484-43fe-a6b9-c9042e3d2281/83d8c620270147af223bbd9f9d287b9a/aspnetcore-runtime-3.0.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/817d0793-9f2b-4a5e-b527-8b37b5f0068b/0e1b2245e39655e638e3fbf6cb52f6fe/aspnetcore-runtime-3.0.2-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ca147f07-8230-4d37-abfd-035a4a73a3ba/bd1d3c53e55dce7440c9f6f3b72c1324/aspnetcore-runtime-3.0.2-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6c0ea61f-519a-42ed-b145-fbb2a3ebceca/07815e1e29eaa9f8a881a5c2de17de85/aspnetcore-runtime-3.0.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/2b7b1bb0-74cd-46e8-8288-ddf845281fa2/72b0b4b88a92f66ce26b79f599809ce5/aspnetcore-runtime-3.0.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/953c0744-a970-4155-861b-f1da92df3b1f/6147a5b4050afd161f4788c7ea30d18a/aspnetcore-runtime-3.0.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/276d2691-b444-46b6-9985-3577595977a9/68878bd6e3fe33a145d82242f1724f69/aspnetcore-runtime-3.0.2-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/7333c58c-6aa8-4dc2-9c1c-8116f18298ee/4e987f142794d8949e79344f42e253e6/dotnet-hosting-3.0.2-win.exe

[//]: # ( SDK 3.0.102 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/162513e7-32f5-4896-aecd-729573940bd9/f7f1b9528f1a77199c4124236ebfd747/dotnet-sdk-3.0.102-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ce72d357-7408-43a7-918a-daf7eba2f6b2/52fc87abf9fba272efe103e3da396b94/dotnet-sdk-3.0.102-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/1ac513ae-90f5-4c23-848a-a7a8e20a07c3/fd4f8341fe19194ef7ca976a853e03f1/dotnet-sdk-3.0.102-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2e2cbde1-f97b-4d6f-8fd9-7880aa46b025/8e5ead3dda8340867ba1e09273993351/dotnet-sdk-3.0.102-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/3234b6b7-a3da-4e02-ad2a-63d75975f1dc/5a0a2d20b24cadf3e68ba179d4598fa6/dotnet-sdk-3.0.102-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48b6421b-56c8-4c74-bdaf-1071a9081062/90dbcd03f917aa012ab16f2c314446de/dotnet-sdk-3.0.102-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/48e6bc4b-c86c-405d-94be-000212686712/462b5b0bb729f54d4e1b6bb3aadafd91/dotnet-sdk-3.0.102-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ff5803c8-3269-4059-81db-b99efab3c28c/eaaa2d91a480cf978f55df4380eb4160/dotnet-sdk-3.0.102-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/7d6389b7-eda7-4ae0-924d-4fedaa3d0fc7/7712bebba5b34149837f9b60928acbb1/dotnet-sdk-3.0.102-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/408889b5-15c7-4c34-8df5-04b95b54f0fd/5328884bfccade0bc819559ba3ea4dc0/dotnet-sdk-3.0.102-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/ac725466-79c4-44fc-8c40-1e94c69751d1/9dc355a1c3fe3613fa380a6bce492dfc/dotnet-sdk-3.0.102-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6c083c12-c4d6-46d5-8de4-1edd87f6fc08/ed6d7d4fa9ceebdb54491be25ab9c506/dotnet-sdk-3.0.102-win-x86.zip

[//]: # ( Symbols )

