# Microsoft.VisualBasic.CompilerServices

``` diff
 namespace Microsoft.VisualBasic.CompilerServices {
+    public sealed class BooleanType {
+        public static bool FromObject(object Value);
+        public static bool FromString(string Value);
+    }
+    public sealed class ByteType {
+        public static byte FromObject(object Value);
+        public static byte FromString(string Value);
+    }
+    public sealed class CharArrayType {
+        public static char[] FromObject(object Value);
+        public static char[] FromString(string Value);
+    }
+    public sealed class CharType {
+        public static char FromObject(object Value);
+        public static char FromString(string Value);
+    }
     public sealed class Conversions {
+        public static object FallbackUserDefinedConversion(object Expression, Type TargetType);
+        public static string FromCharAndCount(char Value, int Count);
+        public static string FromCharArray(char[] Value);
+        public static string FromCharArraySubset(char[] Value, int StartIndex, int Length);
         public static Decimal ToDecimal(bool Value);
         public static Decimal ToDecimal(object Value);
         public static Decimal ToDecimal(string Value);
         public static string ToString(Decimal Value);
+        public static string ToString(decimal Value, NumberFormatInfo NumberFormat);
+        public static string ToString(double Value, NumberFormatInfo NumberFormat);
+        public static string ToString(float Value, NumberFormatInfo NumberFormat);
     }
+    public sealed class DateType {
+        public static DateTime FromObject(object Value);
+        public static DateTime FromString(string Value);
+        public static DateTime FromString(string Value, CultureInfo culture);
+    }
+    public sealed class DecimalType {
+        public static decimal FromBoolean(bool Value);
+        public static decimal FromObject(object Value);
+        public static decimal FromObject(object Value, NumberFormatInfo NumberFormat);
+        public static decimal FromString(string Value);
+        public static decimal FromString(string Value, NumberFormatInfo NumberFormat);
+        public static decimal Parse(string Value, NumberFormatInfo NumberFormat);
+    }
+    public sealed class DoubleType {
+        public static double FromObject(object Value);
+        public static double FromObject(object Value, NumberFormatInfo NumberFormat);
+        public static double FromString(string Value);
+        public static double FromString(string Value, NumberFormatInfo NumberFormat);
+        public static double Parse(string Value);
+        public static double Parse(string Value, NumberFormatInfo NumberFormat);
+    }
+    public sealed class IntegerType {
+        public static int FromObject(object Value);
+        public static int FromString(string Value);
+    }
+    public sealed class LateBinding {
+        public static void LateCall(object o, Type objType, string name, object[] args, string[] paramnames, bool[] CopyBack);
+        public static object LateGet(object o, Type objType, string name, object[] args, string[] paramnames, bool[] CopyBack);
+        public static object LateIndexGet(object o, object[] args, string[] paramnames);
+        public static void LateIndexSet(object o, object[] args, string[] paramnames);
+        public static void LateIndexSetComplex(object o, object[] args, string[] paramnames, bool OptimisticSet, bool RValueBase);
+        public static void LateSet(object o, Type objType, string name, object[] args, string[] paramnames);
+        public static void LateSetComplex(object o, Type objType, string name, object[] args, string[] paramnames, bool OptimisticSet, bool RValueBase);
+    }
+    public sealed class LikeOperator {
+        public static object LikeObject(object Source, object Pattern, CompareMethod CompareOption);
+        public static bool LikeString(string Source, string Pattern, CompareMethod CompareOption);
+    }
+    public sealed class LongType {
+        public static long FromObject(object Value);
+        public static long FromString(string Value);
+    }
     public sealed class NewLateBinding {
+        public static object FallbackCall(object Instance, string MemberName, object[] Arguments, string[] ArgumentNames, bool IgnoreReturn);
+        public static object FallbackGet(object Instance, string MemberName, object[] Arguments, string[] ArgumentNames);
+        public static void FallbackIndexSet(object Instance, object[] Arguments, string[] ArgumentNames);
+        public static void FallbackIndexSetComplex(object Instance, object[] Arguments, string[] ArgumentNames, bool OptimisticSet, bool RValueBase);
+        public static object FallbackInvokeDefault1(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
+        public static object FallbackInvokeDefault2(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
+        public static void FallbackSet(object Instance, string MemberName, object[] Arguments);
+        public static void FallbackSetComplex(object Instance, string MemberName, object[] Arguments, bool OptimisticSet, bool RValueBase);
+        public static object LateCallInvokeDefault(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
+        public static object LateGetInvokeDefault(object Instance, object[] Arguments, string[] ArgumentNames, bool ReportErrors);
     }
     public sealed class ObjectFlowControl {
         public sealed class ForLoopControl {
             public static bool ForNextCheckDec(Decimal count, Decimal limit, Decimal StepValue);
         }
     }
+    public sealed class ObjectType {
+        public ObjectType();
+        public static object AddObj(object o1, object o2);
+        public static object BitAndObj(object obj1, object obj2);
+        public static object BitOrObj(object obj1, object obj2);
+        public static object BitXorObj(object obj1, object obj2);
+        public static object DivObj(object o1, object o2);
+        public static object GetObjectValuePrimitive(object o);
+        public static object IDivObj(object o1, object o2);
+        public static bool LikeObj(object vLeft, object vRight, CompareMethod CompareOption);
+        public static object ModObj(object o1, object o2);
+        public static object MulObj(object o1, object o2);
+        public static object NegObj(object obj);
+        public static object NotObj(object obj);
+        public static int ObjTst(object o1, object o2, bool TextCompare);
+        public static object PlusObj(object obj);
+        public static object PowObj(object obj1, object obj2);
+        public static object ShiftLeftObj(object o1, int amount);
+        public static object ShiftRightObj(object o1, int amount);
+        public static object StrCatObj(object vLeft, object vRight);
+        public static object SubObj(object o1, object o2);
+        public static object XorObj(object obj1, object obj2);
+    }
     public sealed class Operators {
+        public static object FallbackInvokeUserDefinedOperator(object vbOp, object[] arguments);
     }
     public sealed class ProjectData {
+        public static Exception CreateProjectError(int hr);
+        public static void EndApp();
     }
+    public sealed class ShortType {
+        public static short FromObject(object Value);
+        public static short FromString(string Value);
+    }
+    public sealed class SingleType {
+        public static float FromObject(object Value);
+        public static float FromObject(object Value, NumberFormatInfo NumberFormat);
+        public static float FromString(string Value);
+        public static float FromString(string Value, NumberFormatInfo NumberFormat);
+    }
+    public sealed class StringType {
+        public static string FromBoolean(bool Value);
+        public static string FromByte(byte Value);
+        public static string FromChar(char Value);
+        public static string FromDate(DateTime Value);
+        public static string FromDecimal(decimal Value);
+        public static string FromDecimal(decimal Value, NumberFormatInfo NumberFormat);
+        public static string FromDouble(double Value);
+        public static string FromDouble(double Value, NumberFormatInfo NumberFormat);
+        public static string FromInteger(int Value);
+        public static string FromLong(long Value);
+        public static string FromObject(object Value);
+        public static string FromShort(short Value);
+        public static string FromSingle(float Value);
+        public static string FromSingle(float Value, NumberFormatInfo NumberFormat);
+        public static void MidStmtStr(ref string sDest, int StartPosition, int MaxInsertLength, string sInsert);
+        public static int StrCmp(string sLeft, string sRight, bool TextCompare);
+        public static bool StrLike(string Source, string Pattern, CompareMethod CompareOption);
+        public static bool StrLikeBinary(string Source, string Pattern);
+        public static bool StrLikeText(string Source, string Pattern);
+    }
+    public sealed class Versioned {
+        public static object CallByName(object Instance, string MethodName, CallType UseCallType, params object[] Arguments);
+        public static bool IsNumeric(object Expression);
+        public static string SystemTypeName(string VbName);
+        public static string TypeName(object Expression);
+        public static string VbTypeName(string SystemName);
+    }
 }
```

