# System.Runtime.CompilerServices

``` diff
 namespace System.Runtime.CompilerServices {
+    public struct AsyncIteratorMethodBuilder {
+        public void AwaitOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : INotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void AwaitUnsafeOnCompleted<TAwaiter, TStateMachine>(ref TAwaiter awaiter, ref TStateMachine stateMachine) where TAwaiter : ICriticalNotifyCompletion where TStateMachine : IAsyncStateMachine;
+        public void Complete();
+        public static AsyncIteratorMethodBuilder Create();
+        public void MoveNext<TStateMachine>(ref TStateMachine stateMachine) where TStateMachine : IAsyncStateMachine;
+    }
+    public sealed class AsyncIteratorStateMachineAttribute : StateMachineAttribute {
+        public AsyncIteratorStateMachineAttribute(Type stateMachineType);
+    }
+    public sealed class CallerArgumentExpressionAttribute : Attribute {
+        public CallerArgumentExpressionAttribute(string parameterName);
+        public string ParameterName { get; }
+    }
     public sealed class ConditionalWeakTable<TKey, TValue> : IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>> where TKey : class where TValue : class {
-        ~ConditionalWeakTable();

     }
+    public readonly struct ConfiguredAsyncDisposable {
+        public ConfiguredValueTaskAwaitable DisposeAsync();
+    }
+    public readonly struct ConfiguredCancelableAsyncEnumerable<T> {
+        public ConfiguredCancelableAsyncEnumerable<T> ConfigureAwait(bool continueOnCapturedContext);
+        public ConfiguredCancelableAsyncEnumerable<T>.Enumerator GetAsyncEnumerator();
+        public ConfiguredCancelableAsyncEnumerable<T> WithCancellation(CancellationToken cancellationToken);
+        public readonly struct Enumerator {
+            public T Current { get; }
+            public ConfiguredValueTaskAwaitable DisposeAsync();
+            public ConfiguredValueTaskAwaitable<bool> MoveNextAsync();
+        }
+    }
+    public sealed class EnumeratorCancellationAttribute : Attribute {
+        public EnumeratorCancellationAttribute();
+    }
+    public sealed class IDispatchConstantAttribute : CustomConstantAttribute {
+        public IDispatchConstantAttribute();
+        public override object Value { get; }
+    }
     public enum MethodImplOptions {
+        AggressiveOptimization = 512,
     }
     public static class RuntimeFeature {
+        public const string DefaultImplementationsOfInterfaces = "DefaultImplementationsOfInterfaces";
+        public static bool IsDynamicCodeCompiled { get; }
+        public static bool IsDynamicCodeSupported { get; }
     }
     public static class RuntimeHelpers {
+        public static T[] GetSubArray<T>(T[] array, Range range);
     }
+    public sealed class SwitchExpressionException : InvalidOperationException {
+        public SwitchExpressionException();
+        public SwitchExpressionException(Exception innerException);
+        public SwitchExpressionException(object unmatchedValue);
+        public SwitchExpressionException(string message);
+        public SwitchExpressionException(string message, Exception innerException);
+        public override string Message { get; }
+        public object UnmatchedValue { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public static class Unsafe {
+        public unsafe static void* Add<T>(void* source, int elementOffset);
+        public static ref T Add<T>(ref T source, int elementOffset);
+        public static ref T Add<T>(ref T source, IntPtr elementOffset);
+        public static ref T AddByteOffset<T>(ref T source, IntPtr byteOffset);
+        public static bool AreSame<T>(ref T left, ref T right);
+        public static T As<T>(object o) where T : class;
+        public static ref TTo As<TFrom, TTo>(ref TFrom source);
+        public unsafe static void* AsPointer<T>(ref T value);
+        public unsafe static ref T AsRef<T>(void* source);
+        public static ref T AsRef<T>(in T source);
+        public static IntPtr ByteOffset<T>(ref T origin, ref T target);
+        public unsafe static void Copy<T>(void* destination, ref T source);
+        public unsafe static void Copy<T>(ref T destination, void* source);
+        public static void CopyBlock(ref byte destination, ref byte source, uint byteCount);
+        public unsafe static void CopyBlock(void* destination, void* source, uint byteCount);
+        public static void CopyBlockUnaligned(ref byte destination, ref byte source, uint byteCount);
+        public unsafe static void CopyBlockUnaligned(void* destination, void* source, uint byteCount);
+        public static void InitBlock(ref byte startAddress, byte value, uint byteCount);
+        public unsafe static void InitBlock(void* startAddress, byte value, uint byteCount);
+        public static void InitBlockUnaligned(ref byte startAddress, byte value, uint byteCount);
+        public unsafe static void InitBlockUnaligned(void* startAddress, byte value, uint byteCount);
+        public static bool IsAddressGreaterThan<T>(ref T left, ref T right);
+        public static bool IsAddressLessThan<T>(ref T left, ref T right);
+        public unsafe static T Read<T>(void* source);
+        public static T ReadUnaligned<T>(ref byte source);
+        public unsafe static T ReadUnaligned<T>(void* source);
+        public static int SizeOf<T>();
+        public unsafe static void* Subtract<T>(void* source, int elementOffset);
+        public static ref T Subtract<T>(ref T source, int elementOffset);
+        public static ref T Subtract<T>(ref T source, IntPtr elementOffset);
+        public static ref T SubtractByteOffset<T>(ref T source, IntPtr byteOffset);
+        public static ref T Unbox<T>(object box) where T : struct;
+        public unsafe static void Write<T>(void* destination, T value);
+        public static void WriteUnaligned<T>(ref byte destination, T value);
+        public unsafe static void WriteUnaligned<T>(void* destination, T value);
+    }
 }
```

