# System.Text.Json

``` diff
+namespace System.Text.Json {
+    public enum JsonCommentHandling : byte {
+        Allow = (byte)2,
+        Disallow = (byte)0,
+        Skip = (byte)1,
+    }
+    public sealed class JsonDocument : IDisposable {
+        public JsonElement RootElement { get; }
+        public void Dispose();
+        public static JsonDocument Parse(ReadOnlySequence<byte> utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions));
+        public static JsonDocument Parse(Stream utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions));
+        public static JsonDocument Parse(ReadOnlyMemory<byte> utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions));
+        public static JsonDocument Parse(ReadOnlyMemory<char> json, JsonDocumentOptions options = default(JsonDocumentOptions));
+        public static JsonDocument Parse(string json, JsonDocumentOptions options = default(JsonDocumentOptions));
+        public static Task<JsonDocument> ParseAsync(Stream utf8Json, JsonDocumentOptions options = default(JsonDocumentOptions), CancellationToken cancellationToken = default(CancellationToken));
+        public static JsonDocument ParseValue(ref Utf8JsonReader reader);
+        public static bool TryParseValue(ref Utf8JsonReader reader, out JsonDocument document);
+        public void WriteTo(Utf8JsonWriter writer);
+    }
+    public struct JsonDocumentOptions {
+        public bool AllowTrailingCommas { get; set; }
+        public JsonCommentHandling CommentHandling { get; set; }
+        public int MaxDepth { get; set; }
+    }
+    public readonly struct JsonElement {
+        public JsonElement this[int index] { get; }
+        public JsonValueKind ValueKind { get; }
+        public JsonElement Clone();
+        public JsonElement.ArrayEnumerator EnumerateArray();
+        public JsonElement.ObjectEnumerator EnumerateObject();
+        public int GetArrayLength();
+        public bool GetBoolean();
+        public byte GetByte();
+        public byte[] GetBytesFromBase64();
+        public DateTime GetDateTime();
+        public DateTimeOffset GetDateTimeOffset();
+        public decimal GetDecimal();
+        public double GetDouble();
+        public Guid GetGuid();
+        public short GetInt16();
+        public int GetInt32();
+        public long GetInt64();
+        public JsonElement GetProperty(ReadOnlySpan<byte> utf8PropertyName);
+        public JsonElement GetProperty(ReadOnlySpan<char> propertyName);
+        public JsonElement GetProperty(string propertyName);
+        public string GetRawText();
+        public sbyte GetSByte();
+        public float GetSingle();
+        public string GetString();
+        public ushort GetUInt16();
+        public uint GetUInt32();
+        public ulong GetUInt64();
+        public override string ToString();
+        public bool TryGetByte(out byte value);
+        public bool TryGetBytesFromBase64(out byte[] value);
+        public bool TryGetDateTime(out DateTime value);
+        public bool TryGetDateTimeOffset(out DateTimeOffset value);
+        public bool TryGetDecimal(out decimal value);
+        public bool TryGetDouble(out double value);
+        public bool TryGetGuid(out Guid value);
+        public bool TryGetInt16(out short value);
+        public bool TryGetInt32(out int value);
+        public bool TryGetInt64(out long value);
+        public bool TryGetProperty(ReadOnlySpan<byte> utf8PropertyName, out JsonElement value);
+        public bool TryGetProperty(ReadOnlySpan<char> propertyName, out JsonElement value);
+        public bool TryGetProperty(string propertyName, out JsonElement value);
+        public bool TryGetSByte(out sbyte value);
+        public bool TryGetSingle(out float value);
+        public bool TryGetUInt16(out ushort value);
+        public bool TryGetUInt32(out uint value);
+        public bool TryGetUInt64(out ulong value);
+        public bool ValueEquals(ReadOnlySpan<byte> utf8Text);
+        public bool ValueEquals(ReadOnlySpan<char> text);
+        public bool ValueEquals(string text);
+        public void WriteTo(Utf8JsonWriter writer);
+        public struct ArrayEnumerator : IDisposable, IEnumerable, IEnumerable<JsonElement>, IEnumerator, IEnumerator<JsonElement> {
+            public JsonElement Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public JsonElement.ArrayEnumerator GetEnumerator();
+            public bool MoveNext();
+            public void Reset();
+            IEnumerator<JsonElement> System.Collections.Generic.IEnumerable<System.Text.Json.JsonElement>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        }
+        public struct ObjectEnumerator : IDisposable, IEnumerable, IEnumerable<JsonProperty>, IEnumerator, IEnumerator<JsonProperty> {
+            public JsonProperty Current { get; }
+            object System.Collections.IEnumerator.Current { get; }
+            public void Dispose();
+            public JsonElement.ObjectEnumerator GetEnumerator();
+            public bool MoveNext();
+            public void Reset();
+            IEnumerator<JsonProperty> System.Collections.Generic.IEnumerable<System.Text.Json.JsonProperty>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+        }
+    }
+    public readonly struct JsonEncodedText : IEquatable<JsonEncodedText> {
+        public ReadOnlySpan<byte> EncodedUtf8Bytes { get; }
+        public static JsonEncodedText Encode(ReadOnlySpan<byte> utf8Value, JavaScriptEncoder encoder = null);
+        public static JsonEncodedText Encode(ReadOnlySpan<char> value, JavaScriptEncoder encoder = null);
+        public static JsonEncodedText Encode(string value, JavaScriptEncoder encoder = null);
+        public override bool Equals(object obj);
+        public bool Equals(JsonEncodedText other);
+        public override int GetHashCode();
+        public override string ToString();
+    }
+    public class JsonException : Exception {
+        public JsonException();
+        protected JsonException(SerializationInfo info, StreamingContext context);
+        public JsonException(string message);
+        public JsonException(string message, Exception innerException);
+        public JsonException(string message, string path, long? lineNumber, long? bytePositionInLine);
+        public JsonException(string message, string path, long? lineNumber, long? bytePositionInLine, Exception innerException);
+        public long? BytePositionInLine { get; }
+        public long? LineNumber { get; }
+        public override string Message { get; }
+        public string Path { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public abstract class JsonNamingPolicy {
+        protected JsonNamingPolicy();
+        public static JsonNamingPolicy CamelCase { get; }
+        public abstract string ConvertName(string name);
+    }
+    public readonly struct JsonProperty {
+        public string Name { get; }
+        public JsonElement Value { get; }
+        public bool NameEquals(ReadOnlySpan<byte> utf8Text);
+        public bool NameEquals(ReadOnlySpan<char> text);
+        public bool NameEquals(string text);
+        public override string ToString();
+        public void WriteTo(Utf8JsonWriter writer);
+    }
+    public struct JsonReaderOptions {
+        public bool AllowTrailingCommas { get; set; }
+        public JsonCommentHandling CommentHandling { get; set; }
+        public int MaxDepth { get; set; }
+    }
+    public struct JsonReaderState {
+        public JsonReaderState(JsonReaderOptions options = default(JsonReaderOptions));
+        public JsonReaderOptions Options { get; }
+    }
+    public static class JsonSerializer {
+        public static object Deserialize(ReadOnlySpan<byte> utf8Json, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(string json, Type returnType, JsonSerializerOptions options = null);
+        public static object Deserialize(ref Utf8JsonReader reader, Type returnType, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(ReadOnlySpan<byte> utf8Json, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(string json, JsonSerializerOptions options = null);
+        public static TValue Deserialize<TValue>(ref Utf8JsonReader reader, JsonSerializerOptions options = null);
+        public static ValueTask<object> DeserializeAsync(Stream utf8Json, Type returnType, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> DeserializeAsync<TValue>(Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static string Serialize(object value, Type inputType, JsonSerializerOptions options = null);
+        public static void Serialize(Utf8JsonWriter writer, object value, Type inputType, JsonSerializerOptions options = null);
+        public static void Serialize<TValue>(Utf8JsonWriter writer, TValue value, JsonSerializerOptions options = null);
+        public static string Serialize<TValue>(TValue value, JsonSerializerOptions options = null);
+        public static Task SerializeAsync(Stream utf8Json, object value, Type inputType, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task SerializeAsync<TValue>(Stream utf8Json, TValue value, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static byte[] SerializeToUtf8Bytes(object value, Type inputType, JsonSerializerOptions options = null);
+        public static byte[] SerializeToUtf8Bytes<TValue>(TValue value, JsonSerializerOptions options = null);
+    }
+    public sealed class JsonSerializerOptions {
+        public JsonSerializerOptions();
+        public bool AllowTrailingCommas { get; set; }
+        public IList<JsonConverter> Converters { get; }
+        public int DefaultBufferSize { get; set; }
+        public JsonNamingPolicy DictionaryKeyPolicy { get; set; }
+        public JavaScriptEncoder Encoder { get; set; }
+        public bool IgnoreNullValues { get; set; }
+        public bool IgnoreReadOnlyProperties { get; set; }
+        public int MaxDepth { get; set; }
+        public bool PropertyNameCaseInsensitive { get; set; }
+        public JsonNamingPolicy PropertyNamingPolicy { get; set; }
+        public JsonCommentHandling ReadCommentHandling { get; set; }
+        public bool WriteIndented { get; set; }
+        public JsonConverter GetConverter(Type typeToConvert);
+    }
+    public enum JsonTokenType : byte {
+        Comment = (byte)6,
+        EndArray = (byte)4,
+        EndObject = (byte)2,
+        False = (byte)10,
+        None = (byte)0,
+        Null = (byte)11,
+        Number = (byte)8,
+        PropertyName = (byte)5,
+        StartArray = (byte)3,
+        StartObject = (byte)1,
+        String = (byte)7,
+        True = (byte)9,
+    }
+    public enum JsonValueKind : byte {
+        Array = (byte)2,
+        False = (byte)6,
+        Null = (byte)7,
+        Number = (byte)4,
+        Object = (byte)1,
+        String = (byte)3,
+        True = (byte)5,
+        Undefined = (byte)0,
+    }
+    public struct JsonWriterOptions {
+        public JavaScriptEncoder Encoder { get; set; }
+        public bool Indented { get; set; }
+        public bool SkipValidation { get; set; }
+    }
+    public ref struct Utf8JsonReader {
+        public Utf8JsonReader(ReadOnlySequence<byte> jsonData, bool isFinalBlock, JsonReaderState state);
+        public Utf8JsonReader(ReadOnlySequence<byte> jsonData, JsonReaderOptions options = default(JsonReaderOptions));
+        public Utf8JsonReader(ReadOnlySpan<byte> jsonData, bool isFinalBlock, JsonReaderState state);
+        public Utf8JsonReader(ReadOnlySpan<byte> jsonData, JsonReaderOptions options = default(JsonReaderOptions));
+        public long BytesConsumed { get; }
+        public int CurrentDepth { get; }
+        public JsonReaderState CurrentState { get; }
+        public bool HasValueSequence { get; }
+        public bool IsFinalBlock { get; }
+        public SequencePosition Position { get; }
+        public long TokenStartIndex { get; }
+        public JsonTokenType TokenType { get; }
+        public ReadOnlySequence<byte> ValueSequence { get; }
+        public ReadOnlySpan<byte> ValueSpan { get; }
+        public bool GetBoolean();
+        public byte GetByte();
+        public byte[] GetBytesFromBase64();
+        public string GetComment();
+        public DateTime GetDateTime();
+        public DateTimeOffset GetDateTimeOffset();
+        public decimal GetDecimal();
+        public double GetDouble();
+        public Guid GetGuid();
+        public short GetInt16();
+        public int GetInt32();
+        public long GetInt64();
+        public sbyte GetSByte();
+        public float GetSingle();
+        public string GetString();
+        public ushort GetUInt16();
+        public uint GetUInt32();
+        public ulong GetUInt64();
+        public bool Read();
+        public void Skip();
+        public bool TryGetByte(out byte value);
+        public bool TryGetBytesFromBase64(out byte[] value);
+        public bool TryGetDateTime(out DateTime value);
+        public bool TryGetDateTimeOffset(out DateTimeOffset value);
+        public bool TryGetDecimal(out decimal value);
+        public bool TryGetDouble(out double value);
+        public bool TryGetGuid(out Guid value);
+        public bool TryGetInt16(out short value);
+        public bool TryGetInt32(out int value);
+        public bool TryGetInt64(out long value);
+        public bool TryGetSByte(out sbyte value);
+        public bool TryGetSingle(out float value);
+        public bool TryGetUInt16(out ushort value);
+        public bool TryGetUInt32(out uint value);
+        public bool TryGetUInt64(out ulong value);
+        public bool TrySkip();
+        public bool ValueTextEquals(ReadOnlySpan<byte> utf8Text);
+        public bool ValueTextEquals(ReadOnlySpan<char> text);
+        public bool ValueTextEquals(string text);
+    }
+    public sealed class Utf8JsonWriter : IAsyncDisposable, IDisposable {
+        public Utf8JsonWriter(IBufferWriter<byte> bufferWriter, JsonWriterOptions options = default(JsonWriterOptions));
+        public Utf8JsonWriter(Stream utf8Json, JsonWriterOptions options = default(JsonWriterOptions));
+        public long BytesCommitted { get; }
+        public int BytesPending { get; }
+        public int CurrentDepth { get; }
+        public JsonWriterOptions Options { get; }
+        public void Dispose();
+        public ValueTask DisposeAsync();
+        public void Flush();
+        public Task FlushAsync(CancellationToken cancellationToken = default(CancellationToken));
+        public void Reset();
+        public void Reset(IBufferWriter<byte> bufferWriter);
+        public void Reset(Stream utf8Json);
+        public void WriteBase64String(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64String(ReadOnlySpan<char> propertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64String(string propertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64String(JsonEncodedText propertyName, ReadOnlySpan<byte> bytes);
+        public void WriteBase64StringValue(ReadOnlySpan<byte> bytes);
+        public void WriteBoolean(ReadOnlySpan<byte> utf8PropertyName, bool value);
+        public void WriteBoolean(ReadOnlySpan<char> propertyName, bool value);
+        public void WriteBoolean(string propertyName, bool value);
+        public void WriteBoolean(JsonEncodedText propertyName, bool value);
+        public void WriteBooleanValue(bool value);
+        public void WriteCommentValue(ReadOnlySpan<byte> utf8Value);
+        public void WriteCommentValue(ReadOnlySpan<char> value);
+        public void WriteCommentValue(string value);
+        public void WriteEndArray();
+        public void WriteEndObject();
+        public void WriteNull(ReadOnlySpan<byte> utf8PropertyName);
+        public void WriteNull(ReadOnlySpan<char> propertyName);
+        public void WriteNull(string propertyName);
+        public void WriteNull(JsonEncodedText propertyName);
+        public void WriteNullValue();
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, decimal value);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, double value);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, int value);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, long value);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, float value);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, uint value);
+        public void WriteNumber(ReadOnlySpan<byte> utf8PropertyName, ulong value);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, decimal value);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, double value);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, int value);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, long value);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, float value);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, uint value);
+        public void WriteNumber(ReadOnlySpan<char> propertyName, ulong value);
+        public void WriteNumber(string propertyName, decimal value);
+        public void WriteNumber(string propertyName, double value);
+        public void WriteNumber(string propertyName, int value);
+        public void WriteNumber(string propertyName, long value);
+        public void WriteNumber(string propertyName, float value);
+        public void WriteNumber(string propertyName, uint value);
+        public void WriteNumber(string propertyName, ulong value);
+        public void WriteNumber(JsonEncodedText propertyName, decimal value);
+        public void WriteNumber(JsonEncodedText propertyName, double value);
+        public void WriteNumber(JsonEncodedText propertyName, int value);
+        public void WriteNumber(JsonEncodedText propertyName, long value);
+        public void WriteNumber(JsonEncodedText propertyName, float value);
+        public void WriteNumber(JsonEncodedText propertyName, uint value);
+        public void WriteNumber(JsonEncodedText propertyName, ulong value);
+        public void WriteNumberValue(decimal value);
+        public void WriteNumberValue(double value);
+        public void WriteNumberValue(int value);
+        public void WriteNumberValue(long value);
+        public void WriteNumberValue(float value);
+        public void WriteNumberValue(uint value);
+        public void WriteNumberValue(ulong value);
+        public void WritePropertyName(ReadOnlySpan<byte> utf8PropertyName);
+        public void WritePropertyName(ReadOnlySpan<char> propertyName);
+        public void WritePropertyName(string propertyName);
+        public void WritePropertyName(JsonEncodedText propertyName);
+        public void WriteStartArray();
+        public void WriteStartArray(ReadOnlySpan<byte> utf8PropertyName);
+        public void WriteStartArray(ReadOnlySpan<char> propertyName);
+        public void WriteStartArray(string propertyName);
+        public void WriteStartArray(JsonEncodedText propertyName);
+        public void WriteStartObject();
+        public void WriteStartObject(ReadOnlySpan<byte> utf8PropertyName);
+        public void WriteStartObject(ReadOnlySpan<char> propertyName);
+        public void WriteStartObject(string propertyName);
+        public void WriteStartObject(JsonEncodedText propertyName);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTime value);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, DateTimeOffset value);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, Guid value);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<byte> utf8Value);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, ReadOnlySpan<char> value);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, string value);
+        public void WriteString(ReadOnlySpan<byte> utf8PropertyName, JsonEncodedText value);
+        public void WriteString(ReadOnlySpan<char> propertyName, DateTime value);
+        public void WriteString(ReadOnlySpan<char> propertyName, DateTimeOffset value);
+        public void WriteString(ReadOnlySpan<char> propertyName, Guid value);
+        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<byte> utf8Value);
+        public void WriteString(ReadOnlySpan<char> propertyName, ReadOnlySpan<char> value);
+        public void WriteString(ReadOnlySpan<char> propertyName, string value);
+        public void WriteString(ReadOnlySpan<char> propertyName, JsonEncodedText value);
+        public void WriteString(string propertyName, DateTime value);
+        public void WriteString(string propertyName, DateTimeOffset value);
+        public void WriteString(string propertyName, Guid value);
+        public void WriteString(string propertyName, ReadOnlySpan<byte> utf8Value);
+        public void WriteString(string propertyName, ReadOnlySpan<char> value);
+        public void WriteString(string propertyName, string value);
+        public void WriteString(string propertyName, JsonEncodedText value);
+        public void WriteString(JsonEncodedText propertyName, DateTime value);
+        public void WriteString(JsonEncodedText propertyName, DateTimeOffset value);
+        public void WriteString(JsonEncodedText propertyName, Guid value);
+        public void WriteString(JsonEncodedText propertyName, ReadOnlySpan<byte> utf8Value);
+        public void WriteString(JsonEncodedText propertyName, ReadOnlySpan<char> value);
+        public void WriteString(JsonEncodedText propertyName, string value);
+        public void WriteString(JsonEncodedText propertyName, JsonEncodedText value);
+        public void WriteStringValue(DateTime value);
+        public void WriteStringValue(DateTimeOffset value);
+        public void WriteStringValue(Guid value);
+        public void WriteStringValue(ReadOnlySpan<byte> utf8Value);
+        public void WriteStringValue(ReadOnlySpan<char> value);
+        public void WriteStringValue(string value);
+        public void WriteStringValue(JsonEncodedText value);
+    }
+}
```

