# System.Threading

``` diff
 namespace System.Threading {
-    public struct AsyncLocalValueChangedArgs<T>
+    public readonly struct AsyncLocalValueChangedArgs<T>
     public readonly struct CancellationToken {
+        public CancellationTokenRegistration UnsafeRegister(Action<object> callback, object state);
     }
-    public readonly struct CancellationTokenRegistration : IDisposable, IEquatable<CancellationTokenRegistration> {
+    public readonly struct CancellationTokenRegistration : IAsyncDisposable, IDisposable, IEquatable<CancellationTokenRegistration> {
+        public ValueTask DisposeAsync();
+        public bool Unregister();
     }
+    public interface IThreadPoolWorkItem {
+        void Execute();
+    }
     public static class Monitor {
+        public static long LockContentionCount { get; }
     }
     public sealed class PreAllocatedOverlapped : IDisposable {
+        ~PreAllocatedOverlapped();
     }
     public sealed class ReaderWriterLock : CriticalFinalizerObject {
-        ~ReaderWriterLock();

     }
     public struct SpinWait {
+        public void SpinOnce(int sleep1Threshold);
     }
     public static class ThreadPool {
+        public static long CompletedWorkItemCount { get; }
+        public static long PendingWorkItemCount { get; }
+        public static int ThreadCount { get; }
+        public static bool UnsafeQueueUserWorkItem(IThreadPoolWorkItem callBack, bool preferLocal);
+        public static bool UnsafeQueueUserWorkItem<TState>(Action<TState> callBack, TState state, bool preferLocal);
     }
-    public sealed class Timer : MarshalByRefObject, IDisposable {
+    public sealed class Timer : MarshalByRefObject, IAsyncDisposable, IDisposable {
+        public static long ActiveCount { get; }
+        public ValueTask DisposeAsync();
     }
 }
```

