# System.ServiceModel.Security

``` diff
 namespace System.ServiceModel.Security {
+    public abstract class SecurityAlgorithmSuite {
+        protected SecurityAlgorithmSuite();
+        public abstract string DefaultAsymmetricKeyWrapAlgorithm { get; }
+        public abstract string DefaultAsymmetricSignatureAlgorithm { get; }
+        public abstract string DefaultCanonicalizationAlgorithm { get; }
+        public abstract string DefaultDigestAlgorithm { get; }
+        public abstract string DefaultEncryptionAlgorithm { get; }
+        public abstract int DefaultEncryptionKeyDerivationLength { get; }
+        public abstract int DefaultSignatureKeyDerivationLength { get; }
+        public abstract int DefaultSymmetricKeyLength { get; }
+        public abstract string DefaultSymmetricKeyWrapAlgorithm { get; }
+        public abstract string DefaultSymmetricSignatureAlgorithm { get; }
+        public abstract bool IsAsymmetricKeyLengthSupported(int length);
+        public virtual bool IsAsymmetricKeyWrapAlgorithmSupported(string algorithm);
+        public virtual bool IsAsymmetricSignatureAlgorithmSupported(string algorithm);
+        public virtual bool IsCanonicalizationAlgorithmSupported(string algorithm);
+        public virtual bool IsDigestAlgorithmSupported(string algorithm);
+        public virtual bool IsEncryptionAlgorithmSupported(string algorithm);
+        public virtual bool IsEncryptionKeyDerivationAlgorithmSupported(string algorithm);
+        public virtual bool IsSignatureKeyDerivationAlgorithmSupported(string algorithm);
+        public abstract bool IsSymmetricKeyLengthSupported(int length);
+        public virtual bool IsSymmetricKeyWrapAlgorithmSupported(string algorithm);
+        public virtual bool IsSymmetricSignatureAlgorithmSupported(string algorithm);
+    }
 }
```

