# System.ServiceModel

``` diff
 namespace System.ServiceModel {
+    public sealed class BasicHttpMessageSecurity {
+        public BasicHttpMessageSecurity();
+        public SecurityAlgorithmSuite AlgorithmSuite { get; set; }
+        public BasicHttpMessageCredentialType ClientCredentialType { get; set; }
+    }
     public sealed class BasicHttpSecurity {
+        public BasicHttpMessageSecurity Message { get; set; }
     }
     public class ChannelFactory<TChannel> : ChannelFactory, IChannelFactory, IChannelFactory<TChannel>, ICommunicationObject {
+        public ChannelFactory(ServiceEndpoint endpoint);
     }
     public abstract class ClientBase<TChannel> : ICommunicationObject, IDisposable where TChannel : class {
+        protected ClientBase(ServiceEndpoint endpoint);
     }
     public sealed class HttpTransportSecurity {
+        public ExtendedProtectionPolicy ExtendedProtectionPolicy { get; set; }
     }
+    public class MessageSecurityOverHttp {
+        public MessageSecurityOverHttp();
+        public SecurityAlgorithmSuite AlgorithmSuite { get; set; }
+        public MessageCredentialType ClientCredentialType { get; set; }
+        public bool NegotiateServiceCredential { get; set; }
+        protected virtual bool IsSecureConversationEnabled();
+    }
+    public sealed class NonDualMessageSecurityOverHttp : MessageSecurityOverHttp {
+        public NonDualMessageSecurityOverHttp();
+        public bool EstablishSecurityContext { get; set; }
+        protected override bool IsSecureConversationEnabled();
+    }
+    public class WSHttpBinding : WSHttpBindingBase {
+        public WSHttpBinding();
+        public WSHttpBinding(SecurityMode securityMode);
+        public WSHttpBinding(SecurityMode securityMode, bool reliableSessionEnabled);
+        public bool AllowCookies { get; set; }
+        public WSHttpSecurity Security { get; set; }
+        public override IChannelFactory<TChannel> BuildChannelFactory<TChannel>(BindingParameterCollection parameters);
+        public override BindingElementCollection CreateBindingElements();
+        protected override SecurityBindingElement CreateMessageSecurity();
+        protected override TransportBindingElement GetTransport();
+    }
+    public abstract class WSHttpBindingBase : Binding {
+        protected WSHttpBindingBase();
+        protected WSHttpBindingBase(bool reliableSessionEnabled);
+        public bool BypassProxyOnLocal { get; set; }
+        public EnvelopeVersion EnvelopeVersion { get; set; }
+        public long MaxBufferPoolSize { get; set; }
+        public long MaxReceivedMessageSize { get; set; }
+        public Uri ProxyAddress { get; set; }
+        public XmlDictionaryReaderQuotas ReaderQuotas { get; set; }
+        public override string Scheme { get; }
+        public Encoding TextEncoding { get; set; }
+        public bool TransactionFlow { get; set; }
+        public bool UseDefaultWebProxy { get; set; }
+        public override BindingElementCollection CreateBindingElements();
+        protected abstract SecurityBindingElement CreateMessageSecurity();
+        protected abstract TransportBindingElement GetTransport();
+    }
+    public sealed class WSHttpSecurity {
+        public WSHttpSecurity();
+        public NonDualMessageSecurityOverHttp Message { get; set; }
+        public SecurityMode Mode { get; set; }
+        public HttpTransportSecurity Transport { get; set; }
+    }
 }
```

