# Microsoft.AspNetCore.Http.Abstractions

``` diff
 {
     namespace Microsoft.AspNetCore.Builder {
+        public abstract class EndpointBuilder {
+            protected EndpointBuilder();
+            public string DisplayName { get; set; }
+            public IList<object> Metadata { get; }
+            public RequestDelegate RequestDelegate { get; set; }
+            public abstract Endpoint Build();
+        }
+        public interface IEndpointConventionBuilder {
+            void Add(Action<EndpointBuilder> convention);
+        }
     }
+    namespace Microsoft.AspNetCore.Cors.Infrastructure {
+        public interface ICorsMetadata
+    }
     namespace Microsoft.AspNetCore.Http {
+        public class Endpoint {
+            public Endpoint(RequestDelegate requestDelegate, EndpointMetadataCollection metadata, string displayName);
+            public string DisplayName { get; }
+            public EndpointMetadataCollection Metadata { get; }
+            public RequestDelegate RequestDelegate { get; }
+            public override string ToString();
+        }
+        public static class EndpointHttpContextExtensions {
+            public static Endpoint GetEndpoint(this HttpContext context);
+            public static void SetEndpoint(this HttpContext context, Endpoint endpoint);
+        }
+        public sealed class EndpointMetadataCollection : IEnumerable, IEnumerable<object>, IReadOnlyCollection<object>, IReadOnlyList<object> {
+            public static readonly EndpointMetadataCollection Empty;
+            public EndpointMetadataCollection(IEnumerable<object> items);
+            public EndpointMetadataCollection(params object[] items);
+            public int Count { get; }
+            public object this[int index] { get; }
+            public EndpointMetadataCollection.Enumerator GetEnumerator();
+            public T GetMetadata<T>() where T : class;
+            public IReadOnlyList<T> GetOrderedMetadata<T>() where T : class;
+            IEnumerator<object> System.Collections.Generic.IEnumerable<System.Object>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<object> {
+                public object Current { get; }
+                public void Dispose();
+                public bool MoveNext();
+                public void Reset();
+            }
+        }
-        public struct FragmentString : IEquatable<FragmentString>
+        public readonly struct FragmentString : IEquatable<FragmentString>
-        public struct HostString : IEquatable<HostString>
+        public readonly struct HostString : IEquatable<HostString>
         public abstract class HttpContext {
-            public abstract AuthenticationManager Authentication { get; }

         }
         public abstract class HttpRequest {
+            public virtual PipeReader BodyReader { get; }
+            public virtual RouteValueDictionary RouteValues { get; set; }
         }
         public abstract class HttpResponse {
+            public virtual PipeWriter BodyWriter { get; }
+            public virtual Task CompleteAsync();
+            public virtual void RegisterForDisposeAsync(IAsyncDisposable disposable);
+            public virtual Task StartAsync(CancellationToken cancellationToken = default(CancellationToken));
         }
-        public struct PathString : IEquatable<PathString>
+        public readonly struct PathString : IEquatable<PathString>
-        public struct QueryString : IEquatable<QueryString>
+        public readonly struct QueryString : IEquatable<QueryString>
+        public static class RequestTrailerExtensions {
+            public static bool CheckTrailersAvailable(this HttpRequest request);
+            public static StringValues GetDeclaredTrailers(this HttpRequest request);
+            public static StringValues GetTrailer(this HttpRequest request, string trailerName);
+            public static bool SupportsTrailers(this HttpRequest request);
+        }
     }
-    namespace Microsoft.AspNetCore.Http.Authentication {
 {
-        public class AuthenticateInfo {
 {
-            public AuthenticateInfo();

-            public AuthenticationDescription Description { get; set; }

-            public ClaimsPrincipal Principal { get; set; }

-            public AuthenticationProperties Properties { get; set; }

-        }
-        public class AuthenticationDescription {
 {
-            public AuthenticationDescription();

-            public AuthenticationDescription(IDictionary<string, object> items);

-            public string AuthenticationScheme { get; set; }

-            public string DisplayName { get; set; }

-            public IDictionary<string, object> Items { get; }

-        }
-        public abstract class AuthenticationManager {
 {
-            public const string AutomaticScheme = "Automatic";

-            protected AuthenticationManager();

-            public abstract HttpContext HttpContext { get; }

-            public abstract Task AuthenticateAsync(AuthenticateContext context);

-            public virtual Task<ClaimsPrincipal> AuthenticateAsync(string authenticationScheme);

-            public virtual Task ChallengeAsync();

-            public virtual Task ChallengeAsync(AuthenticationProperties properties);

-            public virtual Task ChallengeAsync(string authenticationScheme);

-            public virtual Task ChallengeAsync(string authenticationScheme, AuthenticationProperties properties);

-            public abstract Task ChallengeAsync(string authenticationScheme, AuthenticationProperties properties, ChallengeBehavior behavior);

-            public virtual Task ForbidAsync();

-            public virtual Task ForbidAsync(AuthenticationProperties properties);

-            public virtual Task ForbidAsync(string authenticationScheme);

-            public virtual Task ForbidAsync(string authenticationScheme, AuthenticationProperties properties);

-            public abstract Task<AuthenticateInfo> GetAuthenticateInfoAsync(string authenticationScheme);

-            public abstract IEnumerable<AuthenticationDescription> GetAuthenticationSchemes();

-            public virtual Task SignInAsync(string authenticationScheme, ClaimsPrincipal principal);

-            public abstract Task SignInAsync(string authenticationScheme, ClaimsPrincipal principal, AuthenticationProperties properties);

-            public virtual Task SignOutAsync(string authenticationScheme);

-            public abstract Task SignOutAsync(string authenticationScheme, AuthenticationProperties properties);

-        }
-        public class AuthenticationProperties {
 {
-            public AuthenticationProperties();

-            public AuthenticationProperties(IDictionary<string, string> items);

-            public bool? AllowRefresh { get; set; }

-            public DateTimeOffset? ExpiresUtc { get; set; }

-            public bool IsPersistent { get; set; }

-            public DateTimeOffset? IssuedUtc { get; set; }

-            public IDictionary<string, string> Items { get; }

-            public string RedirectUri { get; set; }

-        }
-    }
+    namespace Microsoft.AspNetCore.Http.Features {
+        public interface IEndpointFeature {
+            Endpoint Endpoint { get; set; }
+        }
+        public interface IRouteValuesFeature {
+            RouteValueDictionary RouteValues { get; set; }
+        }
+    }
-    namespace Microsoft.AspNetCore.Http.Internal {
 {
-        public struct HeaderSegment : IEquatable<HeaderSegment> {
 {
-            public HeaderSegment(StringSegment formatting, StringSegment data);

-            public StringSegment Data { get; }

-            public StringSegment Formatting { get; }

-            public bool Equals(HeaderSegment other);

-            public override bool Equals(object obj);

-            public override int GetHashCode();

-            public static bool operator ==(HeaderSegment left, HeaderSegment right);

-            public static bool operator !=(HeaderSegment left, HeaderSegment right);

-        }
-        public struct HeaderSegmentCollection : IEnumerable, IEnumerable<HeaderSegment>, IEquatable<HeaderSegmentCollection> {
 {
-            public HeaderSegmentCollection(StringValues headers);

-            public bool Equals(HeaderSegmentCollection other);

-            public override bool Equals(object obj);

-            public HeaderSegmentCollection.Enumerator GetEnumerator();

-            public override int GetHashCode();

-            public static bool operator ==(HeaderSegmentCollection left, HeaderSegmentCollection right);

-            public static bool operator !=(HeaderSegmentCollection left, HeaderSegmentCollection right);

-            IEnumerator<HeaderSegment> System.Collections.Generic.IEnumerable<Microsoft.AspNetCore.Http.Internal.HeaderSegment>.GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<HeaderSegment> {
 {
-                public Enumerator(StringValues headers);

-                public HeaderSegment Current { get; }

-                object System.Collections.IEnumerator.Current { get; }

-                public void Dispose();

-                public bool MoveNext();

-                public void Reset();

-            }
-        }
-        public static class ParsingHelpers {
 {
-            public static void AppendHeaderJoined(IHeaderDictionary headers, string key, params string[] values);

-            public static void AppendHeaderUnmodified(IHeaderDictionary headers, string key, StringValues values);

-            public static StringValues GetHeader(IHeaderDictionary headers, string key);

-            public static StringValues GetHeaderSplit(IHeaderDictionary headers, string key);

-            public static StringValues GetHeaderUnmodified(IHeaderDictionary headers, string key);

-            public static void SetHeaderJoined(IHeaderDictionary headers, string key, StringValues value);

-            public static void SetHeaderUnmodified(IHeaderDictionary headers, string key, StringValues? values);

-        }
-    }
+    namespace Microsoft.AspNetCore.Routing {
+        public class RouteValueDictionary : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IEnumerable, IEnumerable<KeyValuePair<string, object>>, IReadOnlyCollection<KeyValuePair<string, object>>, IReadOnlyDictionary<string, object> {
+            public RouteValueDictionary();
+            public RouteValueDictionary(object values);
+            public IEqualityComparer<string> Comparer { get; }
+            public int Count { get; }
+            public ICollection<string> Keys { get; }
+            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.IsReadOnly { get; }
+            IEnumerable<string> System.Collections.Generic.IReadOnlyDictionary<System.String,System.Object>.Keys { get; }
+            IEnumerable<object> System.Collections.Generic.IReadOnlyDictionary<System.String,System.Object>.Values { get; }
+            public object this[string key] { get; set; }
+            public ICollection<object> Values { get; }
+            public void Add(string key, object value);
+            public void Clear();
+            public bool ContainsKey(string key);
+            public static RouteValueDictionary FromArray(KeyValuePair<string, object>[] items);
+            public RouteValueDictionary.Enumerator GetEnumerator();
+            public bool Remove(string key);
+            public bool Remove(string key, out object value);
+            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Add(KeyValuePair<string, object> item);
+            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Contains(KeyValuePair<string, object> item);
+            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
+            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Remove(KeyValuePair<string, object> item);
+            IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public bool TryAdd(string key, object value);
+            public bool TryGetValue(string key, out object value);
+            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, object>> {
+                public Enumerator(RouteValueDictionary dictionary);
+                public KeyValuePair<string, object> Current { get; }
+                object System.Collections.IEnumerator.Current { get; }
+                public void Dispose();
+                public bool MoveNext();
+                public void Reset();
+            }
+        }
+    }
 }
```

