# Microsoft.AspNetCore.Http

``` diff
 {
+    namespace Microsoft.AspNetCore.Builder {
+        public class ApplicationBuilder : IApplicationBuilder {
+            public ApplicationBuilder(IServiceProvider serviceProvider);
+            public ApplicationBuilder(IServiceProvider serviceProvider, object server);
+            public IServiceProvider ApplicationServices { get; set; }
+            public IDictionary<string, object> Properties { get; }
+            public IFeatureCollection ServerFeatures { get; }
+            public RequestDelegate Build();
+            public IApplicationBuilder New();
+            public IApplicationBuilder Use(Func<RequestDelegate, RequestDelegate> middleware);
+        }
+    }
-    namespace Microsoft.AspNetCore.Builder.Internal {
 {
-        public class ApplicationBuilder : IApplicationBuilder {
 {
-            public ApplicationBuilder(IServiceProvider serviceProvider);

-            public ApplicationBuilder(IServiceProvider serviceProvider, object server);

-            public IServiceProvider ApplicationServices { get; set; }

-            public IDictionary<string, object> Properties { get; }

-            public IFeatureCollection ServerFeatures { get; }

-            public RequestDelegate Build();

-            public IApplicationBuilder New();

-            public IApplicationBuilder Use(Func<RequestDelegate, RequestDelegate> middleware);

-        }
-    }
     namespace Microsoft.AspNetCore.Http {
+        public class BindingAddress {
+            public BindingAddress();
+            public string Host { get; }
+            public bool IsUnixPipe { get; }
+            public string PathBase { get; }
+            public int Port { get; }
+            public string Scheme { get; }
+            public string UnixPipePath { get; }
+            public override bool Equals(object obj);
+            public override int GetHashCode();
+            public static BindingAddress Parse(string address);
+            public override string ToString();
+        }
-        public class DefaultHttpContext : HttpContext {
+        public sealed class DefaultHttpContext : HttpContext {
-            public override AuthenticationManager Authentication { get; }

+            public FormOptions FormOptions { get; set; }
+            public HttpContext HttpContext { get; }
+            public IServiceScopeFactory ServiceScopeFactory { get; set; }
-            public virtual void Initialize(IFeatureCollection features);
+            public void Initialize(IFeatureCollection features);
-            protected virtual AuthenticationManager InitializeAuthenticationManager();

-            protected virtual ConnectionInfo InitializeConnectionInfo();

-            protected virtual HttpRequest InitializeHttpRequest();

-            protected virtual HttpResponse InitializeHttpResponse();

-            protected virtual WebSocketManager InitializeWebSocketManager();

-            public virtual void Uninitialize();
+            public void Uninitialize();
-            protected virtual void UninitializeAuthenticationManager(AuthenticationManager instance);

-            protected virtual void UninitializeConnectionInfo(ConnectionInfo instance);

-            protected virtual void UninitializeHttpRequest(HttpRequest instance);

-            protected virtual void UninitializeHttpResponse(HttpResponse instance);

-            protected virtual void UninitializeWebSocketManager(WebSocketManager instance);

         }
+        public class FormFile : IFormFile {
+            public FormFile(Stream baseStream, long baseStreamOffset, long length, string name, string fileName);
+            public string ContentDisposition { get; set; }
+            public string ContentType { get; set; }
+            public string FileName { get; }
+            public IHeaderDictionary Headers { get; set; }
+            public long Length { get; }
+            public string Name { get; }
+            public void CopyTo(Stream target);
+            public Task CopyToAsync(Stream target, CancellationToken cancellationToken = default(CancellationToken));
+            public Stream OpenReadStream();
+        }
+        public class FormFileCollection : List<IFormFile>, IEnumerable, IEnumerable<IFormFile>, IFormFileCollection, IReadOnlyCollection<IFormFile>, IReadOnlyList<IFormFile> {
+            public FormFileCollection();
+            public IFormFile this[string name] { get; }
+            public IFormFile GetFile(string name);
+            public IReadOnlyList<IFormFile> GetFiles(string name);
+        }
         public class HttpContextFactory : IHttpContextFactory {
+            public HttpContextFactory(IOptions<FormOptions> formOptions, IServiceScopeFactory serviceScopeFactory);
+            public HttpContextFactory(IOptions<FormOptions> formOptions, IServiceScopeFactory serviceScopeFactory, IHttpContextAccessor httpContextAccessor);
         }
+        public class QueryCollection : IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IQueryCollection {
+            public static readonly QueryCollection Empty;
+            public QueryCollection();
+            public QueryCollection(QueryCollection store);
+            public QueryCollection(Dictionary<string, StringValues> store);
+            public QueryCollection(int capacity);
+            public int Count { get; }
+            public ICollection<string> Keys { get; }
+            public StringValues this[string key] { get; }
+            public bool ContainsKey(string key);
+            public QueryCollection.Enumerator GetEnumerator();
+            IEnumerator<KeyValuePair<string, StringValues>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.GetEnumerator();
+            IEnumerator System.Collections.IEnumerable.GetEnumerator();
+            public bool TryGetValue(string key, out StringValues value);
+            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, StringValues>> {
+                public KeyValuePair<string, StringValues> Current { get; }
+                object System.Collections.IEnumerator.Current { get; }
+                public void Dispose();
+                public bool MoveNext();
+                void System.Collections.IEnumerator.Reset();
+            }
+        }
+        public static class SendFileFallback {
+            public static Task SendFileAsync(Stream destination, string filePath, long offset, long? count, CancellationToken cancellationToken);
+        }
+        public class StreamResponseBodyFeature : IHttpResponseBodyFeature {
+            public StreamResponseBodyFeature(Stream stream);
+            public StreamResponseBodyFeature(Stream stream, IHttpResponseBodyFeature priorFeature);
+            public IHttpResponseBodyFeature PriorFeature { get; }
+            public Stream Stream { get; }
+            public PipeWriter Writer { get; }
+            public virtual Task CompleteAsync();
+            public virtual void DisableBuffering();
+            public void Dispose();
+            public virtual Task SendFileAsync(string path, long offset, long? count, CancellationToken cancellationToken);
+            public virtual Task StartAsync(CancellationToken cancellationToken = default(CancellationToken));
+        }
     }
-    namespace Microsoft.AspNetCore.Http.Authentication.Internal {
 {
-        public class DefaultAuthenticationManager : AuthenticationManager {
 {
-            public DefaultAuthenticationManager(HttpContext context);

-            public override HttpContext HttpContext { get; }

-            public override Task AuthenticateAsync(AuthenticateContext context);

-            public override Task ChallengeAsync(string authenticationScheme, AuthenticationProperties properties, ChallengeBehavior behavior);

-            public override Task<AuthenticateInfo> GetAuthenticateInfoAsync(string authenticationScheme);

-            public override IEnumerable<AuthenticationDescription> GetAuthenticationSchemes();

-            public virtual void Initialize(HttpContext context);

-            public override Task SignInAsync(string authenticationScheme, ClaimsPrincipal principal, AuthenticationProperties properties);

-            public override Task SignOutAsync(string authenticationScheme, AuthenticationProperties properties);

-            public virtual void Uninitialize();

-        }
-    }
     namespace Microsoft.AspNetCore.Http.Features {
+        public class RequestBodyPipeFeature : IRequestBodyPipeFeature {
+            public RequestBodyPipeFeature(HttpContext context);
+            public PipeReader Reader { get; }
+        }
+        public class RequestServicesFeature : IAsyncDisposable, IDisposable, IServiceProvidersFeature {
+            public RequestServicesFeature(HttpContext context, IServiceScopeFactory scopeFactory);
+            public IServiceProvider RequestServices { get; set; }
+            public void Dispose();
+            public ValueTask DisposeAsync();
+        }
+        public class RouteValuesFeature : IRouteValuesFeature {
+            public RouteValuesFeature();
+            public RouteValueDictionary RouteValues { get; set; }
+        }
     }
     namespace Microsoft.AspNetCore.Http.Features.Authentication {
         public class HttpAuthenticationFeature : IHttpAuthenticationFeature {
-            public IAuthenticationHandler Handler { get; set; }

         }
     }
-    namespace Microsoft.AspNetCore.Http.Internal {
 {
-        public class BindingAddress {
 {
-            public BindingAddress();

-            public string Host { get; private set; }

-            public bool IsUnixPipe { get; }

-            public string PathBase { get; private set; }

-            public int Port { get; internal set; }

-            public string Scheme { get; private set; }

-            public string UnixPipePath { get; }

-            public override bool Equals(object obj);

-            public override int GetHashCode();

-            public static BindingAddress Parse(string address);

-            public override string ToString();

-        }
-        public static class BufferingHelper {
 {
-            public static string TempDirectory { get; }

-            public static HttpRequest EnableRewind(this HttpRequest request, int bufferThreshold = 30720, long? bufferLimit = default(long?));

-            public static MultipartSection EnableRewind(this MultipartSection section, Action<IDisposable> registerForDispose, int bufferThreshold = 30720, long? bufferLimit = default(long?));

-        }
-        public class DefaultConnectionInfo : ConnectionInfo {
 {
-            public DefaultConnectionInfo(IFeatureCollection features);

-            public override X509Certificate2 ClientCertificate { get; set; }

-            public override string Id { get; set; }

-            public override IPAddress LocalIpAddress { get; set; }

-            public override int LocalPort { get; set; }

-            public override IPAddress RemoteIpAddress { get; set; }

-            public override int RemotePort { get; set; }

-            public override Task<X509Certificate2> GetClientCertificateAsync(CancellationToken cancellationToken = default(CancellationToken));

-            public virtual void Initialize(IFeatureCollection features);

-            public virtual void Uninitialize();

-        }
-        public class DefaultHttpRequest : HttpRequest {
 {
-            public DefaultHttpRequest(HttpContext context);

-            public override Stream Body { get; set; }

-            public override long? ContentLength { get; set; }

-            public override string ContentType { get; set; }

-            public override IRequestCookieCollection Cookies { get; set; }

-            public override IFormCollection Form { get; set; }

-            public override bool HasFormContentType { get; }

-            public override IHeaderDictionary Headers { get; }

-            public override HostString Host { get; set; }

-            public override HttpContext HttpContext { get; }

-            public override bool IsHttps { get; set; }

-            public override string Method { get; set; }

-            public override PathString Path { get; set; }

-            public override PathString PathBase { get; set; }

-            public override string Protocol { get; set; }

-            public override IQueryCollection Query { get; set; }

-            public override QueryString QueryString { get; set; }

-            public override string Scheme { get; set; }

-            public virtual void Initialize(HttpContext context);

-            public override Task<IFormCollection> ReadFormAsync(CancellationToken cancellationToken);

-            public virtual void Uninitialize();

-        }
-        public class DefaultHttpResponse : HttpResponse {
 {
-            public DefaultHttpResponse(HttpContext context);

-            public override Stream Body { get; set; }

-            public override long? ContentLength { get; set; }

-            public override string ContentType { get; set; }

-            public override IResponseCookies Cookies { get; }

-            public override bool HasStarted { get; }

-            public override IHeaderDictionary Headers { get; }

-            public override HttpContext HttpContext { get; }

-            public override int StatusCode { get; set; }

-            public virtual void Initialize(HttpContext context);

-            public override void OnCompleted(Func<object, Task> callback, object state);

-            public override void OnStarting(Func<object, Task> callback, object state);

-            public override void Redirect(string location, bool permanent);

-            public virtual void Uninitialize();

-        }
-        public class DefaultWebSocketManager : WebSocketManager {
 {
-            public DefaultWebSocketManager(IFeatureCollection features);

-            public override bool IsWebSocketRequest { get; }

-            public override IList<string> WebSocketRequestedProtocols { get; }

-            public override Task<WebSocket> AcceptWebSocketAsync(string subProtocol);

-            public virtual void Initialize(IFeatureCollection features);

-            public virtual void Uninitialize();

-        }
-        public class FormFile : IFormFile {
 {
-            public FormFile(Stream baseStream, long baseStreamOffset, long length, string name, string fileName);

-            public string ContentDisposition { get; set; }

-            public string ContentType { get; set; }

-            public string FileName { get; }

-            public IHeaderDictionary Headers { get; set; }

-            public long Length { get; }

-            public string Name { get; }

-            public void CopyTo(Stream target);

-            public Task CopyToAsync(Stream target, CancellationToken cancellationToken = default(CancellationToken));

-            public Stream OpenReadStream();

-        }
-        public class FormFileCollection : List<IFormFile>, IEnumerable, IEnumerable<IFormFile>, IFormFileCollection, IReadOnlyCollection<IFormFile>, IReadOnlyList<IFormFile> {
 {
-            public FormFileCollection();

-            public IFormFile this[string name] { get; }

-            public IFormFile GetFile(string name);

-            public IReadOnlyList<IFormFile> GetFiles(string name);

-        }
-        public class ItemsDictionary : ICollection<KeyValuePair<object, object>>, IDictionary<object, object>, IEnumerable, IEnumerable<KeyValuePair<object, object>> {
 {
-            public ItemsDictionary();

-            public ItemsDictionary(IDictionary<object, object> items);

-            public IDictionary<object, object> Items { get; }

-            int System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.Count { get; }

-            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.IsReadOnly { get; }

-            object System.Collections.Generic.IDictionary<System.Object,System.Object>.this[object key] { get; set; }

-            ICollection<object> System.Collections.Generic.IDictionary<System.Object,System.Object>.Keys { get; }

-            ICollection<object> System.Collections.Generic.IDictionary<System.Object,System.Object>.Values { get; }

-            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.Add(KeyValuePair<object, object> item);

-            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.Clear();

-            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.Contains(KeyValuePair<object, object> item);

-            void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.CopyTo(KeyValuePair<object, object>[] array, int arrayIndex);

-            bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.Remove(KeyValuePair<object, object> item);

-            void System.Collections.Generic.IDictionary<System.Object,System.Object>.Add(object key, object value);

-            bool System.Collections.Generic.IDictionary<System.Object,System.Object>.ContainsKey(object key);

-            bool System.Collections.Generic.IDictionary<System.Object,System.Object>.Remove(object key);

-            bool System.Collections.Generic.IDictionary<System.Object,System.Object>.TryGetValue(object key, out object value);

-            IEnumerator<KeyValuePair<object, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.Object,System.Object>>.GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-        }
-        public class QueryCollection : IEnumerable, IEnumerable<KeyValuePair<string, StringValues>>, IQueryCollection {
 {
-            public static readonly QueryCollection Empty;

-            public QueryCollection();

-            public QueryCollection(QueryCollection store);

-            public QueryCollection(Dictionary<string, StringValues> store);

-            public QueryCollection(int capacity);

-            public int Count { get; }

-            public ICollection<string> Keys { get; }

-            public StringValues this[string key] { get; }

-            public bool ContainsKey(string key);

-            public QueryCollection.Enumerator GetEnumerator();

-            IEnumerator<KeyValuePair<string, StringValues>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,Microsoft.Extensions.Primitives.StringValues>>.GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-            public bool TryGetValue(string key, out StringValues value);

-            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, StringValues>> {
 {
-                public KeyValuePair<string, StringValues> Current { get; }

-                object System.Collections.IEnumerator.Current { get; }

-                public void Dispose();

-                public bool MoveNext();

-                void System.Collections.IEnumerator.Reset();

-            }
-        }
-        public class RequestCookieCollection : IEnumerable, IEnumerable<KeyValuePair<string, string>>, IRequestCookieCollection {
 {
-            public static readonly RequestCookieCollection Empty;

-            public RequestCookieCollection();

-            public RequestCookieCollection(Dictionary<string, string> store);

-            public RequestCookieCollection(int capacity);

-            public int Count { get; }

-            public ICollection<string> Keys { get; }

-            public string this[string key] { get; }

-            public bool ContainsKey(string key);

-            public RequestCookieCollection.Enumerator GetEnumerator();

-            public static RequestCookieCollection Parse(IList<string> values);

-            IEnumerator<KeyValuePair<string, string>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.String>>.GetEnumerator();

-            IEnumerator System.Collections.IEnumerable.GetEnumerator();

-            public bool TryGetValue(string key, out string value);

-            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<KeyValuePair<string, string>> {
 {
-                public KeyValuePair<string, string> Current { get; }

-                object System.Collections.IEnumerator.Current { get; }

-                public void Dispose();

-                public bool MoveNext();

-                public void Reset();

-            }
-        }
-        public class ResponseCookies : IResponseCookies {
 {
-            public ResponseCookies(IHeaderDictionary headers, ObjectPool<StringBuilder> builderPool);

-            public void Append(string key, string value);

-            public void Append(string key, string value, CookieOptions options);

-            public void Delete(string key);

-            public void Delete(string key, CookieOptions options);

-        }
-    }
 }
```

