# Microsoft.AspNetCore.Identity.EntityFrameworkCore

``` diff
 {
     namespace Microsoft.AspNetCore.Identity.EntityFrameworkCore {
         public abstract class IdentityDbContext<TUser, TRole, TKey, TUserClaim, TUserRole, TUserLogin, TRoleClaim, TUserToken> : IdentityUserContext<TUser, TKey, TUserClaim, TUserLogin, TUserToken> where TUser : IdentityUser<TKey> where TRole : IdentityRole<TKey> where TKey : IEquatable<TKey> where TUserClaim : IdentityUserClaim<TKey> where TUserRole : IdentityUserRole<TKey> where TUserLogin : IdentityUserLogin<TKey> where TRoleClaim : IdentityRoleClaim<TKey> where TUserToken : IdentityUserToken<TKey> {
-            public DbSet<TRoleClaim> RoleClaims { get; set; }
+            public virtual DbSet<TRoleClaim> RoleClaims { get; set; }
-            public DbSet<TRole> Roles { get; set; }
+            public virtual DbSet<TRole> Roles { get; set; }
-            public DbSet<TUserRole> UserRoles { get; set; }
+            public virtual DbSet<TUserRole> UserRoles { get; set; }
         }
         public abstract class IdentityUserContext<TUser, TKey, TUserClaim, TUserLogin, TUserToken> : DbContext where TUser : IdentityUser<TKey> where TKey : IEquatable<TKey> where TUserClaim : IdentityUserClaim<TKey> where TUserLogin : IdentityUserLogin<TKey> where TUserToken : IdentityUserToken<TKey> {
-            public DbSet<TUserClaim> UserClaims { get; set; }
+            public virtual DbSet<TUserClaim> UserClaims { get; set; }
-            public DbSet<TUserLogin> UserLogins { get; set; }
+            public virtual DbSet<TUserLogin> UserLogins { get; set; }
-            public DbSet<TUser> Users { get; set; }
+            public virtual DbSet<TUser> Users { get; set; }
-            public DbSet<TUserToken> UserTokens { get; set; }
+            public virtual DbSet<TUserToken> UserTokens { get; set; }
         }
         public class RoleStore<TRole, TContext, TKey, TUserRole, TRoleClaim> : IDisposable, IQueryableRoleStore<TRole>, IRoleClaimStore<TRole>, IRoleStore<TRole> where TRole : IdentityRole<TKey> where TContext : DbContext where TKey : IEquatable<TKey> where TUserRole : IdentityUserRole<TKey>, new() where TRoleClaim : IdentityRoleClaim<TKey>, new() {
-            public TContext Context { get; private set; }
+            public virtual TContext Context { get; private set; }
         }
         public class UserOnlyStore<TUser, TContext, TKey, TUserClaim, TUserLogin, TUserToken> : UserStoreBase<TUser, TKey, TUserClaim, TUserLogin, TUserToken>, IDisposable, IProtectedUserStore<TUser>, IQueryableUserStore<TUser>, IUserAuthenticationTokenStore<TUser>, IUserAuthenticatorKeyStore<TUser>, IUserClaimStore<TUser>, IUserEmailStore<TUser>, IUserLockoutStore<TUser>, IUserLoginStore<TUser>, IUserPasswordStore<TUser>, IUserPhoneNumberStore<TUser>, IUserSecurityStampStore<TUser>, IUserStore<TUser>, IUserTwoFactorRecoveryCodeStore<TUser>, IUserTwoFactorStore<TUser> where TUser : IdentityUser<TKey> where TContext : DbContext where TKey : IEquatable<TKey> where TUserClaim : IdentityUserClaim<TKey>, new() where TUserLogin : IdentityUserLogin<TKey>, new() where TUserToken : IdentityUserToken<TKey>, new() {
-            public TContext Context { get; private set; }
+            public virtual TContext Context { get; private set; }
         }
         public class UserStore<TUser, TRole, TContext, TKey, TUserClaim, TUserRole, TUserLogin, TUserToken, TRoleClaim> : UserStoreBase<TUser, TRole, TKey, TUserClaim, TUserRole, TUserLogin, TUserToken, TRoleClaim>, IDisposable, IProtectedUserStore<TUser>, IUserStore<TUser> where TUser : IdentityUser<TKey> where TRole : IdentityRole<TKey> where TContext : DbContext where TKey : IEquatable<TKey> where TUserClaim : IdentityUserClaim<TKey>, new() where TUserRole : IdentityUserRole<TKey>, new() where TUserLogin : IdentityUserLogin<TKey>, new() where TUserToken : IdentityUserToken<TKey>, new() where TRoleClaim : IdentityRoleClaim<TKey>, new() {
-            public TContext Context { get; private set; }
+            public virtual TContext Context { get; private set; }
         }
     }
 }
```

