# Microsoft.AspNetCore.Mvc.RazorPages

``` diff
 {
+    namespace Microsoft.AspNetCore.Builder {
+        public sealed class PageActionEndpointConventionBuilder : IEndpointConventionBuilder {
+            public void Add(Action<EndpointBuilder> convention);
+        }
+        public static class RazorPagesEndpointRouteBuilderExtensions {
+            public static void MapDynamicPageRoute<TTransformer>(this IEndpointRouteBuilder endpoints, string pattern) where TTransformer : DynamicRouteValueTransformer;
+            public static IEndpointConventionBuilder MapFallbackToAreaPage(this IEndpointRouteBuilder endpoints, string page, string area);
+            public static IEndpointConventionBuilder MapFallbackToAreaPage(this IEndpointRouteBuilder endpoints, string pattern, string page, string area);
+            public static IEndpointConventionBuilder MapFallbackToPage(this IEndpointRouteBuilder endpoints, string page);
+            public static IEndpointConventionBuilder MapFallbackToPage(this IEndpointRouteBuilder endpoints, string pattern, string page);
+            public static PageActionEndpointConventionBuilder MapRazorPages(this IEndpointRouteBuilder endpoints);
+        }
+    }
     namespace Microsoft.AspNetCore.Mvc.ApplicationModels {
+        public interface IPageApplicationModelPartsProvider {
+            PageHandlerModel CreateHandlerModel(MethodInfo method);
+            PageParameterModel CreateParameterModel(ParameterInfo parameter);
+            PagePropertyModel CreatePropertyModel(PropertyInfo property);
+            bool IsHandler(MethodInfo methodInfo);
+        }
         public class PageApplicationModel {
+            public IList<object> EndpointMetadata { get; }
         }
         public class PageParameterModel : ParameterModelBase, IBindingModel, ICommonModel, IPropertyModel {
+            IReadOnlyList<object> Microsoft.AspNetCore.Mvc.ApplicationModels.ICommonModel.Attributes { get; }
+            IDictionary<object, object> Microsoft.AspNetCore.Mvc.ApplicationModels.IPropertyModel.Properties { get; }
-            IReadOnlyList<object> Microsoft.AspNetCore.Mvc.ApplicationModels.ICommonModel.get_Attributes();
+            get;
-            IDictionary<object, object> Microsoft.AspNetCore.Mvc.ApplicationModels.IPropertyModel.get_Properties();
+            get;
         }
         public class PagePropertyModel : ParameterModelBase, ICommonModel, IPropertyModel {
+            IReadOnlyList<object> Microsoft.AspNetCore.Mvc.ApplicationModels.ICommonModel.Attributes { get; }
+            IDictionary<object, object> Microsoft.AspNetCore.Mvc.ApplicationModels.IPropertyModel.Properties { get; }
-            IReadOnlyList<object> Microsoft.AspNetCore.Mvc.ApplicationModels.ICommonModel.get_Attributes();
+            get;
-            IDictionary<object, object> Microsoft.AspNetCore.Mvc.ApplicationModels.IPropertyModel.get_Properties();
+            get;
         }
+        public sealed class PageRouteMetadata {
+            public PageRouteMetadata(string pageRoute, string routeTemplate);
+            public string PageRoute { get; }
+            public string RouteTemplate { get; }
+        }
         public class PageRouteModel {
+            public IOutboundParameterTransformer RouteParameterTransformer { get; set; }
         }
     }
+    namespace Microsoft.AspNetCore.Mvc.Diagnostics {
+        public sealed class AfterHandlerMethodEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterHandlerMethod";
+            public AfterHandlerMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> arguments, HandlerMethodDescriptor handlerMethodDescriptor, object instance, IActionResult result);
+            public ActionContext ActionContext { get; }
+            public IReadOnlyDictionary<string, object> Arguments { get; }
+            protected override int Count { get; }
+            public HandlerMethodDescriptor HandlerMethodDescriptor { get; }
+            public object Instance { get; }
+            public IActionResult Result { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterPageFilterOnPageHandlerExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerExecuted";
+            public AfterPageFilterOnPageHandlerExecutedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutedContext handlerExecutedContext, IPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IPageFilter Filter { get; }
+            public PageHandlerExecutedContext HandlerExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterPageFilterOnPageHandlerExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerExecuting";
+            public AfterPageFilterOnPageHandlerExecutingEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutingContext handlerExecutingContext, IPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IPageFilter Filter { get; }
+            public PageHandlerExecutingContext HandlerExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterPageFilterOnPageHandlerExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerExecution";
+            public AfterPageFilterOnPageHandlerExecutionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutedContext handlerExecutedContext, IAsyncPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IAsyncPageFilter Filter { get; }
+            public PageHandlerExecutedContext HandlerExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterPageFilterOnPageHandlerSelectedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerSelected";
+            public AfterPageFilterOnPageHandlerSelectedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IPageFilter Filter { get; }
+            public PageHandlerSelectedContext HandlerSelectedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class AfterPageFilterOnPageHandlerSelectionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.AfterOnPageHandlerSelection";
+            public AfterPageFilterOnPageHandlerSelectionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IAsyncPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IAsyncPageFilter Filter { get; }
+            public PageHandlerSelectedContext HandlerSelectedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforeHandlerMethodEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeHandlerMethod";
+            public BeforeHandlerMethodEventData(ActionContext actionContext, IReadOnlyDictionary<string, object> arguments, HandlerMethodDescriptor handlerMethodDescriptor, object instance);
+            public ActionContext ActionContext { get; }
+            public IReadOnlyDictionary<string, object> Arguments { get; }
+            protected override int Count { get; }
+            public HandlerMethodDescriptor HandlerMethodDescriptor { get; }
+            public object Instance { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforePageFilterOnPageHandlerExecutedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerExecuted";
+            public BeforePageFilterOnPageHandlerExecutedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutedContext handlerExecutedContext, IPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IPageFilter Filter { get; }
+            public PageHandlerExecutedContext HandlerExecutedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforePageFilterOnPageHandlerExecutingEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerExecuting";
+            public BeforePageFilterOnPageHandlerExecutingEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutingContext handlerExecutingContext, IPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IPageFilter Filter { get; }
+            public PageHandlerExecutingContext HandlerExecutingContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforePageFilterOnPageHandlerExecutionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerExecution";
+            public BeforePageFilterOnPageHandlerExecutionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerExecutingContext handlerExecutionContext, IAsyncPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IAsyncPageFilter Filter { get; }
+            public PageHandlerExecutingContext HandlerExecutionContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforePageFilterOnPageHandlerSelectedEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerSelected";
+            public BeforePageFilterOnPageHandlerSelectedEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IPageFilter Filter { get; }
+            public PageHandlerSelectedContext HandlerSelectedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+        public sealed class BeforePageFilterOnPageHandlerSelectionEventData : EventData {
+            public const string EventName = "Microsoft.AspNetCore.Mvc.BeforeOnPageHandlerSelection";
+            public BeforePageFilterOnPageHandlerSelectionEventData(CompiledPageActionDescriptor actionDescriptor, PageHandlerSelectedContext handlerSelectedContext, IAsyncPageFilter filter);
+            public CompiledPageActionDescriptor ActionDescriptor { get; }
+            protected override int Count { get; }
+            public IAsyncPageFilter Filter { get; }
+            public PageHandlerSelectedContext HandlerSelectedContext { get; }
+            protected override KeyValuePair<string, object> this[int index] { get; }
+        }
+    }
-    namespace Microsoft.AspNetCore.Mvc.Internal {
 {
-        public static class MvcRazorPagesDiagnosticSourceExtensions {
 {
-            public static void AfterHandlerMethod(this DiagnosticSource diagnosticSource, ActionContext actionContext, HandlerMethodDescriptor handlerMethodDescriptor, IDictionary<string, object> arguments, object instance, IActionResult result);

-            public static void AfterOnPageHandlerExecuted(this DiagnosticSource diagnosticSource, PageHandlerExecutedContext handlerExecutedContext, IPageFilter filter);

-            public static void AfterOnPageHandlerExecuting(this DiagnosticSource diagnosticSource, PageHandlerExecutingContext handlerExecutingContext, IPageFilter filter);

-            public static void AfterOnPageHandlerExecution(this DiagnosticSource diagnosticSource, PageHandlerExecutedContext handlerExecutedContext, IAsyncPageFilter filter);

-            public static void AfterOnPageHandlerSelected(this DiagnosticSource diagnosticSource, PageHandlerSelectedContext handlerSelectedContext, IPageFilter filter);

-            public static void AfterOnPageHandlerSelection(this DiagnosticSource diagnosticSource, PageHandlerSelectedContext handlerSelectedContext, IAsyncPageFilter filter);

-            public static void BeforeHandlerMethod(this DiagnosticSource diagnosticSource, ActionContext actionContext, HandlerMethodDescriptor handlerMethodDescriptor, IDictionary<string, object> arguments, object instance);

-            public static void BeforeOnPageHandlerExecuted(this DiagnosticSource diagnosticSource, PageHandlerExecutedContext handlerExecutedContext, IPageFilter filter);

-            public static void BeforeOnPageHandlerExecuting(this DiagnosticSource diagnosticSource, PageHandlerExecutingContext handlerExecutingContext, IPageFilter filter);

-            public static void BeforeOnPageHandlerExecution(this DiagnosticSource diagnosticSource, PageHandlerExecutingContext handlerExecutionContext, IAsyncPageFilter filter);

-            public static void BeforeOnPageHandlerSelected(this DiagnosticSource diagnosticSource, PageHandlerSelectedContext handlerSelectedContext, IPageFilter filter);

-            public static void BeforeOnPageHandlerSelection(this DiagnosticSource diagnosticSource, PageHandlerSelectedContext handlerSelectedContext, IAsyncPageFilter filter);

-        }
-    }
     namespace Microsoft.AspNetCore.Mvc.RazorPages {
         public class CompiledPageActionDescriptor : PageActionDescriptor {
+            public Endpoint Endpoint { get; set; }
         }
         public class RazorPagesOptions : IEnumerable, IEnumerable<ICompatibilitySwitch> {
-            public bool AllowAreas { get; set; }

-            public bool AllowDefaultHandlingForOptionsRequests { get; set; }

-            public bool AllowMappingHeadRequestsToGetHandler { get; set; }

         }
     }
     namespace Microsoft.AspNetCore.Mvc.RazorPages.Infrastructure {
-        public class DefaultPageActivatorProvider : IPageActivatorProvider {
 {
-            public DefaultPageActivatorProvider();

-            public virtual Func<PageContext, ViewContext, object> CreateActivator(CompiledPageActionDescriptor actionDescriptor);

-            public virtual Action<PageContext, ViewContext, object> CreateReleaser(CompiledPageActionDescriptor actionDescriptor);

-        }
-        public class DefaultPageFactoryProvider : IPageFactoryProvider {
 {
-            public DefaultPageFactoryProvider(IPageActivatorProvider pageActivator, IModelMetadataProvider metadataProvider, IUrlHelperFactory urlHelperFactory, IJsonHelper jsonHelper, DiagnosticSource diagnosticSource, HtmlEncoder htmlEncoder, IModelExpressionProvider modelExpressionProvider);

-            public virtual Action<PageContext, ViewContext, object> CreatePageDisposer(CompiledPageActionDescriptor descriptor);

-            public virtual Func<PageContext, ViewContext, object> CreatePageFactory(CompiledPageActionDescriptor actionDescriptor);

-        }
-        public class DefaultPageHandlerMethodSelector : IPageHandlerMethodSelector {
 {
-            public DefaultPageHandlerMethodSelector();

-            public DefaultPageHandlerMethodSelector(IOptions<RazorPagesOptions> options);

-            public HandlerMethodDescriptor Select(PageContext context);

-        }
-        public class DefaultPageModelActivatorProvider : IPageModelActivatorProvider {
 {
-            public DefaultPageModelActivatorProvider();

-            public virtual Func<PageContext, object> CreateActivator(CompiledPageActionDescriptor actionDescriptor);

-            public virtual Action<PageContext, object> CreateReleaser(CompiledPageActionDescriptor actionDescriptor);

-        }
-        public class DefaultPageModelFactoryProvider : IPageModelFactoryProvider {
 {
-            public DefaultPageModelFactoryProvider(IPageModelActivatorProvider modelActivator);

-            public virtual Action<PageContext, object> CreateModelDisposer(CompiledPageActionDescriptor descriptor);

-            public virtual Func<PageContext, object> CreateModelFactory(CompiledPageActionDescriptor descriptor);

-        }
-        public abstract class PageArgumentBinder {
 {
-            protected PageArgumentBinder();

-            protected abstract Task<ModelBindingResult> BindAsync(PageContext context, object value, string name, Type type);

-            public Task<object> BindModelAsync(PageContext context, Type type, object @default, string name);

-            public Task<TModel> BindModelAsync<TModel>(PageContext context, string name);

-            public Task<TModel> BindModelAsync<TModel>(PageContext context, TModel @default, string name);

-            public Task<bool> TryUpdateModelAsync<TModel>(PageContext context, TModel value);

-            public Task<bool> TryUpdateModelAsync<TModel>(PageContext context, TModel value, string name);

-        }
-        public static class PageDirectiveFeature {
 {
-            public static bool TryGetPageDirective(ILogger logger, RazorProjectItem projectItem, out string template);

-        }
+        public abstract class PageLoader : IPageLoader {
+            protected PageLoader();
+            public abstract Task<CompiledPageActionDescriptor> LoadAsync(PageActionDescriptor actionDescriptor);
+            CompiledPageActionDescriptor Microsoft.AspNetCore.Mvc.RazorPages.Infrastructure.IPageLoader.Load(PageActionDescriptor actionDescriptor);
+        }
         public class PageResultExecutor : ViewExecutor {
+            public PageResultExecutor(IHttpResponseStreamWriterFactory writerFactory, ICompositeViewEngine compositeViewEngine, IRazorViewEngine razorViewEngine, IRazorPageActivator razorPageActivator, DiagnosticListener diagnosticListener, HtmlEncoder htmlEncoder);
-            public PageResultExecutor(IHttpResponseStreamWriterFactory writerFactory, ICompositeViewEngine compositeViewEngine, IRazorViewEngine razorViewEngine, IRazorPageActivator razorPageActivator, DiagnosticSource diagnosticSource, HtmlEncoder htmlEncoder);

         }
         public class RazorPageAdapter : IModelTypeProvider, IRazorPage {
-            public RazorPageAdapter(RazorPageBase page);

         }
     }
-    namespace Microsoft.AspNetCore.Mvc.RazorPages.Internal {
 {
-        public class AuthorizationPageApplicationModelProvider : IPageApplicationModelProvider {
 {
-            public AuthorizationPageApplicationModelProvider(IAuthorizationPolicyProvider policyProvider);

-            public int Order { get; }

-            public void OnProvidersExecuted(PageApplicationModelProviderContext context);

-            public void OnProvidersExecuting(PageApplicationModelProviderContext context);

-        }
-        public static class CompiledPageActionDescriptorBuilder {
 {
-            public static CompiledPageActionDescriptor Build(PageApplicationModel applicationModel, FilterCollection globalFilters);

-        }
-        public class CompiledPageRouteModelProvider : IPageRouteModelProvider {
 {
-            public CompiledPageRouteModelProvider(ApplicationPartManager applicationManager, IOptions<RazorPagesOptions> pagesOptionsAccessor, RazorProjectEngine razorProjectEngine, ILogger<CompiledPageRouteModelProvider> logger);

-            public int Order { get; }

-            protected virtual ViewsFeature GetViewFeature(ApplicationPartManager applicationManager);

-            public void OnProvidersExecuted(PageRouteModelProviderContext context);

-            public void OnProvidersExecuting(PageRouteModelProviderContext context);

-        }
-        public class DefaultPageArgumentBinder : PageArgumentBinder {
 {
-            public DefaultPageArgumentBinder(ParameterBinder binder);

-            protected override Task<ModelBindingResult> BindAsync(PageContext pageContext, object value, string name, Type type);

-        }
-        public class DefaultPageLoader : IPageLoader {
 {
-            public DefaultPageLoader(IEnumerable<IPageApplicationModelProvider> applicationModelProviders, IViewCompilerProvider viewCompilerProvider, IOptions<RazorPagesOptions> pageOptions, IOptions<MvcOptions> mvcOptions);

-            public CompiledPageActionDescriptor Load(PageActionDescriptor actionDescriptor);

-        }
-        public static class ExecutorFactory {
 {
-            public static PageHandlerExecutorDelegate CreateExecutor(HandlerMethodDescriptor handlerDescriptor);

-        }
-        public class PageActionDescriptorChangeProvider : IActionDescriptorChangeProvider {
 {
-            public PageActionDescriptorChangeProvider(RazorTemplateEngine templateEngine, IRazorViewEngineFileProviderAccessor fileProviderAccessor, IOptions<RazorPagesOptions> razorPagesOptions, IOptions<RazorViewEngineOptions> razorViewEngineOptions);

-            public IChangeToken GetChangeToken();

-        }
-        public class PageActionInvoker : ResourceInvoker, IActionInvoker {
 {
-            public PageActionInvoker(IPageHandlerMethodSelector handlerMethodSelector, DiagnosticSource diagnosticSource, ILogger logger, IActionResultTypeMapper mapper, PageContext pageContext, IFilterMetadata[] filterMetadata, PageActionInvokerCacheEntry cacheEntry, ParameterBinder parameterBinder, ITempDataDictionaryFactory tempDataFactory, HtmlHelperOptions htmlHelperOptions);

-            protected override Task InvokeInnerFilterAsync();

-            protected override Task InvokeResultAsync(IActionResult result);

-            protected override void ReleaseResources();

-        }
-        public class PageActionInvokerCacheEntry {
 {
-            public PageActionInvokerCacheEntry(CompiledPageActionDescriptor actionDescriptor, Func<IModelMetadataProvider, ModelStateDictionary, ViewDataDictionary> viewDataFactory, Func<PageContext, ViewContext, object> pageFactory, Action<PageContext, ViewContext, object> releasePage, Func<PageContext, object> modelFactory, Action<PageContext, object> releaseModel, Func<PageContext, object, Task> propertyBinder, PageHandlerExecutorDelegate[] handlerExecutors, PageHandlerBinderDelegate[] handlerBinders, IReadOnlyList<Func<IRazorPage>> viewStartFactories, FilterItem[] cacheableFilters);

-            public CompiledPageActionDescriptor ActionDescriptor { get; }

-            public FilterItem[] CacheableFilters { get; }

-            public PageHandlerBinderDelegate[] HandlerBinders { get; }

-            public PageHandlerExecutorDelegate[] HandlerExecutors { get; }

-            public Func<PageContext, object> ModelFactory { get; }

-            public Func<PageContext, ViewContext, object> PageFactory { get; }

-            public Func<PageContext, object, Task> PropertyBinder { get; }

-            public Action<PageContext, object> ReleaseModel { get; }

-            public Action<PageContext, ViewContext, object> ReleasePage { get; }

-            public Func<IModelMetadataProvider, ModelStateDictionary, ViewDataDictionary> ViewDataFactory { get; }

-            public IReadOnlyList<Func<IRazorPage>> ViewStartFactories { get; }

-        }
-        public class PageActionInvokerProvider : IActionInvokerProvider {
 {
-            public PageActionInvokerProvider(IPageLoader loader, IPageFactoryProvider pageFactoryProvider, IPageModelFactoryProvider modelFactoryProvider, IRazorPageFactoryProvider razorPageFactoryProvider, IActionDescriptorCollectionProvider collectionProvider, IEnumerable<IFilterProvider> filterProviders, ParameterBinder parameterBinder, IModelMetadataProvider modelMetadataProvider, IModelBinderFactory modelBinderFactory, ITempDataDictionaryFactory tempDataFactory, IOptions<MvcOptions> mvcOptions, IOptions<HtmlHelperOptions> htmlHelperOptions, IPageHandlerMethodSelector selector, RazorProjectFileSystem razorFileSystem, DiagnosticSource diagnosticSource, ILoggerFactory loggerFactory, IActionResultTypeMapper mapper);

-            public int Order { get; }

-            public void OnProvidersExecuted(ActionInvokerProviderContext context);

-            public void OnProvidersExecuting(ActionInvokerProviderContext context);

-        }
-        public delegate Task PageHandlerBinderDelegate(PageContext pageContext, IDictionary<string, object> arguments);

-        public delegate Task<IActionResult> PageHandlerExecutorDelegate(object handler, object[] arguments);

-        public class PageHandlerPageFilter : IAsyncPageFilter, IFilterMetadata, IOrderedFilter {
 {
-            public PageHandlerPageFilter();

-            public int Order { get; }

-            public Task OnPageHandlerExecutionAsync(PageHandlerExecutingContext context, PageHandlerExecutionDelegate next);

-            public Task OnPageHandlerSelectionAsync(PageHandlerSelectedContext context);

-        }
-        public class PageHandlerResultFilter : IAsyncResultFilter, IFilterMetadata, IOrderedFilter {
 {
-            public PageHandlerResultFilter();

-            public int Order { get; }

-            public Task OnResultExecutionAsync(ResultExecutingContext context, ResultExecutionDelegate next);

-        }
-        public class RazorPagesRazorViewEngineOptionsSetup : IConfigureOptions<RazorViewEngineOptions> {
 {
-            public RazorPagesRazorViewEngineOptionsSetup(IOptions<RazorPagesOptions> pagesOptions);

-            public void Configure(RazorViewEngineOptions options);

-        }
-        public class RazorProjectPageRouteModelProvider : IPageRouteModelProvider {
 {
-            public RazorProjectPageRouteModelProvider(RazorProjectFileSystem razorFileSystem, IOptions<RazorPagesOptions> pagesOptionsAccessor, ILoggerFactory loggerFactory);

-            public int Order { get; }

-            public void OnProvidersExecuted(PageRouteModelProviderContext context);

-            public void OnProvidersExecuting(PageRouteModelProviderContext context);

-        }
-        public class ResponseCacheFilter : IFilterMetadata, IPageFilter, IResponseCacheFilter {
 {
-            public ResponseCacheFilter(CacheProfile cacheProfile, ILoggerFactory loggerFactory);

-            public int Duration { get; set; }

-            public ResponseCacheLocation Location { get; set; }

-            public bool NoStore { get; set; }

-            public string VaryByHeader { get; set; }

-            public string[] VaryByQueryKeys { get; set; }

-            public void OnPageHandlerExecuted(PageHandlerExecutedContext context);

-            public void OnPageHandlerExecuting(PageHandlerExecutingContext context);

-            public void OnPageHandlerSelected(PageHandlerSelectedContext context);

-        }
-        public class ResponseCacheFilterApplicationModelProvider : IPageApplicationModelProvider {
 {
-            public ResponseCacheFilterApplicationModelProvider(IOptions<MvcOptions> mvcOptionsAccessor, ILoggerFactory loggerFactory);

-            public int Order { get; }

-            public void OnProvidersExecuted(PageApplicationModelProviderContext context);

-            public void OnProvidersExecuting(PageApplicationModelProviderContext context);

-        }
-    }
 }
```

