# Microsoft.Extensions.Hosting.Systemd

``` diff
 {
+    namespace Microsoft.Extensions.Hosting {
+        public static class SystemdHostBuilderExtensions {
+            public static IHostBuilder UseSystemd(this IHostBuilder hostBuilder);
+        }
+    }
+    namespace Microsoft.Extensions.Hosting.Systemd {
+        public interface ISystemdNotifier {
+            bool IsEnabled { get; }
+            void Notify(ServiceState state);
+        }
+        public struct ServiceState {
+            public static readonly ServiceState Ready;
+            public static readonly ServiceState Stopping;
+            public ServiceState(string state);
+            public override string ToString();
+        }
+        public static class SystemdHelpers {
+            public static bool IsSystemdService();
+        }
+        public class SystemdLifetime : IDisposable, IHostLifetime {
+            public SystemdLifetime(IHostEnvironment environment, IHostApplicationLifetime applicationLifetime, ISystemdNotifier systemdNotifier, ILoggerFactory loggerFactory);
+            public void Dispose();
+            public Task StopAsync(CancellationToken cancellationToken);
+            public Task WaitForStartAsync(CancellationToken cancellationToken);
+        }
+        public class SystemdNotifier : ISystemdNotifier {
+            public SystemdNotifier();
+            public bool IsEnabled { get; }
+            public void Notify(ServiceState state);
+        }
+    }
+}
```

