# Microsoft.Extensions.Hosting

``` diff
 {
     namespace Microsoft.Extensions.Hosting {
+        public static class Host {
+            public static IHostBuilder CreateDefaultBuilder();
+            public static IHostBuilder CreateDefaultBuilder(string[] args);
+        }
         public class HostBuilder : IHostBuilder {
+            public IHostBuilder UseServiceProviderFactory<TContainerBuilder>(Func<HostBuilderContext, IServiceProviderFactory<TContainerBuilder>> factory);
         }
         public static class HostingHostBuilderExtensions {
+            public static Task RunConsoleAsync(this IHostBuilder hostBuilder, Action<ConsoleLifetimeOptions> configureOptions, CancellationToken cancellationToken = default(CancellationToken));
+            public static IHostBuilder UseConsoleLifetime(this IHostBuilder hostBuilder, Action<ConsoleLifetimeOptions> configureOptions);
+            public static IHostBuilder UseDefaultServiceProvider(this IHostBuilder hostBuilder, Action<ServiceProviderOptions> configure);
+            public static IHostBuilder UseDefaultServiceProvider(this IHostBuilder hostBuilder, Action<HostBuilderContext, ServiceProviderOptions> configure);
         }
     }
     namespace Microsoft.Extensions.Hosting.Internal {
-        public class ApplicationLifetime : IApplicationLifetime
+        public class ApplicationLifetime : IApplicationLifetime, IHostApplicationLifetime
         public class ConsoleLifetime : IDisposable, IHostLifetime {
+            public ConsoleLifetime(IOptions<ConsoleLifetimeOptions> options, IHostEnvironment environment, IHostApplicationLifetime applicationLifetime, IOptions<HostOptions> hostOptions);
+            public ConsoleLifetime(IOptions<ConsoleLifetimeOptions> options, IHostEnvironment environment, IHostApplicationLifetime applicationLifetime, IOptions<HostOptions> hostOptions, ILoggerFactory loggerFactory);
-            public ConsoleLifetime(IOptions<ConsoleLifetimeOptions> options, IHostingEnvironment environment, IApplicationLifetime applicationLifetime);

         }
-        public class HostingEnvironment : IHostingEnvironment
+        public class HostingEnvironment : IHostEnvironment, IHostingEnvironment
     }
 }
```

