# Microsoft.Extensions.Logging.AzureAppServices

``` diff
 {
     namespace Microsoft.Extensions.Logging {
         public static class AzureAppServicesLoggerFactoryExtensions {
-            public static ILoggerFactory AddAzureWebAppDiagnostics(this ILoggerFactory factory);

-            public static ILoggerFactory AddAzureWebAppDiagnostics(this ILoggerFactory factory, AzureAppServicesDiagnosticsSettings settings);

         }
     }
     namespace Microsoft.Extensions.Logging.AzureAppServices {
-        public class AzureAppServicesDiagnosticsSettings {
 {
-            public AzureAppServicesDiagnosticsSettings();

-            public int BackgroundQueueSize { get; set; }

-            public int BlobBatchSize { get; set; }

-            public TimeSpan BlobCommitPeriod { get; set; }

-            public string BlobName { get; set; }

-            public TimeSpan? FileFlushPeriod { get; set; }

-            public int FileSizeLimit { get; set; }

-            public string OutputTemplate { get; set; }

-            public int RetainedFileCountLimit { get; set; }

-        }
+        public class BatchingLoggerOptions {
+            public BatchingLoggerOptions();
+            public int? BackgroundQueueSize { get; set; }
+            public int? BatchSize { get; set; }
+            public TimeSpan FlushPeriod { get; set; }
+            public bool IncludeScopes { get; set; }
+            public bool IsEnabled { get; set; }
+        }
+        public abstract class BatchingLoggerProvider : IDisposable, ILoggerProvider, ISupportExternalScope {
+            public bool IsEnabled { get; private set; }
+            public ILogger CreateLogger(string categoryName);
+            public void Dispose();
+            protected virtual Task IntervalAsync(TimeSpan interval, CancellationToken cancellationToken);
+            void Microsoft.Extensions.Logging.ISupportExternalScope.SetScopeProvider(IExternalScopeProvider scopeProvider);
+        }
+        public class BlobLoggerProvider : BatchingLoggerProvider {
+            public BlobLoggerProvider(IOptionsMonitor<AzureBlobLoggerOptions> options);
+        }
+        public class FileLoggerProvider : BatchingLoggerProvider {
+            public FileLoggerProvider(IOptionsMonitor<AzureFileLoggerOptions> options);
+        }
     }
-    namespace Microsoft.Extensions.Logging.AzureAppServices.Internal {
 {
-        public class BatchingLogger : ILogger {
 {
-            public BatchingLogger(BatchingLoggerProvider loggerProvider, string categoryName);

-            public IDisposable BeginScope<TState>(TState state);

-            public bool IsEnabled(LogLevel logLevel);

-            public void Log<TState>(LogLevel logLevel, EventId eventId, TState state, Exception exception, Func<TState, Exception, string> formatter);

-            public void Log<TState>(DateTimeOffset timestamp, LogLevel logLevel, EventId eventId, TState state, Exception exception, Func<TState, Exception, string> formatter);

-        }
-        public class BatchingLoggerOptions {
 {
-            public BatchingLoggerOptions();

-            public int? BackgroundQueueSize { get; set; }

-            public int? BatchSize { get; set; }

-            public TimeSpan FlushPeriod { get; set; }

-            public bool IsEnabled { get; set; }

-        }
-        public abstract class BatchingLoggerProvider : IDisposable, ILoggerProvider {
 {
-            protected BatchingLoggerProvider(IOptionsMonitor<BatchingLoggerOptions> options);

-            public bool IsEnabled { get; private set; }

-            public ILogger CreateLogger(string categoryName);

-            public void Dispose();

-            protected virtual Task IntervalAsync(TimeSpan interval, CancellationToken cancellationToken);

-            protected abstract Task WriteMessagesAsync(IEnumerable<LogMessage> messages, CancellationToken token);

-        }
-        public class BatchLoggerConfigureOptions : IConfigureOptions<BatchingLoggerOptions> {
 {
-            public BatchLoggerConfigureOptions(IConfiguration configuration, string isEnabledKey);

-            public void Configure(BatchingLoggerOptions options);

-        }
-        public class BlobAppendReferenceWrapper : ICloudAppendBlob {
 {
-            public BlobAppendReferenceWrapper(string containerUrl, string name, HttpClient client);

-            public Task AppendAsync(ArraySegment<byte> data, CancellationToken cancellationToken);

-        }
-        public class BlobLoggerConfigureOptions : BatchLoggerConfigureOptions, IConfigureOptions<AzureBlobLoggerOptions> {
 {
-            public BlobLoggerConfigureOptions(IConfiguration configuration, IWebAppContext context);

-            public void Configure(AzureBlobLoggerOptions options);

-        }
-        public class BlobLoggerProvider : BatchingLoggerProvider {
 {
-            public BlobLoggerProvider(IOptionsMonitor<AzureBlobLoggerOptions> options);

-            public BlobLoggerProvider(IOptionsMonitor<AzureBlobLoggerOptions> options, Func<string, ICloudAppendBlob> blobReferenceFactory);

-            protected override Task WriteMessagesAsync(IEnumerable<LogMessage> messages, CancellationToken cancellationToken);

-        }
-        public class ConfigurationBasedLevelSwitcher : IConfigureOptions<LoggerFilterOptions> {
 {
-            public ConfigurationBasedLevelSwitcher(IConfiguration configuration, Type provider, string levelKey);

-            public void Configure(LoggerFilterOptions options);

-        }
-        public class FileLoggerConfigureOptions : BatchLoggerConfigureOptions, IConfigureOptions<AzureFileLoggerOptions> {
 {
-            public FileLoggerConfigureOptions(IConfiguration configuration, IWebAppContext context);

-            public void Configure(AzureFileLoggerOptions options);

-        }
-        public class FileLoggerProvider : BatchingLoggerProvider {
 {
-            public FileLoggerProvider(IOptionsMonitor<AzureFileLoggerOptions> options);

-            public (int Year, int Month, int Day) GetGrouping(LogMessage message);

-            protected void RollFiles();

-            protected override Task WriteMessagesAsync(IEnumerable<LogMessage> messages, CancellationToken cancellationToken);

-        }
-        public interface ICloudAppendBlob {
 {
-            Task AppendAsync(ArraySegment<byte> data, CancellationToken cancellationToken);

-        }
-        public interface IWebAppContext {
 {
-            string HomeFolder { get; }

-            bool IsRunningInAzureWebApp { get; }

-            string SiteInstanceId { get; }

-            string SiteName { get; }

-        }
-        public struct LogMessage {
 {
-            public string Message { get; set; }

-            public DateTimeOffset Timestamp { get; set; }

-        }
-        public class SiteConfigurationProvider {
 {
-            public SiteConfigurationProvider();

-            public static IConfiguration GetAzureLoggingConfiguration(IWebAppContext context);

-        }
-        public class WebAppContext : IWebAppContext {
 {
-            public static WebAppContext Default { get; }

-            public string HomeFolder { get; }

-            public bool IsRunningInAzureWebApp { get; }

-            public string SiteInstanceId { get; }

-            public string SiteName { get; }

-        }
-    }
 }
```

