# Microsoft.JSInterop

``` diff
 {
+    namespace Microsoft.JSInterop {
+        public static class DotNetObjectReference {
+            public static DotNetObjectReference<TValue> Create<TValue>(TValue value) where TValue : class;
+        }
+        public sealed class DotNetObjectReference<TValue> : IDisposable, IDotNetObjectReference where TValue : class {
+            public TValue Value { get; }
+            public void Dispose();
+        }
+        public interface IJSInProcessRuntime : IJSRuntime {
+            T Invoke<T>(string identifier, params object[] args);
+        }
+        public interface IJSRuntime {
+            ValueTask<TValue> InvokeAsync<TValue>(string identifier, object[] args);
+            ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, object[] args);
+        }
+        public class JSException : Exception {
+            public JSException(string message);
+            public JSException(string message, Exception innerException);
+        }
+        public abstract class JSInProcessRuntime : JSRuntime, IJSInProcessRuntime, IJSRuntime {
+            protected JSInProcessRuntime();
+            public TValue Invoke<TValue>(string identifier, params object[] args);
+            protected abstract string InvokeJS(string identifier, string argsJson);
+        }
+        public static class JSInProcessRuntimeExtensions {
+            public static void InvokeVoid(this IJSInProcessRuntime jsRuntime, string identifier, params object[] args);
+        }
+        public sealed class JSInvokableAttribute : Attribute {
+            public JSInvokableAttribute();
+            public JSInvokableAttribute(string identifier);
+            public string Identifier { get; }
+        }
+        public abstract class JSRuntime : IJSRuntime {
+            protected JSRuntime();
+            protected TimeSpan? DefaultAsyncTimeout { get; set; }
+            protected internal JsonSerializerOptions JsonSerializerOptions { get; }
+            protected abstract void BeginInvokeJS(long taskId, string identifier, string argsJson);
+            protected internal abstract void EndInvokeDotNet(DotNetInvocationInfo invocationInfo, in DotNetInvocationResult invocationResult);
+            public ValueTask<TValue> InvokeAsync<TValue>(string identifier, object[] args);
+            public ValueTask<TValue> InvokeAsync<TValue>(string identifier, CancellationToken cancellationToken, object[] args);
+        }
+        public static class JSRuntimeExtensions {
+            public static ValueTask<TValue> InvokeAsync<TValue>(this IJSRuntime jsRuntime, string identifier, params object[] args);
+            public static ValueTask<TValue> InvokeAsync<TValue>(this IJSRuntime jsRuntime, string identifier, CancellationToken cancellationToken, params object[] args);
+            public static ValueTask<TValue> InvokeAsync<TValue>(this IJSRuntime jsRuntime, string identifier, TimeSpan timeout, params object[] args);
+            public static ValueTask InvokeVoidAsync(this IJSRuntime jsRuntime, string identifier, params object[] args);
+            public static ValueTask InvokeVoidAsync(this IJSRuntime jsRuntime, string identifier, CancellationToken cancellationToken, params object[] args);
+            public static ValueTask InvokeVoidAsync(this IJSRuntime jsRuntime, string identifier, TimeSpan timeout, params object[] args);
+        }
+    }
+    namespace Microsoft.JSInterop.Infrastructure {
+        public static class DotNetDispatcher {
+            public static void BeginInvokeDotNet(JSRuntime jsRuntime, DotNetInvocationInfo invocationInfo, string argsJson);
+            public static void EndInvokeJS(JSRuntime jsRuntime, string arguments);
+            public static string Invoke(JSRuntime jsRuntime, in DotNetInvocationInfo invocationInfo, string argsJson);
+        }
+        public readonly struct DotNetInvocationInfo {
+            public DotNetInvocationInfo(string assemblyName, string methodIdentifier, long dotNetObjectId, string callId);
+            public string AssemblyName { get; }
+            public string CallId { get; }
+            public long DotNetObjectId { get; }
+            public string MethodIdentifier { get; }
+        }
+        public readonly struct DotNetInvocationResult {
+            public DotNetInvocationResult(Exception exception, string errorKind);
+            public DotNetInvocationResult(object result);
+            public string ErrorKind { get; }
+            public Exception Exception { get; }
+            public object Result { get; }
+            public bool Success { get; }
+        }
+    }
+}
```

