# .NET Core 3.0.0 Preview 4 - April 18, 2019

.NET Core 3.0.0 Preview 4 is available for download and usage in your environment. This release includes .NET Core 3.0.0 Preview 4 and .NET Core SDK 3.0.100 Preview 4.

If Visual Studio is your preferred environment, you will need the lastest preview of Visual Studio 2019 (v16.1) to take full advantage of the .NET Core 3.0 Preview.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-300-preview-4)
* [Known issues](3.0.0-preview-known-issues.md)

## Blog Round up

* [.NET][dotnet-blog]
* [ASP.NET Core][aspnet-blog]
* [Entity Framework Core][ef-blog]

The .NET Core SDK 3.0.100 Preview 4 includes .NET Core 3.0 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.0.100 preview, the following command will show that you're running version `3.0.100-preview-011223` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #2603](https://github.com/dotnet/core/issues/2603) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     |  [Snap Install](3.0.0-preview3-download.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | - | -                                        | [Runtime][coreclr-symbols.zip] \| [Shared Framework][corefx-symbols.zip] \| [Setup][core-setup-symbols.zip] | - | [ASP.NET Core][aspnet-symbols.zip] |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. Note, the Hosting Bundle has an issue with the ASP.NET Core Module. If you would like to install the ASP.NET Core Module, please install the 3.0 Preview 4 [Hosting Bundle][dotnet-hosting-win.exe] and run the executable on a command line with the paramaters `OPT_NO_SHAREDFX=1 OPT_NO_RUNTIME=1`. Then install the appropriate .NET and ASP.NET runtimes.

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 3.0.0 Preview 4

* ASP.NET Core 3.0 Preview 4 ([bugs](https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+label%3A%223+-+Done%22+label%3Abug+milestone%3A3.0.0-preview4), [features](https://github.com/aspnet/AspNetCore/issues?utf8=%E2%9C%93&q=is%3Aissue+label%3A%223+-+Done%22+label%3Aenhancement+milestone%3A3.0.0-preview4))
* WinForms Chart control now available for .NET Core
* Improving .NET Core Version APIs
* Tiered Compilation (TC) Update
* HTTP/2 Support
* SDK Docker Images Contain PowerShell Core
* Better support Docker CPU (--cpus) Limits

A few changes have been made which could result in subtle changes of behavior in existing code.

* Change Auto charset to mean UTF-8 off-Windows. The new behavior is more appropriate for x-plan and it matches Mono now. [coreclr/23664](https://github.com/dotnet/coreclr/pull/23664).
* Correctly marshal struct return values on Unix. The new behavior more closely matches Mono. [coreclr/22041](https://github.com/dotnet/coreclr/pull/22041).
* Correctly marshal struct return values in member functions: [coreclr/23145](https://github.com/dotnet/coreclr/pull/23145).

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.0.0-preview4.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/98225b75-8507-490a-a040-335d1728fc0a/537c5d8f548241dfac27ee1f98551e67/dotnet-runtime-3.0.0-preview4-27615-11-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/79dafd9e-e037-4c49-8979-8add58ba3070/46259d42ab44f7c315b97186cfd375c1/dotnet-runtime-3.0.0-preview4-27615-11-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7c6eb3b5-9a32-443f-a453-44053500693f/73e29ee1e2e8bf0ce940bfb74df9ac00/dotnet-runtime-3.0.0-preview4-27615-11-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/797ab375-f427-4007-b17f-9ded29676b97/8e4103e31098287612100dd63b7b9315/dotnet-runtime-3.0.0-preview4-27615-11-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/f7c8b865-335d-4d12-be45-d9eec74ccc18/40e5c5be673e47367e670edccb101e43/dotnet-runtime-3.0.0-preview4-27615-11-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/49d3a3a0-97ec-4e67-ba04-7f7d1e4a018e/db1b4328863a284aaeaa53a86934233b/dotnet-runtime-3.0.0-preview4-27615-11-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/6c999d0f-e4f0-40af-9fd5-c680b5f89abe/d9ab03249daca4db5fa3cd66ce659a8f/dotnet-runtime-3.0.0-preview4-27615-11-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/ec7cf290-05b1-4fe5-b6f0-ca2042346432/94dcf57fc2c5da65bf19b0933ecac923/dotnet-runtime-3.0.0-preview4-27615-11-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/2c5e986f-63c1-410b-966a-d72760744fd3/ed26fd610b292c87ddcf91b957ebe041/dotnet-runtime-3.0.0-preview4-27615-11-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/320aebf9-d012-4bc5-8730-d336ad27c27d/e17e568694adc894b366e176f7a3e660/dotnet-runtime-3.0.0-preview4-27615-11-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/71da16e7-cec4-4d64-a50e-1046289bc9b3/7bdd0a9ac4e45e1043398fbf151c6070/dotnet-runtime-3.0.0-preview4-27615-11-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/a7f9a7fb-cc78-48bc-93e1-120fea7964f9/ab6bf079a404aff058c756e6e91a5f7d/dotnet-runtime-3.0.0-preview4-27615-11-win-x86.zip

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0c4d44a8-3ccd-45f4-994f-ea93008226eb/c4088c9872670837bb2fa55162fd5c77/aspnetcore-runtime-3.0.0-preview4-19216-03-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cfa0ebe9-c4f8-4e1c-b777-57a5e0d66bb7/5344f7c1fdab4400102b46e04c2eff3b/aspnetcore-runtime-3.0.0-preview4-19216-03-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4c88d509-2236-40e5-9797-3e6681ed278d/3011a1d03fd89eed089bd3ce44baa6b9/aspnetcore-runtime-3.0.0-preview4-19216-03-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/efe3f589-6a9e-4c05-95ca-a514188d048a/b81d36316bc4406efd37df0419691208/aspnetcore-runtime-3.0.0-preview4-19216-03-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c7d3a630-4c69-47bd-b4af-654e77514d20/6b15853d4c0e45637e01b37983652cc9/aspnetcore-runtime-3.0.0-preview4-19216-03-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/06f50bbd-1a2a-4cfd-ba58-3dd5e573cd2b/e94ff22b6065272fa5499649a64b2e45/aspnetcore-runtime-3.0.0-preview4-19216-03-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/6963b6d0-6335-48c9-8bd5-8e418ce9df27/7412bc71723b27c40667b082533f6e99/aspnetcore-runtime-3.0.0-preview4-19216-03-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8cd7ca69-40cc-461f-ae97-d50d73b424f4/39638454092a873e5680af2d7e496373/aspnetcore-runtime-3.0.0-preview4-19216-03-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/8c1dad0a-4f29-41c2-9f73-f6339f80d127/a75e7316bf4dfa497992ddc22c5cae05/aspnetcore-runtime-3.0.0-preview4-19216-03-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/709aa675-f1ca-4efe-80c8-67795696c882/c6c59a222f722b9c755e6b5662133c95/aspnetcore-runtime-3.0.0-preview4-19216-03-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/1a4373cf-d4ed-4aa7-b3e1-49f5ddb9cb22/f410589b3d4ddd4f0bca9a466bb64ce3/dotnet-hosting-3.0.0-preview4-19216-03-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/549f71f9-ba29-476d-8e15-b450f7ba2504/59825a1fcc5aa35344e4f44b2e9f94db/dotnet-sdk-3.0.100-preview4-011223-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/39601b46-a250-46c3-92f0-68493e07fe5c/3bc40cf7868dcdd05ce353e253fd266c/dotnet-sdk-3.0.100-preview4-011223-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ab4af538-7d1b-402e-85e2-ec0e8cde3c4e/fe8367f401f7f7125c1f0e0332a04e0d/dotnet-sdk-3.0.100-preview4-011223-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/26d4dc1f-f674-4902-9921-f287f65266f9/ef8a67939f0c3e5729b2674a5e013328/dotnet-sdk-3.0.100-preview4-011223-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ad5375dc-7304-4633-9d1a-23c7a41e8f9d/7b4630b0cfa7e275d9b7f87865b8db47/dotnet-sdk-3.0.100-preview4-011223-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b52e8baf-37c7-485d-ba4d-ef17af92b2fe/55f91ca67d8a29b62e685f28939077b6/dotnet-sdk-3.0.100-preview4-011223-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0bb08d76-c69f-4f21-b0f5-f5b1446cd9bd/e729ccdf120e9dd15ca4115939776768/dotnet-sdk-3.0.100-preview4-011223-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/2e0f3778-0bdf-47c5-b8f3-d4a357b030ee/5e252aa9d4ea91c83c81d2b8cff69c0f/dotnet-sdk-3.0.100-preview4-011223-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4032ceb5-61cd-495a-ab25-475aa2232f28/7eb614e777d87ef0d49f86be4fc8bbde/dotnet-sdk-3.0.100-preview4-011223-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/a3fe6da8-1ec8-48e5-b93d-cbf6cbe4e1ad/b4c6e212cda446fcc6c305296130e76b/dotnet-sdk-3.0.100-preview4-011223-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/e6cdbf31-8b69-4e30-b555-4d4543381c74/bde99c9c84d675e5462759a5d2586ce5/dotnet-sdk-3.0.100-preview4-011223-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/6e7b3953-2991-4078-9d2d-677c58c3a612/3ed31ed32cfb2d950e90b09b8a4c291d/dotnet-sdk-3.0.100-preview4-011223-win-x86.zip

[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/61fb6716-1c35-4833-b7bd-d1952458ad5c/f1387df70c4fe1722f6aeae81efd6c9c/core-setup-3.0.0-preview4-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/21e51454-1796-4d75-bda3-62cfc609e0ad/ffcf37fcc73043554a18a64a43f62ab4/coreclr-3.0.0-preview4-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/459e521e-3a07-443b-8bda-5551589b5137/b71f1121008551eec5c0bac3cfcb44ea/corefx-3.0.0-preview4-symbols.zip
[dotnet-trusted-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0c77038c-bf98-418a-b2ac-9d64dadfa4d4/f788cc2ba2d1ea7ba57f32e6065af155/dotnet-trusted-3.0.0-preview4-symbols.zip
[aspnet-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/d5d0ef3f-e495-4394-82bf-5b3b1e2db8f2/ba5c2e7e94516602373c764d4a467eb6/aspnet-3.0.0-preview4-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-preview4-27615-11-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.100-preview4-011223-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-preview-4/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-0-preview-4/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-3-0-preview-4
