# .NET Core 3.0.0 Preview 5 - May 06, 2019

.NET Core 3.0.0 Preview 5 is available for download and usage in your environment. This release includes .NET Core 3.0.0 Preview 5 and .NET Core SDK 3.0.100 Preview 5.

**Visual Studio compatibility:** If Visual Studio is your preferred development environment, you will need the latest preview of Visual Studio 2019 (v16.1) to take full advantage of .NET Core 3.0 Previews. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

* [Downloads](#downloads)
* [Changes in this release](#notable-changes-in-300-preview-5)
* [Known issues](3.0.0-preview-known-issues.md)

## Blog Roundup

[Will be published at 9am pacific time]

* [.NET Core 3.0 Preview 5][dotnet-blog]
* [Introducing .NET 5][dotnet5-blog]
* [ASP.NET Core][aspnet-blog]

The .NET Core SDK 3.0.100 Preview 5 includes .NET Core 3.0 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.0.100 preview, the following command will show that you're running version `3.0.100-preview5-011568` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #2685](https://github.com/dotnet/core/issues/2685) for your questions and comments.

## Downloads

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip]  | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \|<br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     |  [Snap Install](3.0.0-preview3-download.md)  | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz]<sup>1</sup> \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | See list below<sup>3<sup> | -                                        | See list below<sup>3<sup> | - | See list below<sup>3<sup> |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. Note, the Hosting Bundle has an issue with the ASP.NET Core Module. If you would like to install the ASP.NET Core Module, please install the 3.0 Preview 5 [Hosting Bundle][dotnet-hosting-win.exe] and run the executable on a command line with the parameters `OPT_NO_SHAREDFX=1 OPT_NO_RUNTIME=1`. Then install the appropriate .NET and ASP.NET runtimes.
3. Available symbols sets
    - [ASP.NET Core][aspnetcore-symbols.zip]
    - [ASP.NET Core Tooling][aspnetcore-tooling-symbols.zip]
    - [Setup][core-setup-symbols.zip]
    - [CoreCLR][coreclr-symbols.zip]
    - [CoreFX][corefx-symbols.zip]
    - [Entity Framework Core][entityframeworkcore-symbols.zip]
    - [EF Extensions][extensions-symbols.zip]
    - [Linker][linker-symbols.zip]
    - [MSBuild][msbuild-symbols.zip]
    - [NuGet Client][nuget.client-symbols.zip]
    - [Roslyn][roslyn-symbols.zip]
    - [NETStandard][standard-symbols.zip]
    - [Templating][templating-symbols.zip]
    - [Visual F#][visualfsharp-symbols.zip]
    - [WebSDK][websdk-symbols.zip]
    - [WinForms][winforms-symbols.zip]
    - [WPF][wpf-symbols.zip]
## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 3.0.0 Preview 5

Here is list of some of the additions and updates we're excited to bring in Preview 5. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* Runtime major-version roll-forward support
* JSON Serializer and writer updates
* WPF and WinForms updates
* Single EXE publishing
* Index and Range updates
* New SqlClient
* New Japanese Era support
* ASP.NET Core 3.0 Preview 5 ([bugs](https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+label%3A%223+-+Done%22+label%3Abug+milestone%3A3.0.0-preview5), [features](https://github.com/aspnet/AspNetCore/issues?utf8=%E2%9C%93&q=is%3Aissue+label%3A%223+-+Done%22+label%3Aenhancement+milestone%3A3.0.0-preview5))

## Lifecycle News

### Ubuntu 14.04 reached the end of standard support

Ubuntu 14.04 reached the end of its [Standard Support lifecycle](https://wiki.ubuntu.com/Releases) April 2019. As described in [.NET Core OS Lifecycle Policy](../../../os-lifecycle-policy.md), we will no longer test .NET Core on this version or produce updates for the OS version.

### .NET Core LTS

Our plans call for the next LTS release of .NET Core toward the end of 2019. We are also working on a long term release roadmap which will enable you to better plan for updates and understand the LTS release cycle. An introduction to the roadmap can be seen in the [.NET 5 blog post][dotnet5-blog]

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.0.0-preview5.md

[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/779c214c-4898-4dbb-bc1c-0cea689a52ed/a8dc33d07be2bd14a5d581c08ebed653/dotnet-runtime-3.0.0-preview5-27626-15-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/89ac182b-199f-4b66-abf8-b0494407d890/c4dfc2ce4df1f7dad8d695c92562ab79/dotnet-runtime-3.0.0-preview5-27626-15-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/37f09eb4-1aa9-4847-ba14-db0df16d72e3/578e48496f26ae015649ffd8d04fc7ad/dotnet-runtime-3.0.0-preview5-27626-15-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f15ad9ab-7bd2-4ff5-87b6-b1a08f062ea2/6fdd314c16c17ba22934cd0ac6b4d343/dotnet-runtime-3.0.0-preview5-27626-15-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/43fd619e-d110-438b-99ec-b776c4a1cf57/77d5f5e5d942269a5b3871c668cde381/dotnet-runtime-3.0.0-preview5-27626-15-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/85024962-5dee-4f64-ab29-a903f3749f85/6178bfacc58f4d9a596b5e3facc767ab/dotnet-runtime-3.0.0-preview5-27626-15-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/07868c37-0847-4fff-8958-65f43f54f66a/22c55cdd15322f20ea5737e4c5976a8d/dotnet-runtime-3.0.0-preview5-27626-15-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/c6533113-60e1-464b-8a74-c06c243124d7/67808e85dfd00f9bae0b438292575f88/dotnet-runtime-3.0.0-preview5-27626-15-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d7af8514-482d-4fde-acfc-695fbffd320a/a575c0764cce6ca7ea982eb36a90695f/dotnet-runtime-3.0.0-preview5-27626-15-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/9459ede1-e223-40c7-a4c5-2409e789121a/46d4eb6067bda9f412a472f7286ffd94/dotnet-runtime-3.0.0-preview5-27626-15-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4f05cfbc-9a92-4deb-9894-2ed6f5021e11/6f4e75cd7c37a90c173595559c48ac3e/dotnet-runtime-3.0.0-preview5-27626-15-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/ee55b19c-1952-42f8-8a7d-71be302b90b5/42e85b44402846f8dbdd6c3394644ccb/dotnet-runtime-3.0.0-preview5-27626-15-win-x86.zip

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a8f84ed3-7294-427c-883a-5278091d63ab/373f6fa1ef32f798c2fd3ba98b657249/aspnetcore-runtime-3.0.0-preview5-19227-01-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ee1fd04f-606d-4bd6-ad2d-1a902af87ca9/d8c3c09f00cb010c0af0922870ba5b04/aspnetcore-runtime-3.0.0-preview5-19227-01-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/96d6195b-aff9-46c2-b5a0-ec33a1b4743b/e3c2deb2ec803fad6d24bc5fede61d66/aspnetcore-runtime-3.0.0-preview5-19227-01-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cd52bfa4-0260-479c-a32d-b4435c8ccda8/943c20feec33b778685d733064d8ddb1/aspnetcore-runtime-3.0.0-preview5-19227-01-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0664198d-9e22-4553-a09f-46200d7c168f/70aab66943febeb83b5aa5f182125cb7/aspnetcore-runtime-3.0.0-preview5-19227-01-osx-x64.tar.gz
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/2702e7bb-e94e-4706-8498-bdb839d00572/0143b82ea04720d3f4f2950c493747f3/aspnetcore-runtime-3.0.0-preview5-19227-01-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/d62ad250-c555-4b64-99b3-47fba99a445a/3eeee0eb676ddffac689a2a98ae83779/aspnetcore-runtime-3.0.0-preview5-19227-01-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/14f0ae25-c99a-4415-8136-2c8298ae8056/311187358a73ed3f76557dbfc7a061ec/aspnetcore-runtime-3.0.0-preview5-19227-01-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/0daba0cb-2b7f-42b0-bf33-92bd58a5913d/439fe05a7aea1f713137d1de5173140d/aspnetcore-runtime-3.0.0-preview5-19227-01-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/bd1697a3-51cc-4ed2-83a0-cbcfc9f39d10/7233165fd661268c625e3c353cb3fbcb/aspnetcore-runtime-3.0.0-preview5-19227-01-win-x86.zip
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/41483896-e029-40ff-b167-b4dde24153e1/ccd755c56bc8cfeb38ef816e54deb906/dotnet-hosting-3.0.0-preview5-19227-01-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/176a9b0c-bf87-4ddc-856e-9a0a71d37fa5/a6fc47f80927ba2f0abde74d1185fc0b/dotnet-sdk-3.0.100-preview5-011568-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa62ce11-f5d3-4f71-a5dd-07edf988edae/91cfccdeb4a58583f49c4a12dbd6f329/dotnet-sdk-3.0.100-preview5-011568-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/27ec53c2-5606-40d1-88f0-fac66589943b/2718988561eb0e306abc8681f6180c1f/dotnet-sdk-3.0.100-preview5-011568-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/7e4b403c-34b3-4b3e-807c-d064a7857fe8/95c738f08e163f27867e38c602a433a1/dotnet-sdk-3.0.100-preview5-011568-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/afcef2c8-471f-48aa-8030-010fb6c8517b/75a05bc56f2849f80d5ca7b834bb8722/dotnet-sdk-3.0.100-preview5-011568-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72d909f3-3b02-483a-892f-7c2baff89529/028027ad9a7ade20ec7b863b39a45b8c/dotnet-sdk-3.0.100-preview5-011568-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/d6337065-9638-41aa-9a59-d3f3bc8853f7/6ed9d6cb0f4ca22b92f9cb1b45ad812d/dotnet-sdk-3.0.100-preview5-011568-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/95235b26-8105-4b33-be7c-92bf91d83d6c/64f156518eae7edf6231b4eeb80438f7/dotnet-sdk-3.0.100-preview5-011568-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c2521385-1648-415f-8503-b1860b80d57b/5d571a80ed7ba1cb5a085d28c8a018bf/dotnet-sdk-3.0.100-preview5-011568-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/78836c06-166d-4145-ae7b-da5693e36665/431a2fd34af25742527bc5cafe4d8fae/dotnet-sdk-3.0.100-preview5-011568-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/2bcc97ec-5b0e-451a-9eb3-57e55b479527/6d707323e62593ea50a31e6bd00c1cdc/dotnet-sdk-3.0.100-preview5-011568-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/d2384cff-5bc5-4f18-8fd1-70c4ec822d3e/610545198dd0503c07f04cefbd973e78/dotnet-sdk-3.0.100-preview5-011568-win-x86.zip

[aspnetcore-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/90074ec5-e4f9-4e6b-b6dc-131c0159ac6b/7643d117ef84ede1204e576abdb7d05d/aspnetcore-3.0.0-preview5-symbols.zip
[aspnetcore-tooling-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/369404f5-5904-4668-a719-63bd5ea01628/f980f8e11b1efb76ba645d4e84879ea6/aspnetcore-tooling-3.0.0-preview5-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/3299d878-83fb-42e9-b46d-0376c7e4a8b1/b6cfb1bda3779952e91c77fa40c93cc9/core-setup-3.0.0-preview5-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/57eb9cc2-35c0-40e6-862a-72e013635512/d67f5f9789c5ebb3345a38f7d72ba501/coreclr-3.0.0-preview5-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/585beb3f-a54a-4382-87cb-a92f22667502/807a02ba130426797811f4cc0ef1054c/corefx-3.0.0-preview5-symbols.zip
[dotnet-trusted-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/f28c3d63-ef3a-4795-a70b-d8be7009bb1f/cab25cab171b9dbf4a83b22b4e9eb4c9/dotnet-trusted-3.0.0-preview5-symbols.zip
[entityframeworkcore-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/554f6d8e-3395-45bb-a748-9b1bf15c7d00/48a99ba761b75b2c8c30545da0e4fad3/entityframeworkcore-3.0.0-preview5-symbols.zip
[extensions-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/22772da4-4b7a-4eae-8e29-de6548668e5e/1eb8187a8da650add55559e85ac3e863/extensions-3.0.0-preview5-symbols.zip
[linker-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/f304886f-b84a-4c62-8869-51039e505741/916eb007f0383bbaffbf9392a1f0aa26/linker-3.0.0-preview5-symbols.zip
[msbuild-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b044dd97-91ab-4b8f-88f2-aca01ed7e6b3/42849a6c92a041a0c549ed936de5b7ff/msbuild-3.0.0-preview5-symbols.zip
[nuget.client-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/de7cc91b-ffd0-4687-a47b-f526800ca136/f2ce53386fb788ca597d8fdaf7b9e8a1/nuget.client-3.0.0-preview5-symbols.zip
[roslyn-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b38be644-ff60-4c24-b28c-d5f74d46aa23/4e44ae2338b30401c64045aa233e1556/roslyn-3.0.0-preview5-symbols.zip
[standard-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/91c33e91-7a1d-4e29-9ebd-151f6d9c8fac/d8668854b5d3f6960fdfeb3fcb57d4dd/standard-3.0.0-preview5-symbols.zip
[templating-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/5e9e39f8-d2c0-45e5-b545-f118d5fcdc63/a2031e8d5d6ef7aba7d2e2990df41249/templating-3.0.0-preview5-symbols.zip
[visualfsharp-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/15eebc4e-aadf-4dd0-80df-48779f304619/7cfe576ed32643f50c6f291cde42a8f1/visualfsharp-3.0.0-preview5-symbols.zip
[websdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0f85b1d0-3d13-48df-b945-ea3004951741/57c86e99f231e337599cb1ca2cb872e3/websdk-3.0.0-preview5-symbols.zip
[winforms-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/12bd9ba5-21e0-446c-ad94-4fbaf786d70d/2f946135a4831f7e961158601d804aab/winforms-3.0.0-preview5-symbols.zip
[wpf-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/bb3914d1-8d03-40ac-9211-efef6df1851b/a2686e68087d273f6bac1e0041b8f5ba/wpf-3.0.0-preview5-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-preview5-27626-15-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.100-preview5-011568-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0-preview-5/
[dotnet5-blog]: https://devblogs.microsoft.com/dotnet/introducing-net-5/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-updates-in-net-core-3-0-preview-5/
