# .NET Core 3.0.0 Preview 6

.NET Core 3.0.0 Preview 6 comprises:

* .NET Core Runtime 3.0.0-preview6-27804-01
* ASP.NET Core 3.0.0-preview6.19307.2
* .NET Core SDK 3.0.100-preview6-012264

See the [Release Notes][release-notes] for details about what is included in this update.

|           | SDK Installer<sup>1</sup>                        | SDK Binaries<sup>1</sup>                 | Runtime Installer                                        | Runtime Binaries                                 | ASP.NET Core Runtime           |
| --------- | :------------------------------------------:     | :----------------------:                 | :---------------------------:                            | :-------------------------:                      | :-----------------:            |
| Windows   | [x86][dotnet-sdk-win-x86.exe] \| [x64][dotnet-sdk-win-x64.exe] | [x86][dotnet-sdk-win-x86.zip] \| [x64][dotnet-sdk-win-x64.zip] \| [ARM][dotnet-sdk-win-arm.zip] | [x86][dotnet-runtime-win-x86.exe] \| [x64][dotnet-runtime-win-x64.exe] | [x86][dotnet-runtime-win-x86.zip] \| [x64][dotnet-runtime-win-x64.zip] \| [ARM][dotnet-runtime-win-arm.zip] | [x86][aspnetcore-runtime-win-x86.exe] \| [x64][aspnetcore-runtime-win-x64.exe] \| [ARM][aspnetcore-runtime-win-arm.zip] \| <br/> [Hosting Bundle][dotnet-hosting-win.exe]<sup>2</sup> |
| macOS     | [x64][dotnet-sdk-osx-x64.pkg]  | [x64][dotnet-sdk-osx-x64.tar.gz]     | [x64][dotnet-runtime-osx-x64.pkg] | [x64][dotnet-runtime-osx-x64.tar.gz] | [x64][aspnetcore-runtime-osx-x64.tar.gz]<sup>1</sup>
| Linux     | [See installations steps below][linux-install]   | [x64][dotnet-sdk-linux-x64.tar.gz] \| [ARM][dotnet-sdk-linux-arm.tar.gz] \| [ARM64][dotnet-sdk-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-sdk-linux-musl-x64.tar.gz] | - | [x64][dotnet-runtime-linux-x64.tar.gz] \| [ARM][dotnet-runtime-linux-arm.tar.gz] \| [ARM64][dotnet-runtime-linux-arm64.tar.gz] \| [x64 Alpine][dotnet-runtime-linux-musl-x64.tar.gz] | [x64][aspnetcore-runtime-linux-x64.tar.gz]<sup>1</sup>  \| [ARM][aspnetcore-runtime-linux-arm.tar.gz]<sup>1</sup> \| [ARM64][aspnetcore-runtime-linux-arm64.tar.gz] \| [x64 Alpine][aspnetcore-runtime-linux-musl-x64.tar.gz]<sup>1</sup> |
| RHEL6     | -                                                | [x64][dotnet-sdk-rhel.6-x64.tar.gz]                    | -                                                        | [x64][dotnet-runtime-rhel.6-x64.tar.gz] | - |
| Checksums | [SDK][checksums-sdk]                             | -                                        | [Runtime][checksums-runtime]                             | - | - |
| Symbols   | See list below<sup>3<sup>  | -                                        | See list below<sup>3<sup> | - | See list below<sup>3<sup> |

1. Includes the .NET Core and ASP.NET Core Runtimes
2. For hosting stand-alone apps on Windows Servers. Includes the ASP.NET Core Module for IIS and can be installed separately on servers without installing .NET Core runtime.
3. Available symbols sets
    - [ASP.NET Core][aspnetcore-symbols.zip]
    - [ASP.NET Core Tooling][aspnetcore-tooling-symbols.zip]
    - [Setup][core-setup-symbols.zip]
    - [CoreCLR][coreclr-symbols.zip]
    - [CoreFX][corefx-symbols.zip]
    - [Entity Framework Core][entityframeworkcore-symbols.zip]
    - [EF Extensions][extensions-symbols.zip]
    - [Linker][linker-symbols.zip]
    - [MSBuild][msbuild-symbols.zip]
    - [NuGet Client][nuget.client-symbols.zip]
    - [Roslyn][roslyn-symbols.zip]
    - [NETStandard][standard-symbols.zip]
    - [Templating][templating-symbols.zip]
    - [Visual F#][visualfsharp-symbols.zip]
    - [WebSDK][websdk-symbols.zip]
    - [WinForms][winforms-symbols.zip]
    - [WPF][wpf-symbols.zip]

## Docker

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

## Installing .NET Core on Linux

### Install using Snap

Because of the isolated environment, using Snap is the preferred way to install and try .NET Core Previews on [Linux distributions that support Snap](https://docs.snapcraft.io/installing-snapd/6735).

After configuring Snap on your system, run the following command to install the latest .NET Core SDK.

`sudo snap install dotnet-sdk --beta --classic`

When .NET Core in installed using the Snap package, the default .NET Core command is `dotnet-sdk.dotnet`, as opposed to just `dotnet`. The benefit of the namespaced command is that it will not conflict with a globally installed .NET Core version you may have. This command can be aliased to `dotnet` with:

`sudo snap alias dotnet-sdk.dotnet dotnet`

**Note:** Some distros require an additional step to enable access to the SSL certificate. If you experience SSL errors when running `dotnet restore`, see [.NET for Linux Distributions](../../../linux.md) for a possible resolution.

### Install using deb/rpm packages

Preview release installers are not available from the Microsoft package repositories but you can download them and install manually or, set up a local package repository. Setting up a local package repository will result in a typical package manager installation experience. Consult your distros documentation to understand this option.

A manual installatoin requires the use of your distro's package installer to install each of the files *in the order presented below.* If you attempt to install them out of order, dependency checks will not succeed and the installation will fail. Download the correct System Dependencies Installer along with the `host, hostfxr, runtime, aspnetcore-runtime and sdk` installers.

Please see the [3.0 Supported OS](../3.0-supported-os.md) document for specific distro version support status.

| **System Dependencies Installer** |
| :-- |
| [Centos 7][dotnet-runtime-deps-centos.7-x64.rpm] |
| [Fedora][dotnet-runtime-deps-fedora.27-x64.rpm] |
| [OpenSUSE][dotnet-runtime-deps-opensuse.42-x64.rpm] |
| [Oracle Linux 7][dotnet-runtime-deps-oraclelinux.7-x64.rpm] |
| [RHEL 7][dotnet-runtime-deps-rhel.7-x64.rpm] |
| [SLES 12][dotnet-runtime-deps-sles.12-x64.rpm] |
| [Debian-based systems][dotnet-runtime-deps-x64.deb] |

| **Component** | **Package Type** |
| :--- | :---: |
| dotnet-host | [deb][dotnet-host-x64.deb] \| [rpm][dotnet-host-x64.rpm] |
| dotnet-hostfxr | [deb][dotnet-hostfxr-x64.deb] \| [rpm][dotnet-hostfxr-x64.rpm] |
| dotnet-runtime | [deb][dotnet-runtime-x64.deb] \| [rpm][dotnet-runtime-x64.rpm] |
| aspnetcore-runtime | [deb][aspnetcore-runtime-x64.deb] \| [rpm][aspnetcore-runtime-x64.rpm] |
| dotnet-targeting-pack | [deb][dotnet-targeting-pack-x64.deb] \| [rpm][dotnet-targeting-pack-x64.rpm] |
| dotnet-apphost-targeting-pack | [deb][dotnet-apphost-pack-x64.deb] \| [rpm][dotnet-apphost-pack-x64.rpm] |
| aspnetcore-targeting-pack | [deb][aspnetcore-targeting-pack.deb] \| [rpm][aspnetcore-targeting-pack.rpm] |
| netstandard-targeting-pack | [deb][netstandard-targeting-pack-x64.deb] \| [rpm][netstandard-targeting-pack-x64.rpm] |
| dotnet-sdk | [deb][dotnet-sdk-x64.deb] \| [rpm][dotnet-sdk-x64.rpm] |

After downloading the files, run your package utility to install the files in the following order.

1. dotnet-runtime-deps (System Dependencies Installer)
2. dotnet-host
3. dotnet-hostfxr
4. dotnet-runtime
5. aspnetcore-runtime
6. dotnet-targeting-pack
7. dotnet-apphost-targeting-pack
8. aspnetcore-targeting-pack
9. netstandard-targeting-pack
10. dotnet-sdk

**CentOS, Fedora, OpenSUSE, Oracle Linux, RHEL and SLES**
`sudo rpm -ivh [package name]`

**Debian and Ubuntu**
`sudo dpkg -i [package name]`

Here is a simple example script for Fedora to download and install the packages as described above.

``` bash
cd $HOME/Downloads
mkdir preview6
cd preview6

wget -c https://download.visualstudio.microsoft.com/download/pr/d0efaff6-541e-4f8c-a362-945c849cd246/69869e837e623792ff6b6d741084818f/dotnet-host-3.0.0-preview6-27804-01-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/ac9944bb-aa2f-487c-985d-291fd093126b/0bc3bacb974d24c2cb84c8fc3dc65def/dotnet-hostfxr-3.0.0-preview6-27804-01-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/af932328-cb68-42b9-83e5-2f891ac143e2/459f0f21f2a7db48ea782dc2d38bfd1b/dotnet-runtime-3.0.0-preview6-27804-01-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/d8b7bf19-954d-4e28-9012-76004f8cb592/d2601db2e2eb3d5257255361052614a9/dotnet-runtime-deps-3.0.0-preview6-27804-01-fedora.27-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/40027d60-0bac-4d74-b79c-3379409dcc2a/f0eeaf7f964173beb5984a447d812867/aspnetcore-runtime-3.0.0-preview6.19307.2-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/df8882ca-8ed4-4ef2-b3a1-c8369f9badf3/4d39dc5c548b392a6a1323765da9f8a2/dotnet-sdk-3.0.100-preview6-012264-x64.rpm

wget -c https://download.visualstudio.microsoft.com/download/pr/f7d4f4ac-d088-46ac-9b30-dc3dfa96095a/ec3e597d5aec2c6ec1e155de45e19df4/dotnet-apphost-pack-3.0.0-preview6-27804-01-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/a911841b-4883-4e84-b402-af28eef49b64/bd24f5ecb5d8dddcb6560be90cf38ad0/dotnet-targeting-pack-3.0.0-preview6-27804-01-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/ee5edd36-b1c2-497b-a5e3-423d692490bf/b278752c7e932fcfc506c3e45b29c231/netstandard-targeting-pack-2.1.0-preview6-27804-01-x64.rpm
wget -c https://download.visualstudio.microsoft.com/download/pr/eb96c91e-1ba3-469f-b579-0cdc5a989fe0/1713ed4d7284160e3f16cf812028f9e8/aspnetcore-targeting-pack-3.0.0-preview6.19307.2.rpm

sudo rpm -ivh dotnet-runtime-deps-3.0.0-preview6-27804-01-fedora.27-x64.rpm
sudo rpm -ivh dotnet-host-3.0.0-preview6-27804-01-x64.rpm
sudo rpm -ivh dotnet-hostfxr-3.0.0-preview6-27804-01-x64.rpm
sudo rpm -ivh dotnet-runtime-3.0.0-preview6-27804-01-x64.rpm
sudo rpm -ivh aspnetcore-runtime-3.0.0-preview6.19307.2-x64.rpm
sudo rpm -ivh dotnet-apphost-pack-3.0.0-preview6-27804-01-x64.rpm
sudo rpm -ivh dotnet-targeting-pack-3.0.0-preview6-27804-01-x64.rpm
sudo rpm -ivh netstandard-targeting-pack-2.1.0-preview6-27804-01-x64.rpm
sudo rpm -ivh aspnetcore-targeting-pack-3.0.0-preview6.19307.2.rpm
sudo rpm -ivh dotnet-sdk-3.0.100-preview6-012264-x64.rpm
```

### Installation from a binary archive

Installing from the packages detailed above is recommended or you can install from binary archive, if that better suits your needs. When using binary archives to install, the contents must be extracted to a user location such as `$HOME/dotnet`, a symbolic link created for `dotnet` and a few dependencies installed. Dependency requirements can be seen in the [Linux System Prerequisites](https://github.com/dotnet/core/blob/main/Documentation/linux-prereqs.md) document.

```bash
mkdir -p $HOME/dotnet && tar zxf dotnet.tar.gz -C $HOME/dotnet
export PATH=$PATH:$HOME/dotnet
```

## .NET Core Runtime-only installation

If only the .NET Core Runtime is needed, install `dotnet-runtime-3.0` using your package manager. If you also need ASP.NET Core functionality, installing `aspnetcore-runtime-3.0` will install both the ASP Runtime and .NET Core Runtime.

## Windows Server Hosting

If you are looking to host stand-alone apps on Servers, the following installer can be used on Windows systems.

### Windows

You can download the Windows Server Hosting installer and run the following command from an Administrator command prompt:

* [dotnet-hosting-3.0.0-preview6.19307.2-win.exe][dotnet-hosting-win.exe]

This will install the ASP.NET Core Module for IIS.

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.0.0-preview6.md

[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/8c70f3b5-1866-4969-8acf-303ce1a5412a/c75e23e6f50d597e3b3b86bb672a6ab2/dotnet-host-3.0.0-preview6-27804-01-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/d0efaff6-541e-4f8c-a362-945c849cd246/69869e837e623792ff6b6d741084818f/dotnet-host-3.0.0-preview6-27804-01-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/f62d3861-6142-4150-9e93-868099ca0502/35ba5215c361b923409f304e3771a593/dotnet-hostfxr-3.0.0-preview6-27804-01-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ac9944bb-aa2f-487c-985d-291fd093126b/0bc3bacb974d24c2cb84c8fc3dc65def/dotnet-hostfxr-3.0.0-preview6-27804-01-x64.rpm
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f274b190-2f0b-4616-a446-7090b55dd80c/1b652d6a8a50a8a6f0efc098a6e5e6dd/dotnet-runtime-3.0.0-preview6-27804-01-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f6f57f07-c407-4dec-a11e-7c521b842dff/edea09e548e1b673ccca1b2c685b0b12/dotnet-runtime-3.0.0-preview6-27804-01-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/74c6571d-30e8-4efd-b649-dcdd63c045a0/e1020469985f91ce01bdc858122c8317/dotnet-runtime-3.0.0-preview6-27804-01-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/fa0cd01b-c71c-40ed-bb78-1ff9acbfb8b2/e6510b76b6272bc7ce3f85e3a96ff9e1/dotnet-runtime-3.0.0-preview6-27804-01-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/a5a6bc03-7b32-4158-aff1-1c1060f852da/75ef05dd1501ceb064e7a5ce255c0bac/dotnet-runtime-3.0.0-preview6-27804-01-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/07dcd5e2-bb85-44fd-b60e-fe3102972e9a/1f344a1dbd6e59f3003197a2aa33a38b/dotnet-runtime-3.0.0-preview6-27804-01-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4ec40d36-7f1e-4421-bcb4-4da0df1dfc0b/14d77c1b519daa39a395546a28b9fafd/dotnet-runtime-3.0.0-preview6-27804-01-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/d977a67d-119f-4d5e-aaa9-2d43c01f4978/241064a2a67af8eb67bb40e1e58b7506/dotnet-runtime-3.0.0-preview6-27804-01-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/c50379b1-0257-454c-b61c-662c25253d99/bd3525bd7720e131fa5831731303e428/dotnet-runtime-3.0.0-preview6-27804-01-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/cd58b305-6f39-4cd2-9e9f-7c3b6dc61e35/d53850f37fbfe1a1a3babc8c6ed74465/dotnet-runtime-3.0.0-preview6-27804-01-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/fc716153-4abd-425d-9837-2e8c4f565197/b22ca838f79484bf12d0426085f10886/dotnet-runtime-3.0.0-preview6-27804-01-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/c0d891be-0681-4158-bcd0-8fa222d6e056/846e7c8fc3d5e7ae9b90cba0d9884981/dotnet-runtime-3.0.0-preview6-27804-01-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/b85699ae-e447-4b54-a6fe-537c9426ac0c/25f6576bb4d7ac649b733d0fb25bbaf6/dotnet-runtime-3.0.0-preview6-27804-01-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/af932328-cb68-42b9-83e5-2f891ac143e2/459f0f21f2a7db48ea782dc2d38bfd1b/dotnet-runtime-3.0.0-preview6-27804-01-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f48b6425-bfaa-488e-83ef-870726d77a1d/a05658865114cd0ded4f2a87282bb9b5/dotnet-runtime-deps-3.0.0-preview6-27804-01-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/d8b7bf19-954d-4e28-9012-76004f8cb592/d2601db2e2eb3d5257255361052614a9/dotnet-runtime-deps-3.0.0-preview6-27804-01-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ae5e1bad-05c7-4788-90d4-4d84fa736a37/0b1ac0bec313f8550570499e077a22f8/dotnet-runtime-deps-3.0.0-preview6-27804-01-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/57aeeb60-4ec5-4a29-9c14-e5c18d90c108/a0268ab81236fbb9030b145ace18ab40/dotnet-runtime-deps-3.0.0-preview6-27804-01-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/e013cba0-13aa-48e4-b5e7-783f8a5f7763/a6342f98c3ee0b23773c204396d9c047/dotnet-runtime-deps-3.0.0-preview6-27804-01-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/9411e9eb-606c-4892-9855-24bd971d9647/dc96fbffd34e6205a8805c0f9f5532f7/dotnet-runtime-deps-3.0.0-preview6-27804-01-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/af083813-ec86-4e18-b386-c7f89f013432/da18a8397fff81a07871a8a5840066e2/dotnet-runtime-deps-3.0.0-preview6-27804-01-x64.deb

[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/246ddf4f-e4b8-4306-8761-2dfbca37f7de/274b8c00abf99f374729e0534779951e/aspnetcore-runtime-3.0.0-preview6.19307.2-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/0040c5cc-ea1f-4d64-b9f3-9b4adc3811b6/fab5141cf1850d520eb2bc00bfa80183/aspnetcore-runtime-3.0.0-preview6.19307.2-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a3fabeed-a2a9-480b-9cad-4f40ad3be347/4a576819c2fafceda1804b37945784b4/aspnetcore-runtime-3.0.0-preview6.19307.2-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/ea4b23b0-d7dc-4d39-8de4-d4c89e1f9551/bfe628fcb8f19d4c97c75d1217af1a8b/aspnetcore-runtime-3.0.0-preview6.19307.2-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/bb0fdeb4-7823-4fe2-9570-476dbb8820af/60dc3930f2aaeb0e6ebfdf0dcdca4101/aspnetcore-runtime-3.0.0-preview6.19307.2-osx-x64.tar.gz
[aspnetcore-runtime-rh.rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f6a34aed-08da-4d6f-b800-7a169c5e8e7f/34cb2ad8b289ef78a4865a3bdbf5ec22/aspnetcore-runtime-3.0.0-preview6.19307.2-rh.rhel.7-x64.rpm
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/0dbf6a21-ef68-4aaf-b4f7-ffaa04a9ce88/89c9a67c6ca678d435d8acb7c7895c45/aspnetcore-runtime-3.0.0-preview6.19307.2-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/871eacb3-13c5-4bb1-ab9c-4776813b2f0a/d5aded51b925d2a933f51b9dec0c1222/aspnetcore-runtime-3.0.0-preview6.19307.2-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/7ee7da31-90a2-4992-b687-db86efc47a20/a7fde0f0b5edd35ffbd3455f7115d5a0/aspnetcore-runtime-3.0.0-preview6.19307.2-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/951f140b-08b5-417d-9177-3d79cea6e023/31ac4b39e95c038987de4f76d9863c11/aspnetcore-runtime-3.0.0-preview6.19307.2-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/dc310993-a8ce-48a7-adc6-37bde172e327/6caf36f2576dcdc97c6124fa26d6ceab/aspnetcore-runtime-3.0.0-preview6.19307.2-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/e3500e27-3aed-4c7a-a241-627dd33fda85/2f56e6bbf0e55b32dba9520c2426db51/aspnetcore-runtime-3.0.0-preview6.19307.2-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/40027d60-0bac-4d74-b79c-3379409dcc2a/f0eeaf7f964173beb5984a447d812867/aspnetcore-runtime-3.0.0-preview6.19307.2-x64.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/82fe6f83-3212-4401-9d71-d48bbc9bb69b/e003304de24a434a0a27c24131a2cb9f/dotnet-hosting-3.0.0-preview6.19307.2-win.exe

[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/50bc5936-b374-490b-9312-f3ca23c0bcfa/d7680c7a396b115d95ac835334777d02/dotnet-sdk-3.0.100-preview6-012264-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8997987c-1fcc-4b83-ab49-08117ac40f86/13f3cc0b0dfcf37398d11caff3926bb9/dotnet-sdk-3.0.100-preview6-012264-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/a094523b-8f35-464f-bbd5-c73c0c720a87/5647ca11bbed0a88f0b35b029a0f41fa/dotnet-sdk-3.0.100-preview6-012264-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/72ce4d40-9063-4a2e-a962-0bf2574f75d1/5463bb92cff4f9c76935838d1efbc757/dotnet-sdk-3.0.100-preview6-012264-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/31af4401-55f7-487c-adf7-2b6bed7cb1c5/a6aafa2569a628a80a6ebd2a2fd5c6f3/dotnet-sdk-3.0.100-preview6-012264-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/079e5b24-187f-4087-9a54-18285382f3e6/2ae97c55aae5e2c9472555839a48a83c/dotnet-sdk-3.0.100-preview6-012264-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/cecd1f2b-dc4b-4cf9-adaf-ddbcf1c2e0ea/4222de7a50aa77ad8418e88271b42d89/dotnet-sdk-3.0.100-preview6-012264-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/de37d402-a968-43dd-a23c-020e50073069/83e9f4f3d6d401e5f880d912e7255bf1/dotnet-sdk-3.0.100-preview6-012264-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/4d2dfaa1-4f9c-4526-bb6f-117d9d8bbd0e/a9fc9994c1b4d485ab41632b81bf4f56/dotnet-sdk-3.0.100-preview6-012264-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/4e73514f-0646-4600-bdc2-38c90fc207b6/22ad70cbe1a254177e6d7b7f7e7425f8/dotnet-sdk-3.0.100-preview6-012264-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/4a6fef07-dc91-4fbd-87c8-74fd8db71aeb/9fa79398a69ac4bd08e8bf51080b3553/dotnet-sdk-3.0.100-preview6-012264-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/f312d345-26a3-46a9-8c14-5375e49a73d8/990d563e1df783e8c26262bcafe92831/dotnet-sdk-3.0.100-preview6-012264-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/923d1732-7306-4648-97a0-04ba301ce6fd/dadf7531b75e59aab5618fe8a1d80a34/dotnet-sdk-3.0.100-preview6-012264-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/df8882ca-8ed4-4ef2-b3a1-c8369f9badf3/4d39dc5c548b392a6a1323765da9f8a2/dotnet-sdk-3.0.100-preview6-012264-x64.rpm

[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/895cb9d8-4e15-4dc8-b365-accf8a2bfd4f/0773c7438725e120b2e46c1cedbb327c/dotnet-apphost-pack-3.0.0-preview6-27804-01-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f7d4f4ac-d088-46ac-9b30-dc3dfa96095a/ec3e597d5aec2c6ec1e155de45e19df4/dotnet-apphost-pack-3.0.0-preview6-27804-01-x64.rpm
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/18d8db0b-62b4-4722-8c0b-c7930df193be/32f6d023dbdeeabe31275f3957128820/dotnet-targeting-pack-3.0.0-preview6-27804-01-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/a911841b-4883-4e84-b402-af28eef49b64/bd24f5ecb5d8dddcb6560be90cf38ad0/dotnet-targeting-pack-3.0.0-preview6-27804-01-x64.rpm
[netstandard-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/4c66444a-5343-46eb-a5f0-1ff1e939289d/addf63d6a6cd1c996dac99a75fd8745a/netstandard-targeting-pack-2.1.0-preview6-27804-01-x64.deb
[netstandard-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ee5edd36-b1c2-497b-a5e3-423d692490bf/b278752c7e932fcfc506c3e45b29c231/netstandard-targeting-pack-2.1.0-preview6-27804-01-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/8ec9eddc-4838-4d3b-95f7-7ff1ab36943e/29bcda09d344fe0d5be844da10eb4948/aspnetcore-targeting-pack-3.0.0-preview6.19307.2.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/eb96c91e-1ba3-469f-b579-0cdc5a989fe0/1713ed4d7284160e3f16cf812028f9e8/aspnetcore-targeting-pack-3.0.0-preview6.19307.2.rpm

[aspnetcore-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/675838d4-94bd-48f0-b873-db60188e9dfd/b726010bcd1c2c80a76e4a1aa231fed3/aspnetcore-3.0.0-preview6-symbols.zip
[aspnetcore-tooling-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/22af416f-8d85-4ffa-be44-ad8912f34279/49c40491bc2a93344e571c8e79cfca73/aspnetcore-tooling-3.0.0-preview6-symbols.zip
[blazor-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/aa5c443b-1375-4e22-ad4b-49ea3aeef89e/07006746268b666500860ea332cfdd93/blazor-3.0.0-preview6-symbols.zip
[core-setup-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ef6c90eb-d3de-4e43-86c2-1ae3fda0f2dd/5a4c7c03c74d05cf3a56c723f169536c/core-setup-3.0.0-preview6-symbols.zip
[coreclr-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/da1abf8a-d8da-4c2c-8c54-c5feed83a25a/0ebeb91c064ec5162b6793f6dc84212e/coreclr-3.0.0-preview6-symbols.zip
[corefx-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/4ebe24f7-9a1b-4f3b-bc70-a0db7e2d141a/69a426a9ddbb74327e8ba78935853391/corefx-3.0.0-preview6-symbols.zip
[entityframeworkcore-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/668eadfd-e4fb-4ce5-b4e0-fced6025d6e4/1b2e30e0dfe3b9a47de385e14cf40b0d/entityframeworkcore-3.0.0-preview6-symbols.zip
[extensions-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/9b15012c-74bd-4c38-ab5d-2d756628022c/7e460f32e84bdee983222962b284043e/extensions-3.0.0-preview6-symbols.zip
[linker-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/f95b4f2e-0c84-4002-b6c9-df633fcd9533/ddcd5b36e940143f2a4a8eb84d2d3c27/linker-3.0.0-preview6-symbols.zip
[msbuild-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0cf835fa-9ee1-4541-9ef0-0d9331b4e1f1/20bcc828a74122a1911b53778581bee6/msbuild-3.0.0-preview6-symbols.zip
[nuget.client-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/cfd8b9e9-c52d-43be-9806-93bdbfd079d7/295fa4e1b3335ce5494e35e7308b062d/nuget.client-3.0.0-preview6-symbols.zip
[roslyn-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/88028db6-3526-4298-836c-642e0b00d543/309be14c1188198e0564a2a47c78ab0f/roslyn-3.0.0-preview6-symbols.zip
[standard-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/839250d9-9fcc-4546-a157-b31a96874a72/324c581c910eca2df761354077c93f4d/standard-3.0.0-preview6-symbols.zip
[templating-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ee6fd854-d860-4240-8455-fd2d5c231a11/a89c24d480e0b652fd1bc8b8a0290b8c/templating-3.0.0-preview6-symbols.zip
[visualfsharp-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/ce96faec-2171-42f6-87ca-a97dd077d3eb/2ee84b1e28dd92c55d4a557046213904/visualfsharp-3.0.0-preview6-symbols.zip
[websdk-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/3cfe6b47-dc4a-4ae8-b3c7-19c10e5ad001/3883444ce919e9a396663122ea0e1990/websdk-3.0.0-preview6-symbols.zip
[winforms-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/0e06800a-f7e4-4928-8870-2ddb84b294b2/f6ee3167a9fc8b8169c15284a4dbcbf3/winforms-3.0.0-preview6-symbols.zip
[wpf-symbols.zip]: https://download.visualstudio.microsoft.com/download/pr/b7af603b-03aa-441f-ab22-de51f5e2ce0c/ad37eb0f33e27c41b91605b22f967f3d/wpf-3.0.0-preview6-symbols.zip

[checksums-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-preview6-27804-01-runtime-sha.txt
[checksums-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.100-preview6-012264-sdk-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/
