# .NET Core 3.0.0 RC 1 - September 16, 2019

.NET Core 3.0.0 RC 1 is available for download and usage in your environment. This release includes .NET Core 3.0.0 RC 1 and .NET Core SDK 3.0.100 RC 1.

**Visual Studio compatibility:** .NET Core 3.0 RC 1 requires Visual Studio 2019 16.3 Preview 4 to take full advantage of all its features. .NET Core 3.0 RC 1 will not work properly in earlier versions of Visual Studio. Visit [Visual Studio Preview](https://visualstudio.microsoft.com/vs/preview/) to learn about VS previews.

* [Changes in this release](#notable-changes-in-300-rc-1)
* [Known issues](3.0.0-preview-known-issues.md)
* [Downloads](https://dotnet.microsoft.com/download/dotnet/3.0)

The .NET Core SDK 3.0.100 RC 1 includes .NET Core 3.0 Runtime so downloading the runtime packages separately is not needed when installing the SDK. After installing the .NET Core SDK 3.0.100 release candidate, the following command will show that you're running version `3.0.100-rc1-014190` of the tools.

`dotnet --version`

Your feedback is important and appreciated. We've created an issue at [dotnet/core #3380](https://github.com/dotnet/core/issues/3380) for your questions and comments.

## Blog Roundup

* [.NET Core 3.0 RC 1][dotnet-blog]
* [ASP.NET Core][aspnet-blog]

## Release metadata (release.json)

The releases.json files (e.g. [3.0 releases.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/3.0/releases.json)) are comprehensive metadata files which capture the details of each .NET Core release. These files, along with the top level [releases-index.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/releases-index.json), are becoming increasingly important .NET Core release assets which you can use to discover details about all .NET Core releases.

These files, one for each major.minor channel (e.g. 2.1, 3.0), are already relied upon by many in the community to detect when updates for .NET Core are available and discover security update information.

### [releases-index.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/releases-index.json)

The index provides summary information concerning the latest release in each version channel and related `releases.json` endpoints for detailed data.

```JSON
{
  "releases-index": [
    {
      "channel-version": "3.0",
      "latest-release": "3.0.0-preview8",
      "latest-release-date": "2019-08-13",
      "security": false,
      "latest-runtime": "3.0.0-preview8-28405-07",
      "latest-sdk": "3.0.100-preview8-013656",
      "product": ".NET Core",
      "support-phase": "preview",
      "eol-date": null,
      "releases.json": "https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/3.0/releases.json"
    },
  ...
```

### [releases.json](https://dotnetcli.blob.core.windows.net/dotnet/release-metadata/2.1/releases.json)

In addition to the summary information described in `release-index.json`, the `release.json` files provide further details for each release including file download endpoints and file hashes for validation.

```JSON
{
    "release-date": "2019-07-09",
    "release-version": "2.1.12",
    "security": true,
    "cve-list": [
    {
        "cve-id": " CVE-2019-1075",
        "cve-url": "https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-1075"
    }
    ],
    "release-notes": "https://github.com/dotnet/core/blob/main/release-notes/2.1/2.1.12/2.1.12.md",
    "runtime": {
      "version": "2.1.12",
      "version-display": "2.1.12",
      "vs-version": "15.9.13, 16.1.3, 16.2.0",
      "files": [
          {
          "name": "dotnet-runtime-linux-arm.tar.gz",
          "rid": "linux-arm",
          "url": "https://download.visualstudio.microsoft.com/download/pr/f759670e-1f8d-4f1a-8eb7-58b95f94c68c/69eca04ca138dc6c3caa160bd1b891d1/dotnet-runtime-2.1.12-linux-arm.tar.gz",
          "hash": "DA041CB2AFA557E70D00039FDDACAFE48DF28B8DA9C06F790CC841ECABA496F00880EF3349731860835007FA12F0AEF7D50D5EB200297AF5E37F4503C62ACECA"
          },
    ...
```

## Docker Images

The [.NET Core Docker images](https://hub.docker.com/r/microsoft/dotnet/) have been updated for this release. Details on our Docker versioning and how to work with the images can be seen in ["Staying up-to-date with .NET Container Images"](https://devblogs.microsoft.com/dotnet/staying-up-to-date-with-net-container-images/).

The following repos have been updated

* [microsoft/dotnet](https://hub.docker.com/r/microsoft/dotnet)
* [microsoft/dotnet-samples](https://hub.docker.com/r/microsoft/dotnet-samples)

## Notable Changes in 3.0.0 RC 1

Here are some of the additions and updates we're excited to bring in RC 1. See the [.NET][dotnet-blog] and [ASP.NET Core][aspnet-blog] blogs for additional details.

* CoreCLR: [bugs][coreclr_bugs] | [features][coreclr_features]
* CoreFX: [bugs][corefx_bugs] | [features][corefx_features]
* ASP.NET Core: [bugs][aspnet_bugs] | [features][aspnet_features]
* [API Changes in RC1](https://github.com/dotnet/core/tree/main/release-notes/3.0/preview/api-diff/rc1)

[blob-runtime]: https://dotnetcli.blob.core.windows.net/dotnet/Runtime/
[blob-sdk]: https://dotnetcli.blob.core.windows.net/dotnet/Sdk/
[release-notes]: 3.0.0-rc1.md

[//]: # ( Runtime 3.0.0-rc1-19456-20)
[dotnet-apphost-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/89570818-e9d7-4fd4-9294-9cefb961b4a1/c27f37b6e49974e52fcca3df1cc67de2/dotnet-apphost-pack-3.0.0-rc1-19456-20-x64.deb
[dotnet-apphost-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ee59eeb8-096e-4240-a77f-6740f3a2b3d5/488007e8860a0f57210b5fda20f0fb5c/dotnet-apphost-pack-3.0.0-rc1-19456-20-x64.rpm
[dotnet-host-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/ae53cfed-94d3-4078-aa32-10dd16bfe3fa/89868caf9123d393e815d196e6656d92/dotnet-host-3.0.0-rc1-19456-20-x64.deb
[dotnet-host-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/6041b5bb-da62-4e25-b298-c89cc41e079e/f8d1fd691b9e66fe0ca5b82a0716930a/dotnet-host-3.0.0-rc1-19456-20-x64.rpm
[dotnet-hostfxr-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/3d853a76-4e0c-4eb9-a851-b2145ee2c53f/ecf53f04c9c8716e01fc8d069a5d3b72/dotnet-hostfxr-3.0.0-rc1-19456-20-x64.deb
[dotnet-hostfxr-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/d08b2f78-2266-47ad-a799-fdb6e454d59c/c5a0e7c4ebd46ee0947e5a5ec99dbab6/dotnet-hostfxr-3.0.0-rc1-19456-20-x64.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dd166010-f2af-4f48-9099-c2a8ef2aecd4/b12863ae56d58c2acb453225e06c69b3/dotnet-hosting-3.0.0-rc1.19457.4-win.exe
[dotnet-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/5c2c453a-e032-486a-968b-7ffe40fd936a/55663cb415162575b069059675c008ab/dotnet-runtime-3.0.0-rc1-19456-20-linux-arm.tar.gz
[dotnet-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/406cf025-8333-4f8c-8c0c-6b46c96762a0/dfde31a9f20ef36a2d00abb4060f9220/dotnet-runtime-3.0.0-rc1-19456-20-linux-arm64.tar.gz
[dotnet-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/30782477-d2ab-4b8e-a286-45b9e984667c/a8b8eb519fd35cdbafeb8f207bdb9474/dotnet-runtime-3.0.0-rc1-19456-20-linux-musl-x64.tar.gz
[dotnet-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/f31ff1f4-2d1f-4904-aaec-1e6da1e20390/9da05fe5c414307ef0bf95b1ae330924/dotnet-runtime-3.0.0-rc1-19456-20-linux-x64.tar.gz
[dotnet-runtime-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/ea6e19c6-7d19-4e7a-aecc-51eb67c87ac7/5d58c5eedbf3ace4274e813d991be628/dotnet-runtime-3.0.0-rc1-19456-20-osx-x64.pkg
[dotnet-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c808009-0ac2-4614-827e-e521873e097d/4859fcad472817c5befc500e01a49be8/dotnet-runtime-3.0.0-rc1-19456-20-osx-x64.tar.gz
[dotnet-runtime-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8ee775d6-0e77-4557-8b0d-be9c2a713ac6/52ce6cb274fd0d71ec827abc62bea046/dotnet-runtime-3.0.0-rc1-19456-20-rhel.6-x64.tar.gz
[dotnet-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/14ee3b74-7452-4737-b753-51cb5c2f4bc7/50e6451058272f67a34be8eb43a56e6b/dotnet-runtime-3.0.0-rc1-19456-20-win-arm.zip
[dotnet-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/84f82674-73e8-408c-b29a-988f7ffe7ef6/8fd9c7c5f8b2518401167e53d2705a37/dotnet-runtime-3.0.0-rc1-19456-20-win-x64.exe
[dotnet-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/8691fde3-55fc-46f4-8323-2d57e0cc7c53/a3c9fa0de0e3608e44ed3d0ffdc3ca94/dotnet-runtime-3.0.0-rc1-19456-20-win-x64.zip
[dotnet-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/57f3a4af-5fef-4dc3-8abf-5c5d9fb73b07/19f2a1452f0cb0802ef7d05254ee2618/dotnet-runtime-3.0.0-rc1-19456-20-win-x86.exe
[dotnet-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/aac84824-a146-4083-94d7-a4623f6e0276/d844fdc71427b8703b11ba683c88305a/dotnet-runtime-3.0.0-rc1-19456-20-win-x86.zip
[dotnet-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/edfe9bce-8911-46e7-9ed3-5a7cface108d/66a8bd39eff06ead2a2c73f36ed90a17/dotnet-runtime-3.0.0-rc1-19456-20-x64.deb
[dotnet-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/08241a6b-d96a-4e5a-884f-9cfdc77df116/9917cd10738abcc3bb29436574d4ac76/dotnet-runtime-3.0.0-rc1-19456-20-x64.rpm
[dotnet-runtime-deps-centos.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/29e9f057-7568-4df9-9a1b-1e840d196773/41f32a4125cbfc122ef65a84866c27df/dotnet-runtime-deps-3.0.0-rc1-19456-20-centos.7-x64.rpm
[dotnet-runtime-deps-fedora.27-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/d0bfc23a-0d33-4f05-ae87-e99903180cda/ae3b8c1042223156618986dc4c7a79e6/dotnet-runtime-deps-3.0.0-rc1-19456-20-fedora.27-x64.rpm
[dotnet-runtime-deps-opensuse.42-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/1ce5911a-8dad-445d-9dd8-d0fd43977222/c349792f7612e2204b534a409f6a9012/dotnet-runtime-deps-3.0.0-rc1-19456-20-opensuse.42-x64.rpm
[dotnet-runtime-deps-oraclelinux.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/615ba113-0592-4426-9730-c0c832316c23/6fc48e58d932a71e0c704358018ffde9/dotnet-runtime-deps-3.0.0-rc1-19456-20-oraclelinux.7-x64.rpm
[dotnet-runtime-deps-rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/4c82ab53-0bd8-4f16-8b86-5d61daffdb9f/648462970d7bb241d7aca52ec5503c80/dotnet-runtime-deps-3.0.0-rc1-19456-20-rhel.7-x64.rpm
[dotnet-runtime-deps-sles.12-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/ae7d8c1c-3800-4be0-9098-7f6f4b633fc2/b6ee728d89856858eb8e0fb0abd24703/dotnet-runtime-deps-3.0.0-rc1-19456-20-sles.12-x64.rpm
[dotnet-runtime-deps-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/04881b4d-6976-4cc9-9048-460f48ea8b52/05a454dfd4d1da29ef183ff7fd36332c/dotnet-runtime-deps-3.0.0-rc1-19456-20-x64.deb
[dotnet-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/203f9489-18f5-4236-868d-faf821f4195c/0227368d71addf36cfbe7fb25444ff87/dotnet-targeting-pack-3.0.0-rc1-19456-20-x64.deb
[dotnet-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/f3aed7cd-838b-43a6-8442-0fc5528bc1fa/0f5a233447763101472f4695ba3f3728/dotnet-targeting-pack-3.0.0-rc1-19456-20-x64.rpm
[netstandard-targeting-pack-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/668ce5f8-99a0-42d4-b002-289e7faac539/fc61ec6e4059af4e8561425b4a9e3f34/netstandard-targeting-pack-2.1.0-rc1-19456-20-osx-x64.pkg
[netstandard-targeting-pack-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/678eb2ff-4970-4612-bec0-bd43840bb76d/3396523a99feea58ccb3dfde9761a476/netstandard-targeting-pack-2.1.0-rc1-19456-20-x64.deb
[netstandard-targeting-pack-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/cbb56871-851e-45bc-a8e0-bd36524244ad/3defb6516e3dcacca11f5d0d7fa5d1a6/netstandard-targeting-pack-2.1.0-rc1-19456-20-x64.rpm
[windowsdesktop-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/0f6a4264-38d3-4fd3-bd79-a5ae365963ad/56f0f5fd0c47984447c8355e686da831/windowsdesktop-runtime-3.0.0-rc1-19456-20-win-x64.exe
[windowsdesktop-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/637f32e9-9c56-4e5e-b326-1fe0e7a83f2d/681e986915a6aa8070c1a3589fd70f8a/windowsdesktop-runtime-3.0.0-rc1-19456-20-win-x86.exe

[//]: # ( ASP 3.0.0-rc1.19457.4)
[aspnetcore-runtime-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/c2a57c5e-2955-4815-a26d-591fc7273724/1c2de6c724adef9efb70b18d1fa72339/aspnetcore-runtime-3.0.0-rc1.19457.4-linux-arm.tar.gz
[aspnetcore-runtime-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/58745a66-c144-43d8-aa82-142e5b4f2c16/8cab4ce329f0c156a1d183991f6d3448/aspnetcore-runtime-3.0.0-rc1.19457.4-linux-arm64.tar.gz
[aspnetcore-runtime-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/60036637-9597-4155-a6dd-7c9f6646161d/a549badc03389af1bd96cd3ae781b151/aspnetcore-runtime-3.0.0-rc1.19457.4-linux-musl-x64.tar.gz
[aspnetcore-runtime-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/32664ecb-9181-4b09-8543-e85abae5805e/227658f498f42e5d278f1e41d8f2bcba/aspnetcore-runtime-3.0.0-rc1.19457.4-linux-x64.tar.gz
[aspnetcore-runtime-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/4d3e1e0d-114a-4cc1-b5d7-575b25ba6217/fe9447448c1cf2cd7d29438531714fdc/aspnetcore-runtime-3.0.0-rc1.19457.4-osx-x64.tar.gz
[aspnetcore-runtime-rh.rhel.7-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/4e2b870d-7ebd-441f-8eea-ff4d987ffccf/73cbb931c01adc6e7cd348b5478cc900/aspnetcore-runtime-3.0.0-rc1.19457.4-rh.rhel.7-x64.rpm
[aspnetcore-runtime-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/4d0e94b4-5fe4-4fc5-ba1a-0e6f8db53a2b/999c0a734a5b05c936df5a1526b91f8f/aspnetcore-runtime-3.0.0-rc1.19457.4-win-arm.zip
[aspnetcore-runtime-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/e8813915-1e31-438d-9544-4cb9e8ad2f8b/4ef958d6d5bd63e0203bc537adf4eabf/aspnetcore-runtime-3.0.0-rc1.19457.4-win-x64.exe
[aspnetcore-runtime-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/306ab073-1b21-497b-ae42-5cc795c4e2d6/7a15ae462ee7d603bc2f6b19692abd11/aspnetcore-runtime-3.0.0-rc1.19457.4-win-x64.zip
[aspnetcore-runtime-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/cba49d03-4b3d-4e11-8a59-3eaa35777ac5/3bf53e4d25798a8102f42958798ff694/aspnetcore-runtime-3.0.0-rc1.19457.4-win-x86.exe
[aspnetcore-runtime-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/28707924-b17e-4c00-8e3b-322b44b5d209/b2861043c019ef165bfc5214580bf5b8/aspnetcore-runtime-3.0.0-rc1.19457.4-win-x86.zip
[aspnetcore-runtime-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/c93b2f57-00d9-4e4f-85b9-af7358391b4f/ae897e85f63f502a6b2994b00dacbb71/aspnetcore-runtime-3.0.0-rc1.19457.4-x64.deb
[aspnetcore-runtime-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/cb972d1d-fb43-428f-9a4f-842ab8294f3d/f8f442d75484a37df811cda95dc17346/aspnetcore-runtime-3.0.0-rc1.19457.4-x64.rpm
[aspnetcore-targeting-pack.deb]: https://download.visualstudio.microsoft.com/download/pr/ba4d0236-d8d6-4362-bff8-8099e423b42c/219425842ab4758d33bbedc068aaabb4/aspnetcore-targeting-pack-3.0.0-rc1.19457.4.deb
[aspnetcore-targeting-pack.rpm]: https://download.visualstudio.microsoft.com/download/pr/7be78bb0-be61-4fda-94c9-1d0a71baa564/c3d2b7e18b4471083ff4e6ae7ae4e255/aspnetcore-targeting-pack-3.0.0-rc1.19457.4.rpm
[dotnet-hosting-win.exe]: https://download.visualstudio.microsoft.com/download/pr/dd166010-f2af-4f48-9099-c2a8ef2aecd4/b12863ae56d58c2acb453225e06c69b3/dotnet-hosting-3.0.0-rc1.19457.4-win.exe

[//]: # ( SDK 3.0.100-rc1-014190 )
[dotnet-sdk-linux-arm.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/29f1b10f-758f-44fb-b14c-49833e5379aa/c259e43ccc84a77fdf4ab5feea6774b3/dotnet-sdk-3.0.100-rc1-014190-linux-arm.tar.gz
[dotnet-sdk-linux-arm64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/19cc5d2e-6794-401a-8b57-29a96cbf21b5/f1de24385a2b5a8fcbebab3af9ec07c4/dotnet-sdk-3.0.100-rc1-014190-linux-arm64.tar.gz
[dotnet-sdk-linux-musl-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/8dc8c097-42c9-4f29-ae72-90a32853fc91/a29f57092596e7e4a569ed692529dd27/dotnet-sdk-3.0.100-rc1-014190-linux-musl-x64.tar.gz
[dotnet-sdk-linux-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/b81a2bd3-a8a4-4c7e-bd69-030f412ff7b4/3fc5f2c0481313daf2e18c348362ff3f/dotnet-sdk-3.0.100-rc1-014190-linux-x64.tar.gz
[dotnet-sdk-osx-x64.pkg]: https://download.visualstudio.microsoft.com/download/pr/fa3375a4-e275-4730-ac9c-7521ebd53e0b/f911765e7fa24c37153ab11f453db756/dotnet-sdk-3.0.100-rc1-014190-osx-x64.pkg
[dotnet-sdk-osx-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/33d9625e-88ba-4854-817b-81e436c2cbab/81084c2a1c8b6d5749ea98c19aca7fc6/dotnet-sdk-3.0.100-rc1-014190-osx-x64.tar.gz
[dotnet-sdk-rhel.6-x64.tar.gz]: https://download.visualstudio.microsoft.com/download/pr/2c907fd7-74da-4552-bdd2-9fb0338335bc/999f25064eb476385a893f138503c9ac/dotnet-sdk-3.0.100-rc1-014190-rhel.6-x64.tar.gz
[dotnet-sdk-win-arm.zip]: https://download.visualstudio.microsoft.com/download/pr/9b1b3f16-463c-48f5-b6a8-395d2c48d144/afb7c0cbe4c8e97d032ae3ea8a5e7e7a/dotnet-sdk-3.0.100-rc1-014190-win-arm.zip
[dotnet-sdk-win-x64.exe]: https://download.visualstudio.microsoft.com/download/pr/1dc9d885-52a1-4dec-8e08-2ed214292057/f383194c854a787a4c96403b72ceb738/dotnet-sdk-3.0.100-rc1-014190-win-x64.exe
[dotnet-sdk-win-x64.zip]: https://download.visualstudio.microsoft.com/download/pr/10927870-88e5-4b7d-9a5b-1a7cb46a98c0/c17f892b315e5f44052c30cd2eb21023/dotnet-sdk-3.0.100-rc1-014190-win-x64.zip
[dotnet-sdk-win-x86.exe]: https://download.visualstudio.microsoft.com/download/pr/033aee99-976e-4c8b-ac57-6dd0d1c3f9de/dd83cb8577c32a40a54d904bbda2dc57/dotnet-sdk-3.0.100-rc1-014190-win-x86.exe
[dotnet-sdk-win-x86.zip]: https://download.visualstudio.microsoft.com/download/pr/5b08880a-938d-47a9-88c2-5a4a54e7c405/8180a0c22018c01be4dadf72e5cfb269/dotnet-sdk-3.0.100-rc1-014190-win-x86.zip
[dotnet-sdk-x64.deb]: https://download.visualstudio.microsoft.com/download/pr/545d7ba2-0e87-4117-9556-4e518cf32d91/8291e4e4e32b5d9bf1c4bd0cdea5eb5c/dotnet-sdk-3.0.100-rc1-014190-x64.deb
[dotnet-sdk-x64.rpm]: https://download.visualstudio.microsoft.com/download/pr/13f17368-89a4-41c6-beb4-9da9be2eb581/b836bf1402bba510c7fb8cf2afce3473/dotnet-sdk-3.0.100-rc1-014190-x64.rpm

[checksums]: https://dotnetcli.blob.core.windows.net/dotnet/checksums/3.0.0-rc1-sha.txt

[linux-install]: https://learn.microsoft.com/dotnet/core/install/linux

[dotnet-blog]: https://devblogs.microsoft.com/dotnet/announcing-net-core-3-0-release-candidate-1/
[aspnet-blog]: https://devblogs.microsoft.com/aspnet/asp-net-core-and-blazor-updates-in-net-core-3-0-release-candidate-1/
[ef-blog]: https://devblogs.microsoft.com/dotnet/announcing-entity-framework-core-3-0-rc-1-and-entity-framework-6-3-rc-1

[aspnet_bugs]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0+label%3ADone+label%3Abug
[aspnet_features]: https://github.com/aspnet/AspNetCore/issues?q=is%3Aissue+milestone%3A3.0.0+label%3ADone+label%3Aenhancement
[coreclr_bugs]: https://github.com/dotnet/coreclr/issues?utf8=%E2%9C%93&q=is%3Aissue+milestone%3A3.0+label%3Abug+
[coreclr_features]: https://github.com/dotnet/coreclr/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
[corefx_bugs]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Abug
[corefx_features]: https://github.com/dotnet/corefx/issues?q=is%3Aissue+milestone%3A3.0+label%3Aenhancement
