# System.Text.Json

``` diff
+namespace System.Text.Json {
+    public enum JsonCommentHandling : byte {
+        Allow = (byte)1,
+        Disallow = (byte)0,
+        Skip = (byte)2,
+    }
+    public sealed class JsonReaderException : Exception {
+        public JsonReaderException(string message, long lineNumber, long bytePositionInLine);
+        public long BytePositionInLine { get; }
+        public long LineNumber { get; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+    }
+    public struct JsonReaderOptions {
+        public JsonCommentHandling CommentHandling { get; set; }
+    }
+    public struct JsonReaderState {
+        public JsonReaderState(int maxDepth = 64, JsonReaderOptions options = default(JsonReaderOptions));
+        public long BytesConsumed { get; }
+        public int MaxDepth { get; }
+        public JsonReaderOptions Options { get; }
+        public SequencePosition Position { get; }
+    }
+    public enum JsonTokenType : byte {
+        Comment = (byte)11,
+        EndArray = (byte)4,
+        EndObject = (byte)2,
+        False = (byte)9,
+        None = (byte)0,
+        Null = (byte)10,
+        Number = (byte)7,
+        PropertyName = (byte)5,
+        StartArray = (byte)3,
+        StartObject = (byte)1,
+        String = (byte)6,
+        True = (byte)8,
+    }
+    public ref struct Utf8JsonReader {
+        public Utf8JsonReader(in ReadOnlySequence<byte> jsonData, bool isFinalBlock, JsonReaderState state);
+        public Utf8JsonReader(ReadOnlySpan<byte> jsonData, bool isFinalBlock, JsonReaderState state);
+        public long BytesConsumed { get; }
+        public int CurrentDepth { get; }
+        public JsonReaderState CurrentState { get; }
+        public bool HasValueSequence { get; }
+        public SequencePosition Position { get; }
+        public JsonTokenType TokenType { get; }
+        public ReadOnlySequence<byte> ValueSequence { get; }
+        public ReadOnlySpan<byte> ValueSpan { get; }
+        public bool GetBooleanValue();
+        public string GetStringValue();
+        public bool Read();
+        public bool TryGetDecimalValue(out decimal value);
+        public bool TryGetDoubleValue(out double value);
+        public bool TryGetInt32Value(out int value);
+        public bool TryGetInt64Value(out long value);
+        public bool TryGetSingleValue(out float value);
+    }
+}
```

