# System.Text.Json.Serialization

``` diff
+namespace System.Text.Json.Serialization {
+    public static class JsonSerializer {
+        public static object Parse(ReadOnlySpan<byte> utf8Json, Type returnType, JsonSerializerOptions options = null);
+        public static object Parse(string json, Type returnType, JsonSerializerOptions options = null);
+        public static TValue Parse<TValue>(ReadOnlySpan<byte> utf8Json, JsonSerializerOptions options = null);
+        public static TValue Parse<TValue>(string json, JsonSerializerOptions options = null);
+        public static ValueTask<object> ReadAsync(Stream utf8Json, Type returnType, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static ValueTask<TValue> ReadAsync<TValue>(Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static byte[] ToBytes(object value, Type type, JsonSerializerOptions options = null);
+        public static byte[] ToBytes<TValue>(TValue value, JsonSerializerOptions options = null);
+        public static string ToString(object value, Type type, JsonSerializerOptions options = null);
+        public static string ToString<TValue>(TValue value, JsonSerializerOptions options = null);
+        public static Task WriteAsync(object value, Type type, Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+        public static Task WriteAsync<TValue>(TValue value, Stream utf8Json, JsonSerializerOptions options = null, CancellationToken cancellationToken = default(CancellationToken));
+    }
+    public sealed class JsonSerializerOptions {
+        public JsonSerializerOptions();
+        public int DefaultBufferSize { get; set; }
+        public bool IgnoreNullPropertyValueOnRead { get; set; }
+        public bool IgnoreNullPropertyValueOnWrite { get; set; }
+        public JsonReaderOptions ReaderOptions { get; set; }
+        public JsonWriterOptions WriterOptions { get; set; }
+    }
+}
```

