# System.Text

``` diff
 namespace System.Text {
     public readonly struct Rune : IComparable<Rune>, IEquatable<Rune> {
+        public Rune(char highSurrogate, char lowSurrogate);
+        public static OperationStatus DecodeFromUtf16(ReadOnlySpan<char> source, out Rune result, out int charsConsumed);
+        public static OperationStatus DecodeFromUtf8(ReadOnlySpan<byte> source, out Rune result, out int bytesConsumed);
+        public static OperationStatus DecodeLastFromUtf16(ReadOnlySpan<char> source, out Rune result, out int charsConsumed);
+        public static OperationStatus DecodeLastFromUtf8(ReadOnlySpan<byte> source, out Rune value, out int bytesConsumed);
+        public int EncodeToUtf16(Span<char> destination);
+        public int EncodeToUtf8(Span<byte> destination);
+        public static bool TryCreate(char highSurrogate, char lowSurrogate, out Rune result);
-        public bool TryEncode(Span<char> destination, out int charsWritten);

+        public bool TryEncodeToUtf16(Span<char> destination, out int charsWritten);
+        public bool TryEncodeToUtf8(Span<byte> destination, out int bytesWritten);
     }
 }
```

