# System.Numerics

``` diff
 namespace System.Numerics {
     public static class BitOperations {
-        public static uint RotateLeft(uint value, int bitOffset);
+        public static uint RotateLeft(uint value, int offset);
-        public static ulong RotateLeft(ulong value, int bitOffset);
+        public static ulong RotateLeft(ulong value, int offset);
-        public static uint RotateRight(uint value, int bitOffset);
+        public static uint RotateRight(uint value, int offset);
-        public static ulong RotateRight(ulong value, int bitOffset);
+        public static ulong RotateRight(ulong value, int offset);
     }
     public struct Vector<T> : IEquatable<Vector<T>>, IFormattable where T : struct {
+        public Vector(ReadOnlySpan<byte> values);
+        public Vector(ReadOnlySpan<T> values);
+        public void CopyTo(Span<byte> destination);
+        public void CopyTo(Span<T> destination);
+        public bool TryCopyTo(Span<byte> destination);
+        public bool TryCopyTo(Span<T> destination);
     }
 }
```

